package com.tencent.start.cgs;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarLibLoader {

    private static final String RES_PROTOCOL_NAME = "res";
    private static final String RES_PROTOCOL = "res:";

    private static class JarLibURLStreamHandlerFactory implements URLStreamHandlerFactory {

        private final ClassLoader mClassLoader;

        private class JarLibURLStreamHandler extends URLStreamHandler {

            @Override
            protected URLConnection openConnection(final URL u) {
                //System.out.println("-- [DEBUG] openConnection: " + u.toString());
                return new URLConnection(u) {

                    public String getFilePath() throws UnsupportedEncodingException {
                        String filePath = URLDecoder.decode(url.getFile(), StandardCharsets.UTF_8.name());
                        //System.out.println("-- [DEBUG] getFilePath: " + filePath);
                        return filePath;
                    }

                    @Override
                    public void connect() {
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        InputStream result = mClassLoader.getResourceAsStream(getFilePath());
                        if (result == null) {
                            throw new MalformedURLException("Resource not found: " + url);
                        }
                        return result;
                    }
                };
            }
        }

        private JarLibURLStreamHandlerFactory(ClassLoader cl) {
            mClassLoader = cl;
        }

        @Override
        public URLStreamHandler createURLStreamHandler(final String protocol) {
            return RES_PROTOCOL_NAME.equals(protocol) ? new JarLibURLStreamHandler() : null;
        }
    }

    private static URL[] getUrls() {
        ArrayList<URL> urls = new ArrayList<>(4);
        String currentJarPath = JarLibLoader.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        try {
            urls.add(new URL(RES_PROTOCOL + "./"));
            try (ZipFile jarFile = new ZipFile(currentJarPath)) {
                Enumeration<? extends ZipEntry> en = jarFile.entries();
                while (en.hasMoreElements()) {
                    ZipEntry entry = en.nextElement();
                    if (!entry.isDirectory() && entry.getName().startsWith("lib/")) {
                        urls.add(new URL("jar:" + RES_PROTOCOL + entry.getName() + "!/"));
                    }
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        //System.out.println("-- [DEBUG] getLibUrls: " + urls.toString());
        return urls.toArray(new URL[urls.size()]);
    }

    public static void main(String[] args) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL.setURLStreamHandlerFactory(new JarLibURLStreamHandlerFactory(classLoader));
        ClassLoader newClassLoader = new URLClassLoader(getUrls(), null);
        Thread.currentThread().setContextClassLoader(newClassLoader);
        Class.forName("com.tencent.start.cgs.tools.App", true, newClassLoader)
                .getMethod("main", new Class[] { args.getClass() })
                .invoke(null, new Object[] { args });
    }
}

