/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import com.martiansoftware.jsap.CommandLineTokenizer;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCommandLineTokenizer
extends TestCase {
    public static Test suite() {
        return new TestSuite(TestCommandLineTokenizer.class);
    }

    public void test1() {
        String string = "this is a test";
        String[] stringArray = CommandLineTokenizer.tokenize(string);
        TestCommandLineTokenizer.assertEquals((int)4, (int)stringArray.length);
        TestCommandLineTokenizer.assertEquals((String)"this", (String)stringArray[0]);
        TestCommandLineTokenizer.assertEquals((String)"is", (String)stringArray[1]);
        TestCommandLineTokenizer.assertEquals((String)"a", (String)stringArray[2]);
        TestCommandLineTokenizer.assertEquals((String)"test", (String)stringArray[3]);
    }

    public void test2() {
        String string = "";
        String[] stringArray = CommandLineTokenizer.tokenize("this is a \"test\"");
        TestCommandLineTokenizer.assertEquals((int)4, (int)stringArray.length);
        TestCommandLineTokenizer.assertEquals((String)"this", (String)stringArray[0]);
        TestCommandLineTokenizer.assertEquals((String)"is", (String)stringArray[1]);
        TestCommandLineTokenizer.assertEquals((String)"a", (String)stringArray[2]);
        TestCommandLineTokenizer.assertEquals((String)"test", (String)stringArray[3]);
    }

    public void test3() {
        String string = "\"this is a test\"";
        String[] stringArray = CommandLineTokenizer.tokenize(string);
        TestCommandLineTokenizer.assertEquals((int)1, (int)stringArray.length);
        TestCommandLineTokenizer.assertEquals((String)"this is a test", (String)stringArray[0]);
    }

    public void test4() {
        String string = "this is a \"test";
        String[] stringArray = CommandLineTokenizer.tokenize(string);
        TestCommandLineTokenizer.assertEquals((int)4, (int)stringArray.length);
        TestCommandLineTokenizer.assertEquals((String)"this", (String)stringArray[0]);
        TestCommandLineTokenizer.assertEquals((String)"is", (String)stringArray[1]);
        TestCommandLineTokenizer.assertEquals((String)"a", (String)stringArray[2]);
        TestCommandLineTokenizer.assertEquals((String)"test", (String)stringArray[3]);
    }

    public void test5() {
        String string = "thi\\s is a \\\"test";
        String[] stringArray = CommandLineTokenizer.tokenize(string);
        TestCommandLineTokenizer.assertEquals((int)4, (int)stringArray.length);
        TestCommandLineTokenizer.assertEquals((String)"thi\\s", (String)stringArray[0]);
        TestCommandLineTokenizer.assertEquals((String)"is", (String)stringArray[1]);
        TestCommandLineTokenizer.assertEquals((String)"a", (String)stringArray[2]);
        TestCommandLineTokenizer.assertEquals((String)"\"test", (String)stringArray[3]);
    }

    public void test6() {
        String string = "thi\\s is a \\\"test\\";
        String[] stringArray = CommandLineTokenizer.tokenize(string);
        TestCommandLineTokenizer.assertEquals((int)4, (int)stringArray.length);
        TestCommandLineTokenizer.assertEquals((String)"thi\\s", (String)stringArray[0]);
        TestCommandLineTokenizer.assertEquals((String)"is", (String)stringArray[1]);
        TestCommandLineTokenizer.assertEquals((String)"a", (String)stringArray[2]);
        TestCommandLineTokenizer.assertEquals((String)"\"test\\", (String)stringArray[3]);
    }

    public void test7() {
        String string = "thi\\s is a \\\"test\\\\\"";
        String[] stringArray = CommandLineTokenizer.tokenize(string);
        TestCommandLineTokenizer.assertEquals((int)4, (int)stringArray.length);
        TestCommandLineTokenizer.assertEquals((String)"thi\\s", (String)stringArray[0]);
        TestCommandLineTokenizer.assertEquals((String)"is", (String)stringArray[1]);
        TestCommandLineTokenizer.assertEquals((String)"a", (String)stringArray[2]);
        TestCommandLineTokenizer.assertEquals((String)"\"test\\", (String)stringArray[3]);
    }

    public void test8() {
        String[] stringArray = CommandLineTokenizer.tokenize(null);
        TestCommandLineTokenizer.assertEquals((int)0, (int)stringArray.length);
    }

    public void test9() {
        String string = "   \t\t  \t ";
        String[] stringArray = CommandLineTokenizer.tokenize(string);
        TestCommandLineTokenizer.assertEquals((int)0, (int)stringArray.length);
    }

    public void test10() {
        String string = "\"this is a test";
        String[] stringArray = CommandLineTokenizer.tokenize(string);
        TestCommandLineTokenizer.assertEquals((int)1, (int)stringArray.length);
        TestCommandLineTokenizer.assertEquals((String)"this is a test", (String)stringArray[0]);
    }

    public static void main(String[] stringArray) {
        System.out.println("public void testXXX(){");
        System.out.println("\tString cmdLine = \"\";");
        System.out.println("\tString[] tokens = CommandLineTokenizer.tokenize(cmdLine);");
        System.out.println("\n");
        System.out.println("\tassertEquals(" + stringArray.length + ", tokens.length);\n");
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("\tassertEquals(\"" + stringArray[i] + "\", tokens[" + i + "]);");
        }
        System.out.println("}");
    }
}

