/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.waterfallmc.waterfall.conf.WaterfallConfiguration;
import io.github.waterfallmc.waterfall.event.ProxyExceptionEvent;
import io.github.waterfallmc.waterfall.exception.ProxyPluginEnableDisableException;
import io.github.waterfallmc.waterfall.log4j.WaterfallLogger;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.util.ResourceLeakDetector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.BungeeTitle;
import net.md_5.bungee.ConnectionThrottle;
import net.md_5.bungee.EncryptionUtil;
import net.md_5.bungee.PlayerInfoSerializer;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.Favicon;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ReconnectHandler;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.Title;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentStyle;
import net.md_5.bungee.api.chat.KeybindComponent;
import net.md_5.bungee.api.chat.ScoreComponent;
import net.md_5.bungee.api.chat.SelectorComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import net.md_5.bungee.api.config.ConfigurationAdapter;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginManager;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.chat.ComponentStyleSerializer;
import net.md_5.bungee.chat.KeybindComponentSerializer;
import net.md_5.bungee.chat.ScoreComponentSerializer;
import net.md_5.bungee.chat.SelectorComponentSerializer;
import net.md_5.bungee.chat.TextComponentSerializer;
import net.md_5.bungee.chat.TranslatableComponentSerializer;
import net.md_5.bungee.command.CommandBungee;
import net.md_5.bungee.command.CommandEnd;
import net.md_5.bungee.command.CommandIP;
import net.md_5.bungee.command.CommandPerms;
import net.md_5.bungee.command.ConsoleCommandSender;
import net.md_5.bungee.conf.Configuration;
import net.md_5.bungee.netty.PipelineUtils;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.query.RemoteQuery;
import net.md_5.bungee.scheduler.BungeeScheduler;
import net.md_5.bungee.util.CaseInsensitiveMap;
import net.shieldcommunity.nullcordx.NullCordXException;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.NullCordXLogger;
import net.shieldcommunity.nullcordx.api.NullCordXApi;
import net.shieldcommunity.nullcordx.api.config.messages.LanguageType;
import net.shieldcommunity.nullcordx.api.config.messages.MessagesSettings;
import net.shieldcommunity.nullcordx.api.events.NullCordXReloadEvent;
import net.shieldcommunity.nullcordx.chat.modern.CustomSelfSerializable;
import net.shieldcommunity.nullcordx.chat.modern.ReadyComponentMessage;
import net.shieldcommunity.nullcordx.commands.CommandPlugins;
import net.shieldcommunity.nullcordx.commands.proxy.CommandProxyExecutor;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.config.CustomYamlConfig;
import net.shieldcommunity.nullcordx.libs.google.inject.AbstractModule;
import net.shieldcommunity.nullcordx.libs.google.inject.Guice;
import net.shieldcommunity.nullcordx.libs.google.inject.Injector;

public class BungeeCord
extends ProxyServer {
    public volatile boolean isRunning;
    private boolean enabled;
    public final Configuration config = new WaterfallConfiguration();
    @Deprecated
    private Map<String, Format> messageFormats;
    public EventLoopGroup bossEventLoopGroup;
    public EventLoopGroup workerEventLoopGroup;
    public EventLoopGroup queryEventLoopGroup;
    private final Timer saveThread = new Timer("Reconnect Saver");
    private final Collection<Channel> listeners = new HashSet<Channel>();
    private final Map<String, UserConnection> connections = new CaseInsensitiveMap<UserConnection>();
    private final Map<UUID, UserConnection> connectionsByOfflineUUID = new HashMap<UUID, UserConnection>();
    private final Map<UUID, UserConnection> connectionsByUUID = new HashMap<UUID, UserConnection>();
    private final ReadWriteLock connectionLock = new ReentrantReadWriteLock();
    private final ReentrantLock shutdownLock = new ReentrantLock();
    public final PluginManager pluginManager;
    private ReconnectHandler reconnectHandler;
    private ConfigurationAdapter configurationAdapter = new CustomYamlConfig();
    private final Collection<String> pluginChannels = new HashSet<String>();
    private final File pluginsFolder = new File("plugins");
    private final BungeeScheduler scheduler = new BungeeScheduler();
    private final Logger logger;
    private final NullCordXLogger nullcordxLogger;
    public final Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)BaseComponent.class), new ComponentSerializer()).registerTypeAdapter((Type)((Object)TextComponent.class), new TextComponentSerializer()).registerTypeAdapter((Type)((Object)TranslatableComponent.class), new TranslatableComponentSerializer()).registerTypeAdapter((Type)((Object)KeybindComponent.class), new KeybindComponentSerializer()).registerTypeAdapter((Type)((Object)ScoreComponent.class), new ScoreComponentSerializer()).registerTypeAdapter((Type)((Object)SelectorComponent.class), new SelectorComponentSerializer()).registerTypeAdapter((Type)((Object)ComponentStyle.class), new ComponentStyleSerializer()).registerTypeAdapter((Type)((Object)ServerPing.PlayerInfo.class), new PlayerInfoSerializer()).registerTypeAdapter((Type)((Object)Favicon.class), Favicon.getFaviconTypeAdapter()).registerTypeAdapterFactory(new CustomSelfSerializable.CustomAdapterFactory()).create();
    private ConnectionThrottle connectionThrottle;
    private String nameWithVersion;
    private NullCordXImpl nullCordX;
    private final ReadWriteLock nullCordXLock = new ReentrantReadWriteLock();
    public static final long UPTIME = System.currentTimeMillis();

    public static BungeeCord getInstance() {
        return (BungeeCord)ProxyServer.getInstance();
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    public BungeeCord() throws IOException {
        this.registerChannel("BungeeCord");
        Preconditions.checkState(new File(".").getAbsolutePath().indexOf(33) == -1, "Cannot use NullCordX in directory with ! in path.");
        this.logger = WaterfallLogger.create();
        this.nullcordxLogger = new NullCordXLogger(this.logger);
        this.logger.log(Level.INFO, "Using configuration system powered by Elytrium - https://github.com/Elytrium/java-serializer");
        this.pluginManager = new PluginManager(this);
        this.getPluginManager().registerCommand(null, new CommandEnd());
        this.getPluginManager().registerCommand(null, new CommandIP());
        this.getPluginManager().registerCommand(null, new CommandBungee());
        this.getPluginManager().registerCommand(null, new CommandPerms());
        this.getPluginManager().registerCommand(null, new CommandProxyExecutor(this.nullcordxLogger));
        this.getPluginManager().registerCommand(null, new CommandPlugins());
        if (EncryptionUtil.nativeFactory.load()) {
            this.logger.info("Using mbed TLS based native cipher.");
        } else {
            this.logger.info("Using standard Java JCE cipher, this is bad. NullCordX works better on Linux");
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public void start() throws Exception {
        System.setProperty("io.netty.selectorAutoRebuildThreshold", "0");
        if (System.getProperty("io.netty.leakDetectionLevel") == null && System.getProperty("io.netty.leakDetection.level") == null) {
            ResourceLeakDetector.setLevel(ResourceLeakDetector.Level.DISABLED);
        }
        this.config.load();
        this.loadNullCordXStartup();
        this.bossEventLoopGroup = PipelineUtils.newEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Boss IO Thread #%1$d").build());
        this.workerEventLoopGroup = PipelineUtils.newEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Worker IO Thread #%1$d").build());
        this.queryEventLoopGroup = PipelineUtils.newEventLoopGroup(1, new ThreadFactoryBuilder().setNameFormat("Query Netty IO Thread #%1$d").build());
        this.pluginsFolder.mkdir();
        File nullCordXBridgeFile = new File("plugins", "NullCordX-Bridge.jar");
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("NullCordX-Bridge.jar.tmp");){
            Files.copy(is, nullCordXBridgeFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        this.pluginManager.detectPlugins(this.pluginsFolder);
        this.pluginManager.loadPlugins();
        this.nameWithVersion = this.getName() + " " + this.getGameVersion();
        if (this.config.isForgeSupport()) {
            this.registerChannel("FML");
            this.registerChannel("FML|HS");
            this.registerChannel("FORGE");
        }
        this.isRunning = true;
        this.pluginManager.enablePlugins();
        if (this.config.getThrottle() > 0) {
            this.connectionThrottle = new ConnectionThrottle(this.config.getThrottle(), this.config.getThrottleLimit());
        }
        this.startListeners();
        this.saveThread.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (BungeeCord.this.getReconnectHandler() != null) {
                    BungeeCord.this.getReconnectHandler().save();
                }
            }
        }, 0L, TimeUnit.MINUTES.toMillis(5L));
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.independentThreadStop(this.getTranslation("restart", new Object[]{null}), false)));
        this.enabled = true;
    }

    public void reloadNullCordX() {
        if (!this.isRunning) {
            return;
        }
        if (!this.nullCordXLock.writeLock().tryLock()) {
            throw new NullCordXException("NullCordX already loading!");
        }
        try {
            NullCordXImpl currentInstance = this.nullCordX;
            if (currentInstance != null) {
                currentInstance.unload();
            }
            NullCordXImpl newInstance = this.loadNullCordX();
            this.pluginManager.callEvent(new NullCordXReloadEvent(newInstance));
        }
        finally {
            this.nullCordXLock.writeLock().unlock();
        }
    }

    private NullCordXImpl loadNullCordX() {
        NullCordXImpl instance;
        this.nullCordX = instance = BungeeCord.createNullCordX();
        NullCordXApi.setInstance(instance);
        instance.load(false);
        instance.asyncLoad();
        return instance;
    }

    private void loadNullCordXStartup() {
        try {
            NullCordXImpl instance;
            this.nullCordXLock.writeLock().lock();
            this.nullCordX = instance = BungeeCord.createNullCordX();
            NullCordXApi.setInstance(instance);
            instance.load(true);
            Thread thread = new Thread(instance::asyncLoad);
            thread.setName("NullCordX-startup");
            thread.start();
        }
        finally {
            this.nullCordXLock.writeLock().unlock();
        }
    }

    private static NullCordXImpl createNullCordX() {
        AbstractModule module = new AbstractModule(){

            @Override
            public void configure() {
                this.bind(NullCordXLogger.class).toInstance(BungeeCord.getInstance().getNullcordxLogger());
            }
        };
        Injector injector = Guice.createInjector(module);
        return injector.getInstance(NullCordXImpl.class);
    }

    public void startListeners() {
        for (ListenerInfo info : this.config.getListeners()) {
            if (info.isProxyProtocol()) {
                this.nullCordX.getLogger().log(Level.WARNING, "Using PROXY protocol for listener {0}, please ensure this listener is adequately firewalled.", info.getSocketAddress());
                this.nullCordX.getLogger().log(Level.INFO, "Starting earlier HAProxyConnectionInitEvent. Called when the HAProxy message for a connection has been decoded");
                if (this.connectionThrottle != null) {
                    this.connectionThrottle = null;
                    this.nullCordX.getLogger().log(Level.WARNING, "Since PROXY protocol is in use, internal connection throttle has been disabled.");
                }
            }
            ChannelFutureListener listener = future -> {
                if (future.isSuccess()) {
                    this.listeners.add(future.channel());
                    this.getLogger().log(Level.INFO, "Listening on {0}", info.getSocketAddress());
                } else {
                    this.getLogger().log(Level.WARNING, "Could not bind to host " + info.getSocketAddress(), future.cause());
                }
            };
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channelFactory(PipelineUtils.getServerChannelFactory(info.getSocketAddress()))).option(ChannelOption.SO_REUSEADDR, true)).childAttr(PipelineUtils.LISTENER, info).childHandler(PipelineUtils.SERVER_CHILD).group(this.bossEventLoopGroup, this.workerEventLoopGroup).localAddress(info.getSocketAddress())).bind().addListener(listener);
            if (!info.isQueryEnabled()) continue;
            Preconditions.checkArgument(info.getSocketAddress() instanceof InetSocketAddress, "Can only create query listener on UDP address");
            ChannelFutureListener bindListener = future -> {
                if (future.isSuccess()) {
                    this.listeners.add(future.channel());
                    this.getLogger().log(Level.INFO, "Started query on {0}", future.channel().localAddress());
                } else {
                    this.getLogger().log(Level.WARNING, "Could not bind to host " + info.getSocketAddress(), future.cause());
                }
            };
            new RemoteQuery(this, info).start(PipelineUtils.getDatagramChannelFactory(), new InetSocketAddress(info.getHost().getAddress(), info.getQueryPort()), this.queryEventLoopGroup, bindListener);
        }
    }

    public void stopListeners() {
        for (Channel listener : this.listeners) {
            this.getLogger().log(Level.INFO, "Closing listener {0}", listener);
            try {
                listener.close().syncUninterruptibly();
            }
            catch (ChannelException ex) {
                this.getLogger().severe("Could not close listen thread");
            }
        }
        this.listeners.clear();
    }

    @Override
    public void stop() {
        this.stop(this.getTranslation("restart", new Object[]{null}));
    }

    @Override
    public void stop(final String reason) {
        new Thread("Shutdown Thread"){

            @Override
            public void run() {
                BungeeCord.this.independentThreadStop(reason, true);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DM_EXIT"})
    private void independentThreadStop(String reason, boolean callSystemExit) {
        block22: {
            this.shutdownLock.lock();
            if (!this.isRunning) {
                this.shutdownLock.unlock();
                return;
            }
            this.isRunning = false;
            try {
                if (!this.nullCordXLock.writeLock().tryLock()) break block22;
                try {
                    this.nullCordX.unload();
                }
                finally {
                    this.nullCordXLock.writeLock().unlock();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.stopListeners();
        this.getLogger().info("Closing pending connections");
        this.connectionLock.readLock().lock();
        try {
            this.getLogger().log(Level.INFO, "Cleaning {0} connections", this.connections.size());
            for (UserConnection user : this.connections.values()) {
                user.disconnect(reason);
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.reconnectHandler != null) {
            this.getLogger().info("Saving reconnect locations");
            this.reconnectHandler.save();
            this.reconnectHandler.close();
        }
        this.getLogger().info("Disabling plugins");
        for (Plugin plugin : Lists.reverse(new ArrayList<Plugin>(this.pluginManager.getPlugins()))) {
            try {
                plugin.onDisable();
                for (Handler handler : plugin.getLogger().getHandlers()) {
                    handler.close();
                }
            }
            catch (Throwable t2) {
                String string = "Exception disabling plugin " + plugin.getDescription().getName();
                this.getLogger().log(Level.SEVERE, string, t2);
                this.pluginManager.callEvent(new ProxyExceptionEvent(new ProxyPluginEnableDisableException(string, t2, plugin)));
            }
            this.getScheduler().cancel(plugin);
            plugin.getExecutorService().shutdownNow();
        }
        this.getLogger().info("Closing IO threads");
        this.bossEventLoopGroup.shutdownGracefully();
        this.workerEventLoopGroup.shutdownGracefully();
        this.queryEventLoopGroup.shutdownGracefully();
        while (true) {
            try {
                this.bossEventLoopGroup.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                this.workerEventLoopGroup.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                this.queryEventLoopGroup.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        this.getLogger().info("Thank you and goodbye");
        for (Iterator<Object> iterator : this.getLogger().getHandlers()) {
            ((Handler)((Object)iterator)).close();
        }
        this.shutdownLock.unlock();
        if (callSystemExit) {
            System.exit(0);
        }
    }

    @Override
    public void setReconnectHandler(ReconnectHandler handler) {
        ReconnectHandler currentHandler = this.reconnectHandler;
        if (currentHandler != null) {
            currentHandler.save();
            currentHandler.close();
        }
        this.reconnectHandler = handler;
    }

    @Override
    public Map<String, ServerInfo> getServersCopy() {
        return this.config.getServersCopy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void broadcast(DefinedPacket packet) {
        this.connectionLock.readLock().lock();
        try {
            for (UserConnection con : this.connections.values()) {
                con.unsafe().sendPacket(packet);
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    public String getName() {
        return "NullCordX";
    }

    @Override
    public String getVersion() {
        return BungeeCord.class.getPackage().getImplementationVersion() == null ? "unknown" : BungeeCord.class.getPackage().getImplementationVersion();
    }

    @Deprecated
    public final void reloadMessages() {
    }

    @Deprecated
    private void cacheResourceBundle(Map<String, Format> map, ResourceBundle resourceBundle) {
        Enumeration<String> keys = resourceBundle.getKeys();
        while (keys.hasMoreElements()) {
            map.computeIfAbsent(keys.nextElement(), key -> new MessageFormat(resourceBundle.getString((String)key)));
        }
    }

    @Override
    public String getTranslation(String name, Object ... args) {
        return this.getTranslationComponent(name, this.nullCordX.getLanguageManager().getDefaultLanguage()).toLegacyText();
    }

    @Override
    public ReadyComponentMessage getTranslationComponent(String name) {
        return this.getTranslationComponent(name, this.nullCordX.getLanguageManager().getDefaultLanguage());
    }

    @Override
    public ReadyComponentMessage getTranslationComponent(String name, LanguageType type) {
        MessagesSettings messagesSettings = this.nullCordX.getLanguageManager().getMessagesSettingsByLanguage(type);
        ReadyComponentMessage readyComponentMessage = messagesSettings.MESSAGES.BUNGEECORD.getComponentMessage(name);
        if (readyComponentMessage != null) {
            return readyComponentMessage;
        }
        return new ReadyComponentMessage("<translation '" + name + "' missing>");
    }

    @Override
    public Collection<ProxiedPlayer> getPlayers() {
        this.connectionLock.readLock().lock();
        try {
            Collection<ProxiedPlayer> collection = Collections.unmodifiableCollection(new HashSet<UserConnection>(this.connections.values()));
            return collection;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    public int getOnlineCount() {
        return this.connections.size();
    }

    @Override
    public int fakeOnlineCount(boolean fake) {
        int online = this.connections.size();
        NullCordXImpl nullCordXInst = this.nullCordX;
        if (nullCordXInst != null) {
            if (AntibotSettings.IMP.ANTIBOT.SHOW_ONLINE) {
                online += nullCordXInst.getUserManager().getAllCheckingUsers().size();
            }
            if (fake) {
                online = nullCordXInst.getPlayerCountBoosterUtil().getFakeOnline(online);
            }
        }
        return online;
    }

    @Override
    public ProxiedPlayer getPlayer(String name) {
        this.connectionLock.readLock().lock();
        try {
            ProxiedPlayer proxiedPlayer = this.connections.get(name);
            return proxiedPlayer;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    public UserConnection getUserConnection(String name) {
        this.connectionLock.readLock().lock();
        try {
            UserConnection userConnection = this.connections.get(name);
            return userConnection;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    public UserConnection getPlayerByOfflineUUID(UUID uuid) {
        if (uuid.version() != 3) {
            return null;
        }
        this.connectionLock.readLock().lock();
        try {
            UserConnection userConnection = this.connectionsByOfflineUUID.get(uuid);
            return userConnection;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    public ProxiedPlayer getPlayer(UUID uuid) {
        this.connectionLock.readLock().lock();
        try {
            ProxiedPlayer proxiedPlayer = this.connectionsByUUID.get(uuid);
            return proxiedPlayer;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    public UserConnection getUserConnection(UUID uuid) {
        this.connectionLock.readLock().lock();
        try {
            UserConnection userConnection = this.connectionsByUUID.get(uuid);
            return userConnection;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    public Map<String, ServerInfo> getServers() {
        return this.config.getServers();
    }

    @Override
    public ServerInfo getServerInfo(String name) {
        return this.config.getServerInfo(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerChannel(String channel) {
        Collection<String> collection = this.pluginChannels;
        synchronized (collection) {
            this.pluginChannels.add(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterChannel(String channel) {
        Collection<String> collection = this.pluginChannels;
        synchronized (collection) {
            this.pluginChannels.remove(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getChannels() {
        Collection<String> collection = this.pluginChannels;
        synchronized (collection) {
            return Collections.unmodifiableCollection(this.pluginChannels);
        }
    }

    public PluginMessage registerChannels(int protocolVersion) {
        if (protocolVersion >= 393) {
            return new PluginMessage("minecraft:register", this.pluginChannels.stream().map(PluginMessage.MODERNISE).collect(Collectors.joining("\u0000")).getBytes(StandardCharsets.UTF_8), false);
        }
        return new PluginMessage("REGISTER", String.join((CharSequence)"\u0000", this.pluginChannels).getBytes(StandardCharsets.UTF_8), false);
    }

    @Override
    public int getProtocolVersion() {
        return ProtocolConstants.SUPPORTED_VERSION_IDS_CHANGED.get(ProtocolConstants.SUPPORTED_VERSION_IDS_CHANGED.size() - 1);
    }

    @Override
    public String getGameVersion() {
        return this.getConfig().getGameVersion();
    }

    @Override
    public ServerInfo constructServerInfo(String name, InetSocketAddress address, String motd, boolean restricted) {
        return this.constructServerInfo(name, (SocketAddress)address, motd, restricted);
    }

    @Override
    public ServerInfo constructServerInfo(String name, SocketAddress address, String motd, boolean restricted) {
        return new BungeeServerInfo(name, address, motd, restricted);
    }

    @Override
    public CommandSender getConsole() {
        return ConsoleCommandSender.getInstance();
    }

    @Override
    public void broadcast(String message) {
        this.broadcast(TextComponent.fromLegacy(message));
    }

    @Override
    public void broadcast(BaseComponent ... message) {
        this.getConsole().sendMessage(message);
        for (ProxiedPlayer player : this.getPlayers()) {
            player.sendMessage(message);
        }
    }

    @Override
    public void broadcast(BaseComponent message) {
        this.getConsole().sendMessage(message);
        for (ProxiedPlayer player : this.getPlayers()) {
            player.sendMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addConnection(UserConnection con) {
        UUID offlineId = con.getPendingConnection().getOfflineId();
        if (offlineId != null && offlineId.version() != 3) {
            throw new IllegalArgumentException("Offline UUID must be a name-based UUID");
        }
        this.connectionLock.writeLock().lock();
        try {
            if (this.connections.containsKey(con.getName()) || this.connectionsByUUID.containsKey(con.getUniqueId()) || this.connectionsByOfflineUUID.containsKey(offlineId)) {
                boolean bl = false;
                return bl;
            }
            this.connections.put(con.getName(), con);
            this.connectionsByUUID.put(con.getUniqueId(), con);
            this.connectionsByOfflineUUID.put(offlineId, con);
        }
        finally {
            this.connectionLock.writeLock().unlock();
        }
        return true;
    }

    public void removeConnection(UserConnection con) {
        this.connectionLock.writeLock().lock();
        try {
            if (this.connections.get(con.getName()) == con) {
                this.connections.remove(con.getName());
                this.connectionsByUUID.remove(con.getUniqueId());
                this.connectionsByOfflineUUID.remove(con.getPendingConnection().getOfflineId());
            }
        }
        finally {
            this.connectionLock.writeLock().unlock();
        }
    }

    @Override
    public Collection<String> getDisabledCommands() {
        return this.config.getDisabledCommands();
    }

    @Override
    public Collection<ProxiedPlayer> matchPlayer(String partialName) {
        Preconditions.checkNotNull(partialName, "partialName");
        ProxiedPlayer exactMatch = this.getPlayer(partialName);
        if (exactMatch != null) {
            return Collections.singleton(exactMatch);
        }
        return this.getPlayers().stream().filter(input -> input != null && input.getName().toLowerCase(Locale.ROOT).startsWith(partialName.toLowerCase(Locale.ROOT))).collect(Collectors.toSet());
    }

    @Override
    public Title createTitle() {
        return new BungeeTitle();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Configuration getConfig() {
        return this.config;
    }

    @Override
    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Override
    public ReconnectHandler getReconnectHandler() {
        return this.reconnectHandler;
    }

    @Override
    public ConfigurationAdapter getConfigurationAdapter() {
        return this.configurationAdapter;
    }

    @Override
    public void setConfigurationAdapter(ConfigurationAdapter configurationAdapter) {
        this.configurationAdapter = configurationAdapter;
    }

    @Override
    public File getPluginsFolder() {
        return this.pluginsFolder;
    }

    @Override
    public BungeeScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public NullCordXLogger getNullcordxLogger() {
        return this.nullcordxLogger;
    }

    public ConnectionThrottle getConnectionThrottle() {
        return this.connectionThrottle;
    }

    @Override
    public String getNameWithVersion() {
        return this.nameWithVersion;
    }

    @Override
    public NullCordXImpl getNullCordX() {
        return this.nullCordX;
    }
}

