/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.netty;

import com.google.common.base.Preconditions;
import es.xism4.software.ExploitChannelHandler;
import io.github.waterfallmc.waterfall.event.ConnectionInitEvent;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerDomainSocketChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.incubator.channel.uring.IOUring;
import io.netty.incubator.channel.uring.IOUringDatagramChannel;
import io.netty.incubator.channel.uring.IOUringEventLoopGroup;
import io.netty.incubator.channel.uring.IOUringServerSocketChannel;
import io.netty.incubator.channel.uring.IOUringSocketChannel;
import io.netty.util.AttributeKey;
import io.netty.util.internal.PlatformDependent;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.event.ClientConnectEvent;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.protocol.KickStringWriter;
import net.md_5.bungee.protocol.MinecraftDecoder;
import net.md_5.bungee.protocol.MinecraftEncoder;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.Varint21FrameDecoder;
import net.md_5.bungee.protocol.Varint21LengthFieldExtraBufPrepender;
import net.md_5.bungee.protocol.Varint21LengthFieldPrepender;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.config.ConfigSettings;
import net.shieldcommunity.nullcordx.netty.ChannelStatisticsAndPacketLimiterUpstreamHandler;
import net.shieldcommunity.nullcordx.netty.ChannelStatisticsDownstreamHandler;
import net.shieldcommunity.nullcordx.netty.PacketLimit;
import net.shieldcommunity.nullcordx.protocol.ReadyByteBufEncoder;
import net.shieldcommunity.nullcordx.statistics.StatisticsManagerImpl;

public class PipelineUtils {
    public static final AttributeKey<ListenerInfo> LISTENER = AttributeKey.newInstance("ListerInfo");
    public static final ChannelInitializer<Channel> SERVER_CHILD = new ChannelInitializer<Channel>(){

        @Override
        protected void initChannel(Channel ch) throws Exception {
            SocketAddress remoteAddress = ch.remoteAddress() == null ? ch.parent().localAddress() : ch.remoteAddress();
            NullCordXImpl nullCordX = BungeeCord.getInstance().getNullCordX();
            StatisticsManagerImpl statisticsManager = nullCordX.getStatisticsManager();
            statisticsManager.getSpamStatistics().addCounterAndCheckAttack();
            statisticsManager.addConnectionPerSecond();
            InetAddress address = ((InetSocketAddress)remoteAddress).getAddress();
            if (nullCordX.getBlacklistManager().isBlacklisted(address)) {
                statisticsManager.addBlockedConnectionPerSecond();
                ExploitChannelHandler.shutdownChannel(ch, null, true);
                return;
            }
            if (nullCordX.getBlacklistManager().getProxyBlacklistManager().isBlacklisted(address)) {
                statisticsManager.addBlockedConnectionPerSecond();
                nullCordX.getBlacklistManager().blackList(address, "proxy blacklisted address");
                ExploitChannelHandler.shutdownChannel(ch, null, true);
                return;
            }
            if (BungeeCord.getInstance().getConnectionThrottle() != null && BungeeCord.getInstance().getConnectionThrottle().throttle(remoteAddress)) {
                statisticsManager.addBlockedConnectionPerSecond();
                ExploitChannelHandler.shutdownChannel(ch, null, true);
                return;
            }
            ListenerInfo listener = ch.attr(LISTENER).get();
            if (!ConfigSettings.IMP.PERFORMANCE.DISABLE_CLIENT_CONNECTION_EVENT && BungeeCord.getInstance().getPluginManager().callEvent(new ClientConnectEvent(remoteAddress, listener)).isCancelled()) {
                ExploitChannelHandler.shutdownChannel(ch, null, true);
                return;
            }
            if (ConfigSettings.IMP.PERFORMANCE.DISABLE_CONNECTION_INIT_EVENT) {
                PipelineUtils.handleInitChannel(listener, ch);
                return;
            }
            ConnectionInitEvent connectionInitEvent = new ConnectionInitEvent(ch.remoteAddress(), listener, (result, throwable) -> {
                if (result.isCancelled()) {
                    ch.close();
                    return;
                }
                PipelineUtils.handleInitChannel(listener, ch);
            });
            BungeeCord.getInstance().getPluginManager().callEvent(connectionInitEvent);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            BungeeCord.getInstance().getLogger().log(Level.SEVERE, "An error encountered whilst initializing channel for a connection", cause);
            ExploitChannelHandler.shutdownChannel(ctx.channel(), null);
        }
    };
    public static final Base BASE = new Base(false);
    public static final Base BASE_SERVERSIDE = new Base(true);
    private static final KickStringWriter legacyKicker = new KickStringWriter();
    public static final Varint21LengthFieldPrepender framePrepender = new Varint21LengthFieldPrepender();
    private static final Varint21LengthFieldExtraBufPrepender serverFramePrepender = new Varint21LengthFieldExtraBufPrepender();
    private static final ReadyByteBufEncoder readyByteBufEncoder = new ReadyByteBufEncoder();
    public static final ChannelStatisticsDownstreamHandler channelStatisticsDownstreamHandler = new ChannelStatisticsDownstreamHandler();
    public static final String TIMEOUT_HANDLER = "timeout";
    public static final String PACKET_DECODER = "packet-decoder";
    public static final String PACKET_ENCODER = "packet-encoder";
    public static final String BOSS_HANDLER = "inbound-boss";
    public static final String ENCRYPT_HANDLER = "encrypt";
    public static final String DECRYPT_HANDLER = "decrypt";
    public static final String FRAME_DECODER = "frame-decoder";
    public static final String FRAME_PREPENDER = "frame-prepender";
    public static final String LEGACY_DECODER = "legacy-decoder";
    public static final String LEGACY_KICKER = "legacy-kick";
    public static final String FLUSH_CONSOLIDATION = "flush-consolidation";
    public static final String FLUSH_SIGNALING = "flush-signaling";
    public static final String READY_BYTEBUF_ENCODER = "ready-bytebuf-encoder";
    public static final String CHANNEL_STATISTICS_AND_PACKET_LIMITER_UPSTREAM_HANDLER = "channel-statistics-and-packet-limiter-upstream-handler";
    public static final String CHANNEL_STATISTICS_DOWNSTREAM_HANDLER = "channel-statistics-downstream-handler";
    private static boolean epoll;
    private static boolean io_uring;
    private static final ChannelFactory<? extends ServerChannel> serverChannelFactory;
    private static final ChannelFactory<? extends ServerChannel> serverChannelDomainFactory;
    private static final ChannelFactory<? extends Channel> channelFactory;
    private static final ChannelFactory<? extends Channel> channelDomainFactory;
    private static final ChannelFactory<? extends DatagramChannel> datagramChannelFactory;
    private static final int LOW_MARK;
    private static final int HIGH_MARK;
    private static final WriteBufferWaterMark MARK;

    public static EventLoopGroup newEventLoopGroup(int threads, ThreadFactory factory) {
        return io_uring ? new IOUringEventLoopGroup(threads, factory) : (epoll ? new EpollEventLoopGroup(threads, factory) : new NioEventLoopGroup(threads, factory));
    }

    public static ChannelFactory<? extends ServerChannel> getServerChannelFactory(SocketAddress address) {
        if (address instanceof DomainSocketAddress) {
            ChannelFactory<? extends ServerChannel> factory = serverChannelDomainFactory;
            Preconditions.checkState(factory != null, "Epoll required to have UNIX sockets");
            return factory;
        }
        return serverChannelFactory;
    }

    public static ChannelFactory<? extends Channel> getChannelFactory(SocketAddress address) {
        if (address instanceof DomainSocketAddress) {
            ChannelFactory<? extends Channel> factory = channelDomainFactory;
            Preconditions.checkState(factory != null, "Epoll required to have UNIX sockets");
            return factory;
        }
        return channelFactory;
    }

    public static ChannelFactory<? extends DatagramChannel> getDatagramChannelFactory() {
        return datagramChannelFactory;
    }

    @Deprecated
    public static Class<? extends ServerChannel> getServerChannel(SocketAddress address) {
        if (address instanceof DomainSocketAddress) {
            Preconditions.checkState(epoll, "Epoll required to have UNIX sockets");
            return EpollServerDomainSocketChannel.class;
        }
        return io_uring ? IOUringServerSocketChannel.class : (epoll ? EpollServerSocketChannel.class : NioServerSocketChannel.class);
    }

    @Deprecated
    public static Class<? extends Channel> getChannel(SocketAddress address) {
        if (address instanceof DomainSocketAddress) {
            Preconditions.checkState(epoll, "Epoll required to have UNIX sockets");
            return EpollDomainSocketChannel.class;
        }
        return io_uring ? IOUringSocketChannel.class : (epoll ? EpollSocketChannel.class : NioSocketChannel.class);
    }

    @Deprecated
    public static Class<? extends DatagramChannel> getDatagramChannel() {
        return io_uring ? IOUringDatagramChannel.class : (epoll ? EpollDatagramChannel.class : NioDatagramChannel.class);
    }

    private static void handleInitChannel(ListenerInfo listener, Channel ch) {
        try {
            BASE.initChannel(ch);
        }
        catch (Exception e) {
            BungeeCord.getInstance().getLogger().log(Level.SEVERE, "Failed to init channel", e);
            ch.close();
            return;
        }
        if (ConfigSettings.IMP.PERFORMANCE.TCP_FAST_OPEN.LISTENER.ENABLED) {
            ch.config().setOption(ChannelOption.TCP_FASTOPEN, ConfigSettings.IMP.PERFORMANCE.TCP_FAST_OPEN.LISTENER.MAX_CONNECTIONS);
        }
        ch.pipeline().addAfter(FRAME_DECODER, PACKET_DECODER, new MinecraftDecoder(Protocol.HANDSHAKE, true, ProxyServer.getInstance().getProtocolVersion()));
        ch.pipeline().addBefore(FRAME_PREPENDER, READY_BYTEBUF_ENCODER, readyByteBufEncoder);
        ch.pipeline().addAfter(FRAME_PREPENDER, PACKET_ENCODER, new MinecraftEncoder(Protocol.HANDSHAKE, true, ProxyServer.getInstance().getProtocolVersion()));
        ch.pipeline().get(HandlerBoss.class).setHandler(new InitialHandler(BungeeCord.getInstance(), listener));
        if (listener.isProxyProtocol()) {
            ch.pipeline().addFirst(new HAProxyMessageDecoder());
        }
        ChannelStatisticsAndPacketLimiterUpstreamHandler csapluh = new ChannelStatisticsAndPacketLimiterUpstreamHandler();
        csapluh.setPacketLimit(new PacketLimit(AntibotSettings.IMP.ANTIBOT.MAX_BYTES, AntibotSettings.IMP.ANTIBOT.MAX_PACKET_BYTES_PER_SECOND, AntibotSettings.IMP.ANTIBOT.MAX_PACKETS_PER_SECOND));
        ch.pipeline().addAfter(FRAME_DECODER, CHANNEL_STATISTICS_AND_PACKET_LIMITER_UPSTREAM_HANDLER, csapluh);
    }

    static {
        if (!PlatformDependent.isWindows()) {
            if (Boolean.parseBoolean(System.getProperty("bungee.io_uring", "false"))) {
                ProxyServer.getInstance().getLogger().info("Not on Windows, attempting to use enhanced IOUringEventLoopGroup");
                io_uring = IOUring.isAvailable();
                if (io_uring) {
                    ProxyServer.getInstance().getLogger().log(Level.WARNING, "io_uring is enabled and working, utilising it! (experimental feature)");
                } else {
                    ProxyServer.getInstance().getLogger().log(Level.WARNING, "io_uring is not working: {0}", Util.exception(IOUring.unavailabilityCause()));
                }
            }
            if (!io_uring && Boolean.parseBoolean(System.getProperty("bungee.epoll", "true"))) {
                ProxyServer.getInstance().getLogger().info("Not on Windows, attempting to use enhanced EpollEventLoop");
                epoll = Epoll.isAvailable();
                if (epoll) {
                    ProxyServer.getInstance().getLogger().info("Epoll is working, utilising it!");
                } else {
                    ProxyServer.getInstance().getLogger().log(Level.WARNING, "Epoll is not working, falling back to NIO: {0}", Util.exception(Epoll.unavailabilityCause()));
                }
            }
        }
        serverChannelFactory = io_uring ? IOUringServerSocketChannel::new : (epoll ? EpollServerSocketChannel::new : NioServerSocketChannel::new);
        ChannelFactory<ServerChannel> channelFactory = serverChannelDomainFactory = epoll ? EpollServerDomainSocketChannel::new : null;
        PipelineUtils.channelFactory = io_uring ? IOUringSocketChannel::new : (epoll ? EpollSocketChannel::new : NioSocketChannel::new);
        ChannelFactory<Channel> channelFactory2 = channelDomainFactory = epoll ? EpollDomainSocketChannel::new : null;
        datagramChannelFactory = io_uring ? IOUringDatagramChannel::new : (epoll ? EpollDatagramChannel::new : NioDatagramChannel::new);
        LOW_MARK = Integer.getInteger("net.md_5.bungee.low_mark", 524288);
        HIGH_MARK = Integer.getInteger("net.md_5.bungee.high_mark", 0x200000);
        MARK = new WriteBufferWaterMark(LOW_MARK, HIGH_MARK);
    }

    public static final class Base
    extends ChannelInitializer<Channel> {
        private boolean toServer = false;

        @Override
        public void initChannel(Channel ch) throws Exception {
            ch.config().setOption(ChannelOption.IP_TOS, 24);
            ch.config().setOption(ChannelOption.TCP_NODELAY, true);
            ch.config().setOption(ChannelOption.SO_KEEPALIVE, true);
            ch.config().setAllocator(PooledByteBufAllocator.DEFAULT);
            ch.config().setWriteBufferWaterMark(MARK);
            ch.pipeline().addLast(PipelineUtils.FRAME_DECODER, (ChannelHandler)new Varint21FrameDecoder());
            ch.pipeline().addLast(PipelineUtils.TIMEOUT_HANDLER, (ChannelHandler)new ReadTimeoutHandler(BungeeCord.getInstance().getNullCordX().computeTimeoutForInitConnection(), TimeUnit.MILLISECONDS));
            ch.pipeline().addLast(PipelineUtils.FRAME_PREPENDER, (ChannelHandler)framePrepender);
            ch.pipeline().addLast(PipelineUtils.BOSS_HANDLER, (ChannelHandler)new HandlerBoss());
        }

        public Base() {
        }

        public Base(boolean toServer) {
            this.toServer = toServer;
        }
    }
}

