/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import es.xism4.software.ExploitExceptionHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.lang.constant.Constable;
import java.util.List;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.FastDecoderException;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.shieldcommunity.nullcordx.config.ConfigSettings;
import net.shieldcommunity.nullcordx.protocol.packets.exceptions.FastBadPacketException;
import net.shieldcommunity.nullcordx.protocol.packets.exceptions.FastCorruptedFrameException;

public class MinecraftDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private Protocol protocol;
    private final boolean server;
    private int protocolVersion;
    private boolean supportsForge = false;
    private boolean slice = true;
    private static final FastDecoderException DECODE_FAILED = new FastDecoderException("A packet did not decode successfully (invalid packet), enable print-full-stacktraces for more usefully information");

    public MinecraftDecoder(Protocol protocol, boolean server, int protocolVersion) {
        this.protocol = protocol;
        this.server = server;
        this.protocolVersion = protocolVersion;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        Protocol.DirectionData prot;
        if (!ctx.channel().isActive() || !in.isReadable()) {
            return;
        }
        Protocol.DirectionData directionData = prot = this.server ? this.protocol.TO_SERVER : this.protocol.TO_CLIENT;
        if (prot == this.protocol.TO_SERVER) {
            int readableBytes = in.readableBytes();
            int capacity = in.capacity();
            if (readableBytes > ConfigSettings.IMP.PROTECTION.ANTIEXPLOIT.MAX_READABLE_BYTES) {
                ExploitExceptionHandler.throwBigUnframedPacketException(in);
            } else if (capacity > ConfigSettings.IMP.PROTECTION.ANTIEXPLOIT.MAX_READABLE_BYTES) {
                ExploitExceptionHandler.throwBigUnframedPacketException(in);
            }
        }
        ByteBuf slice = this.slice ? in.retainedSlice() : in.copy();
        Constable packetTypeInfo = null;
        try {
            if (in.readableBytes() == 0 && !this.server) {
                return;
            }
            int packetId = DefinedPacket.readVarInt(in);
            packetTypeInfo = packetId;
            DefinedPacket packet = prot.createPacket(packetId, this.protocolVersion, this.supportsForge);
            if (packet != null) {
                packetTypeInfo = packet.getClass();
                this.doLengthSanityChecks(in, packet, prot.getDirection(), packetId);
                packet.read(in, this.protocol, prot.getDirection(), this.protocolVersion);
                if (in.isReadable()) {
                    if (!ConfigSettings.IMP.LOGS.PRINT_FULL_STACKTRACES) {
                        throw DECODE_FAILED;
                    }
                    throw DefinedPacket.createFastBadPacketException("Packet " + this.protocol + ":" + prot.getDirection() + "/" + packetId + " (" + packet.getClass().getSimpleName() + ") larger than expected, extra bytes: " + in.readableBytes());
                }
            } else {
                in.skipBytes(in.readableBytes());
            }
            out.add(new PacketWrapper(packet, slice, this.protocol));
            slice = null;
        }
        catch (IndexOutOfBoundsException | FastBadPacketException e) {
            if (!ConfigSettings.IMP.LOGS.PRINT_FULL_STACKTRACES) {
                throw e;
            }
            Object packetTypeStr = packetTypeInfo instanceof Integer ? "id " + Integer.toHexString(packetTypeInfo) : (packetTypeInfo != null ? "class " + ((Class)packetTypeInfo).getSimpleName() : "unknown");
            throw new FastDecoderException("Error decoding packet " + (String)packetTypeStr + " with contents:\n" + ByteBufUtil.prettyHexDump(slice), e);
        }
        finally {
            if (slice != null) {
                slice.release();
            }
        }
    }

    private void doLengthSanityChecks(ByteBuf buf, DefinedPacket packet, ProtocolConstants.Direction direction, int packetId) throws Exception {
        int expectedMinLen = packet.expectedMinLength(buf, direction, this.protocolVersion);
        int expectedMaxLen = packet.expectedMaxLength(buf, direction, this.protocolVersion);
        int readable = buf.readableBytes();
        if (expectedMaxLen != -1 && readable > expectedMaxLen) {
            throw this.handleOverflow(packet, expectedMaxLen, readable, packetId);
        }
        if (readable < expectedMinLen) {
            throw this.handleUnderflow(packet, expectedMaxLen, readable, packetId);
        }
    }

    private Exception handleOverflow(DefinedPacket packet, int expected, int actual, int packetId) {
        if (ConfigSettings.IMP.LOGS.PRINT_FULL_STACKTRACES) {
            throw new FastCorruptedFrameException("Packet " + packet.getClass() + " " + packetId + " Protocol " + this.protocolVersion + " was too big (expected " + expected + " bytes, got " + actual + " bytes)");
        }
        return DECODE_FAILED;
    }

    private Exception handleUnderflow(DefinedPacket packet, int expected, int actual, int packetId) {
        if (ConfigSettings.IMP.LOGS.PRINT_FULL_STACKTRACES) {
            throw new FastCorruptedFrameException("Packet " + packet.getClass() + " " + packetId + " Protocol " + this.protocolVersion + " was too small (expected " + expected + " bytes, got " + actual + " bytes)");
        }
        return DECODE_FAILED;
    }

    public MinecraftDecoder(Protocol protocol, boolean server, int protocolVersion, boolean supportsForge, boolean slice) {
        this.protocol = protocol;
        this.server = server;
        this.protocolVersion = protocolVersion;
        this.supportsForge = supportsForge;
        this.slice = slice;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public boolean isServer() {
        return this.server;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public boolean isSupportsForge() {
        return this.supportsForge;
    }

    public boolean isSlice() {
        return this.slice;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setSupportsForge(boolean supportsForge) {
        this.supportsForge = supportsForge;
    }

    public void setSlice(boolean slice) {
        this.slice = slice;
    }
}

