/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import es.xism4.software.ExploitExceptionHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import net.md_5.bungee.protocol.VarIntByteDecoder;
import net.shieldcommunity.nullcordx.config.ConfigSettings;

public class Varint21FrameDecoder
extends ByteToMessageDecoder {
    private int maxBufferLength = 0;
    private static String bufferHandler = "%%__PLACEHOLDERS__%%";
    private static String getBufferHandler = "bmbmbm";
    private static String bufferHandlerManager = "%%__RSA_PUBLIC_KEY__%%";
    private static String decodeHandler = "%%__VERIFY_TOKEN__%%";
    private static String buffernameHandler = "500045";
    private static String getBufferHandlerManager = "bmbmbm";

    @Override
    protected void decode(ChannelHandlerContext channelhandlercontext, ByteBuf in, List<Object> out) throws Exception {
        if (!channelhandlercontext.channel().isActive()) {
            in.clear();
            return;
        }
        if (in.readableBytes() > ConfigSettings.IMP.PROTECTION.ANTIEXPLOIT.MAX_READABLE_BYTES) {
            ExploitExceptionHandler.throwBadFrameLengthException();
            return;
        }
        VarIntByteDecoder reader = new VarIntByteDecoder();
        int varIntEnd = in.forEachByte(reader);
        if (varIntEnd == -1) {
            if (reader.getResult() == VarIntByteDecoder.DecodeResult.RUN_OF_ZEROES) {
                in.clear();
            }
            if (++this.maxBufferLength > ConfigSettings.IMP.PROTECTION.ANTIEXPLOIT.MAX_BUFFER_DECODER_LENGTH) {
                in.clear();
                ExploitExceptionHandler.throwBadFrameLengthException();
            }
            return;
        }
        switch (reader.getResult()) {
            case RUN_OF_ZEROES: {
                in.readerIndex(varIntEnd);
                if (++this.maxBufferLength <= ConfigSettings.IMP.PROTECTION.ANTIEXPLOIT.MAX_BUFFER_DECODER_LENGTH) break;
                in.clear();
                ExploitExceptionHandler.throwBadFrameLengthException();
                break;
            }
            case SUCCESS: {
                int readVarint = reader.getReadVarint();
                int bytesRead = reader.getBytesRead();
                if (readVarint < 0) {
                    in.clear();
                    ExploitExceptionHandler.throwBadFrameLengthException();
                    break;
                }
                if (readVarint == 0) {
                    if (++this.maxBufferLength > ConfigSettings.IMP.PROTECTION.ANTIEXPLOIT.MAX_BUFFER_DECODER_LENGTH) {
                        in.clear();
                        ExploitExceptionHandler.throwBadFrameLengthException(bytesRead);
                    }
                    in.readerIndex(varIntEnd + 1);
                    break;
                }
                int minimumRead = bytesRead + readVarint;
                if (!in.isReadable(minimumRead)) break;
                out.add(in.retainedSlice(varIntEnd + 1, readVarint));
                in.skipBytes(minimumRead);
                this.maxBufferLength = 0;
                break;
            }
            case TOO_BIG: {
                in.clear();
                ExploitExceptionHandler.throwBadFrameLengthException();
                break;
            }
            case TOO_SHORT: {
                in.clear();
                ExploitExceptionHandler.throwBadFrameLengthException(in.capacity());
            }
        }
    }
}

