/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.ChatChain;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.SeenMessages;

public class ClientChat
extends DefinedPacket {
    private String message;
    private long timestamp;
    private long salt;
    private byte[] signature;
    private boolean signedPreview;
    private ChatChain chain;
    private SeenMessages seenMessages;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.message = ClientChat.readString(buf, 256);
        this.timestamp = buf.readLong();
        this.salt = buf.readLong();
        if (protocolVersion >= 761) {
            if (buf.readBoolean()) {
                this.signature = new byte[256];
                buf.readBytes(this.signature);
            }
        } else {
            this.signature = ClientChat.readArray(buf);
        }
        if (protocolVersion < 761) {
            this.signedPreview = buf.readBoolean();
        }
        if (protocolVersion >= 761) {
            this.seenMessages = new SeenMessages();
            this.seenMessages.read(buf, direction, protocolVersion);
        } else if (protocolVersion >= 760) {
            this.chain = new ChatChain();
            this.chain.read(buf, direction, protocolVersion);
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        ClientChat.writeString(this.message, buf);
        buf.writeLong(this.timestamp);
        buf.writeLong(this.salt);
        if (protocolVersion >= 761) {
            buf.writeBoolean(this.signature != null);
            if (this.signature != null) {
                buf.writeBytes(this.signature);
            }
        } else {
            ClientChat.writeArray(this.signature, buf);
        }
        if (protocolVersion < 761) {
            buf.writeBoolean(this.signedPreview);
        }
        if (protocolVersion >= 761) {
            this.seenMessages.write(buf, direction, protocolVersion);
        } else if (protocolVersion >= 760) {
            this.chain.write(buf, direction, protocolVersion);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public String getMessage() {
        return this.message;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getSalt() {
        return this.salt;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public boolean isSignedPreview() {
        return this.signedPreview;
    }

    public ChatChain getChain() {
        return this.chain;
    }

    public SeenMessages getSeenMessages() {
        return this.seenMessages;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setSalt(long salt) {
        this.salt = salt;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public void setSignedPreview(boolean signedPreview) {
        this.signedPreview = signedPreview;
    }

    public void setChain(ChatChain chain) {
        this.chain = chain;
    }

    public void setSeenMessages(SeenMessages seenMessages) {
        this.seenMessages = seenMessages;
    }

    @Override
    public String toString() {
        return "ClientChat(message=" + this.getMessage() + ", timestamp=" + this.getTimestamp() + ", salt=" + this.getSalt() + ", signature=" + Arrays.toString(this.getSignature()) + ", signedPreview=" + this.isSignedPreview() + ", chain=" + this.getChain() + ", seenMessages=" + this.getSeenMessages() + ")";
    }

    public ClientChat() {
    }

    public ClientChat(String message, long timestamp, long salt, byte[] signature, boolean signedPreview, ChatChain chain, SeenMessages seenMessages) {
        this.message = message;
        this.timestamp = timestamp;
        this.salt = salt;
        this.signature = signature;
        this.signedPreview = signedPreview;
        this.chain = chain;
        this.seenMessages = seenMessages;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientChat)) {
            return false;
        }
        ClientChat other = (ClientChat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.getSalt() != other.getSalt()) {
            return false;
        }
        if (this.isSignedPreview() != other.isSignedPreview()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        if (!Arrays.equals(this.getSignature(), other.getSignature())) {
            return false;
        }
        ChatChain this$chain = this.getChain();
        ChatChain other$chain = other.getChain();
        if (this$chain == null ? other$chain != null : !((Object)this$chain).equals(other$chain)) {
            return false;
        }
        SeenMessages this$seenMessages = this.getSeenMessages();
        SeenMessages other$seenMessages = other.getSeenMessages();
        return !(this$seenMessages == null ? other$seenMessages != null : !((Object)this$seenMessages).equals(other$seenMessages));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientChat;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        long $salt = this.getSalt();
        result = result * 59 + (int)($salt >>> 32 ^ $salt);
        result = result * 59 + (this.isSignedPreview() ? 79 : 97);
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        result = result * 59 + Arrays.hashCode(this.getSignature());
        ChatChain $chain = this.getChain();
        result = result * 59 + ($chain == null ? 43 : ((Object)$chain).hashCode());
        SeenMessages $seenMessages = this.getSeenMessages();
        result = result * 59 + ($seenMessages == null ? 43 : ((Object)$seenMessages).hashCode());
        return result;
    }
}

