/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.shieldcommunity.nullcordx.ManagerComponent;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.NullCordXLogger;
import net.shieldcommunity.nullcordx.libs.google.inject.Inject;
import net.shieldcommunity.nullcordx.libs.google.inject.Singleton;
import net.shieldcommunity.nullcordx.tasks.SafeScheduledTask;

@Singleton
public class LocalScheduler
extends ManagerComponent {
    private ScheduledExecutorService scheduler = null;

    @Inject
    public LocalScheduler(NullCordXLogger logger, NullCordXImpl nullCordX) {
        super(logger, nullCordX, "LocalScheduler");
    }

    @Override
    protected void onLoad(ForkJoinPool executor) {
        this.scheduler = Executors.newScheduledThreadPool(2, new ThreadFactoryBuilder().setNameFormat("NullCordX-LocalScheduler-%d").build());
    }

    @Override
    protected void onUnload() {
        try {
            this.scheduler.shutdown();
            this.scheduler.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.log(Level.SEVERE, "Error during shutdown scheduler", e);
        }
        this.scheduler = null;
    }

    public void scheduleWithFixedDelay(SafeScheduledTask task, long initialDelay, long period, TimeUnit unit) {
        if (this.scheduler == null) {
            return;
        }
        this.scheduler.scheduleWithFixedDelay(task, initialDelay, period, unit);
    }

    public void scheduleAtFixedRate(SafeScheduledTask task, long initialDelay, long period, TimeUnit unit) {
        if (this.scheduler == null) {
            return;
        }
        this.scheduler.scheduleAtFixedRate(task, initialDelay, period, unit);
    }
}

