/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx;

import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.NullCordXLogger;

public abstract class ManagerComponent {
    protected final NullCordXLogger logger;
    protected final NullCordXImpl nullCordX;
    protected final String componentName;
    private boolean loaded = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(ForkJoinPool executor) {
        if (this.loaded) {
            throw new IllegalStateException("Cannot load manager component '" + this.componentName + "': Component already loaded!");
        }
        long start = System.currentTimeMillis();
        try {
            this.logger.log(Level.INFO, "Loading " + this.componentName + "...");
            this.onLoad(executor);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error on load " + this.componentName, e);
        }
        finally {
            this.loaded = true;
            long end = System.currentTimeMillis();
            this.logger.log(Level.INFO, this.componentName + " loaded in " + (end - start) + "ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload() {
        if (!this.loaded) {
            throw new IllegalStateException("Cannot unload manager component '" + this.componentName + "': Component already unloaded!");
        }
        long start = System.currentTimeMillis();
        try {
            this.logger.log(Level.INFO, "Unloading " + this.componentName + "...");
            this.onUnload();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error on unload " + this.componentName, e);
        }
        finally {
            this.loaded = false;
            long end = System.currentTimeMillis();
            this.logger.log(Level.INFO, this.componentName + " unloaded in " + (end - start) + "ms");
        }
    }

    protected abstract void onLoad(ForkJoinPool var1);

    protected abstract void onUnload();

    public ManagerComponent(NullCordXLogger logger, NullCordXImpl nullCordX, String componentName) {
        this.logger = logger;
        this.nullCordX = nullCordX;
        this.componentName = componentName;
    }

    public boolean isLoaded() {
        return this.loaded;
    }
}

