/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import net.shieldcommunity.nullcordx.LanguageManagerImpl;
import net.shieldcommunity.nullcordx.ManagerComponent;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.NullCordXLogger;
import net.shieldcommunity.nullcordx.antibot.AntiBotChecksCreator;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.ASNCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.AnimatedFramedCaptchaCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.AnimatedFramedPuzzleCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.AnimatedHandCaptchaCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.AttributesCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.CountryCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.FallAndAnimatedHandCaptchaCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.FallAndHandCaptchaCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.FallAndProxyCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.FramedCaptchaCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.FramedPuzzleCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.HandCaptchaCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.PickCaptchaCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.ProxyCheck;
import net.shieldcommunity.nullcordx.api.checking.AbstractChecking;
import net.shieldcommunity.nullcordx.api.checking.CheckingFactories;
import net.shieldcommunity.nullcordx.api.checking.CheckingFactory;
import net.shieldcommunity.nullcordx.api.checking.CheckingListFactory;
import net.shieldcommunity.nullcordx.api.checking.ConditionData;
import net.shieldcommunity.nullcordx.api.checking.ConditionEvent;
import net.shieldcommunity.nullcordx.api.checking.ConditionType;
import net.shieldcommunity.nullcordx.api.utils.FastRandom;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.config.captcha.AnimatedFramedCaptchaSettings;
import net.shieldcommunity.nullcordx.config.captcha.AnimatedFramedPuzzleSettings;
import net.shieldcommunity.nullcordx.config.captcha.AnimatedHandCaptchaSettings;
import net.shieldcommunity.nullcordx.config.captcha.FramedCaptchaSettings;
import net.shieldcommunity.nullcordx.config.captcha.FramedPuzzleSettings;
import net.shieldcommunity.nullcordx.config.captcha.PickCaptchaSettings;
import net.shieldcommunity.nullcordx.libs.google.inject.Inject;
import net.shieldcommunity.nullcordx.libs.google.inject.Singleton;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.util.XoRoShiRo128PlusRandom;

@Singleton
public class CheckingFactoriesImpl
extends ManagerComponent
implements CheckingFactories {
    private final NullCordXLogger logger;
    private final NullCordXImpl nullCordX;
    private final LanguageManagerImpl languageManager;
    private final AntiBotChecksCreator antiBotChecksCreator;
    private Map<String, CheckingFactory> checkingFactoryTemplates = new HashMap<String, CheckingFactory>();
    private CheckingListFactory normalCheckingFactoryForJava = AntiBotChecksCreator.createDummyCheckingListFactory();
    private CheckingListFactory attackCheckingFactoryForJava = AntiBotChecksCreator.createDummyCheckingListFactory();
    private CheckingListFactory customCheckingFactoryForJava = AntiBotChecksCreator.createDummyCheckingListFactory();
    private Map<String, CheckingListFactory> customCheckingFactoriesForJava = new HashMap<String, CheckingListFactory>();
    private CheckingListFactory normalCheckingFactoryForBedrock = AntiBotChecksCreator.createDummyCheckingListFactory();
    private CheckingListFactory attackCheckingFactoryForBedrock = AntiBotChecksCreator.createDummyCheckingListFactory();
    private CheckingListFactory customCheckingFactoryForBedrock = AntiBotChecksCreator.createDummyCheckingListFactory();
    private Map<String, CheckingListFactory> customCheckingFactoriesForBedrock = new HashMap<String, CheckingListFactory>();
    private int clientId;
    private int keepAliveId;
    private int waitingTeleportId;
    private int pingTransactionId;

    @Inject
    public CheckingFactoriesImpl(NullCordXLogger logger, NullCordXImpl nullCordX, LanguageManagerImpl languageManager, AntiBotChecksCreator antiBotChecksCreator) {
        super(logger, nullCordX, "CheckingFactories");
        this.logger = logger;
        this.nullCordX = nullCordX;
        this.languageManager = languageManager;
        this.antiBotChecksCreator = antiBotChecksCreator;
    }

    @Override
    public void onLoad(ForkJoinPool executor) {
        XoRoShiRo128PlusRandom random = FastRandom.getFastRandom();
        this.clientId = ((Random)random).nextInt(2147483547) + 50;
        this.keepAliveId = ((Random)random).nextInt(9999);
        this.waitingTeleportId = ((Random)random).nextInt(9999);
        this.pingTransactionId = ((Random)random).nextInt(9999);
        this.antiBotChecksCreator.load();
        Map<String, CheckingFactory> checkingFactoryTemplates = this.antiBotChecksCreator.createCheckingFactoryTemplates(executor, this);
        for (Map.Entry<String, AntibotSettings.ANTIBOT.CONDITION_CHECK> entry : AntibotSettings.IMP.ANTIBOT.CONDITION_CHECKS_OVERRIDE.entrySet()) {
            String name = entry.getKey();
            CheckingFactory checkingFactory = checkingFactoryTemplates.get(name);
            if (checkingFactory == null) {
                this.logger.log(Level.SEVERE, "Failed to find mode template '" + name + "' for condition check.");
                continue;
            }
            AntibotSettings.ANTIBOT.CONDITION_CHECK conditionCheck = entry.getValue();
            String successName = conditionCheck.IF_SUCCESS;
            ConditionEvent onSuccessEvent = CheckingFactoriesImpl.parseConditionEvent(successName, checkingFactoryTemplates);
            if (onSuccessEvent == null) {
                this.logger.log(Level.SEVERE, "Failed to parse success condition for mode template '" + name + "'. Unknown '" + successName + "' type.");
                continue;
            }
            String failedName = conditionCheck.IF_FAILED;
            ConditionEvent onFailedEvent = CheckingFactoriesImpl.parseConditionEvent(failedName, checkingFactoryTemplates);
            if (onFailedEvent == null) {
                this.logger.log(Level.SEVERE, "Failed to parse failed condition for mode template '" + name + "'. Unknown '" + failedName + "' type.");
                continue;
            }
            checkingFactory.setConditionData(new ConditionData(onSuccessEvent, onFailedEvent, conditionCheck.CHECK_PING_ON_COMPLETE, conditionCheck.RESET_PING_ON_COMPLETE));
        }
        if (AntibotSettings.IMP.ANTIBOT.MODES.JAVA.ENABLED) {
            this.normalCheckingFactoryForJava = this.antiBotChecksCreator.createCheckingFactoryByModes(AntibotSettings.IMP.ANTIBOT.MODES.JAVA.NORMAL, checkingFactoryTemplates, "default normal");
            this.attackCheckingFactoryForJava = this.antiBotChecksCreator.createCheckingFactoryByModes(AntibotSettings.IMP.ANTIBOT.MODES.JAVA.ON_ATTACK, checkingFactoryTemplates, "default on attack");
            this.customCheckingFactoriesForJava = this.createCustomCheckingFactories(AntibotSettings.IMP.ANTIBOT.MODES.JAVA.CUSTOM, checkingFactoryTemplates);
        }
        if (AntibotSettings.IMP.ANTIBOT.MODES.BEDROCK.ENABLED) {
            this.normalCheckingFactoryForBedrock = this.antiBotChecksCreator.createCheckingFactoryByModes(AntibotSettings.IMP.ANTIBOT.MODES.BEDROCK.NORMAL, checkingFactoryTemplates, "bedrock normal");
            this.attackCheckingFactoryForBedrock = this.antiBotChecksCreator.createCheckingFactoryByModes(AntibotSettings.IMP.ANTIBOT.MODES.BEDROCK.ON_ATTACK, checkingFactoryTemplates, "bedrock on attack");
            this.customCheckingFactoriesForBedrock = this.createCustomCheckingFactories(AntibotSettings.IMP.ANTIBOT.MODES.BEDROCK.CUSTOM, checkingFactoryTemplates);
        }
        this.checkingFactoryTemplates = checkingFactoryTemplates;
    }

    @Override
    protected void onUnload() {
        for (CheckingFactory checkingFactory : this.checkingFactoryTemplates.values()) {
            checkingFactory.unload();
        }
    }

    private Map<String, CheckingListFactory> createCustomCheckingFactories(Map<String, List<String>> data, Map<String, CheckingFactory> checkingFactoryTemplates) {
        HashMap<String, CheckingListFactory> customCheckingFactories = new HashMap<String, CheckingListFactory>();
        for (Map.Entry<String, List<String>> entry : data.entrySet()) {
            String name = entry.getKey().toLowerCase(Locale.ROOT);
            CheckingListFactory checkingListFactory = this.antiBotChecksCreator.createCheckingFactoryByModes(entry.getValue(), checkingFactoryTemplates, name);
            customCheckingFactories.put(name, checkingListFactory);
        }
        return customCheckingFactories;
    }

    @Override
    public boolean isNeedGenerateCaptcha() {
        return this.isNeedGenerateHandCaptcha() || this.isNeedGenerateAnimatedHandCaptcha() || this.isNeedGenerateFramedCaptcha() || this.isNeedGenerateAnimatedFramedCaptcha() || this.isNeedGenerateFramedPuzzle() || this.isNeedGenerateAnimatedFramedPuzzle() || this.isNeedGeneratePickCaptcha();
    }

    @Override
    public boolean isNeedGenerateHandCaptcha() {
        return this.isSpecifiedCheckUsed(HandCaptchaCheck.class, FallAndHandCaptchaCheck.class);
    }

    @Override
    public boolean isNeedGenerateAnimatedHandCaptcha() {
        return this.isSpecifiedCheckUsed(AnimatedHandCaptchaCheck.class, FallAndAnimatedHandCaptchaCheck.class);
    }

    @Override
    public boolean isNeedGenerateFramedCaptcha() {
        return this.isSpecifiedCheckUsed(FramedCaptchaCheck.class);
    }

    @Override
    public boolean isNeedGenerateAnimatedFramedCaptcha() {
        return this.isSpecifiedCheckUsed(AnimatedFramedCaptchaCheck.class);
    }

    @Override
    public boolean isNeedGenerateFramedPuzzle() {
        return this.isSpecifiedCheckUsed(FramedPuzzleCheck.class);
    }

    @Override
    public boolean isNeedGenerateAnimatedFramedPuzzle() {
        return this.isSpecifiedCheckUsed(AnimatedFramedPuzzleCheck.class);
    }

    @Override
    public boolean isNeedGeneratePickCaptcha() {
        return this.isSpecifiedCheckUsed(PickCaptchaCheck.class);
    }

    @Override
    public boolean isCaptchaAnimationUsed() {
        return this.isSpecifiedCheckUsed(AnimatedHandCaptchaCheck.class, FallAndAnimatedHandCaptchaCheck.class, AnimatedFramedCaptchaCheck.class, AnimatedFramedPuzzleCheck.class);
    }

    @Override
    public boolean isFramedCaptchaUsed() {
        return this.isSpecifiedCheckUsed(FramedCaptchaCheck.class, AnimatedFramedCaptchaCheck.class, FramedPuzzleCheck.class, AnimatedFramedPuzzleCheck.class, PickCaptchaCheck.class);
    }

    @Override
    public boolean isCountryCheckUsed() {
        return this.isSpecifiedCheckUsed(CountryCheck.class);
    }

    @Override
    public boolean isASNCheckUsed() {
        return this.isSpecifiedCheckUsed(ASNCheck.class);
    }

    @Override
    public boolean isProxyCheckUsed() {
        return this.isSpecifiedCheckUsed(ProxyCheck.class, FallAndProxyCheck.class);
    }

    @Override
    public boolean isAttributesCheckUsed() {
        return this.isSpecifiedCheckUsed(AttributesCheck.class);
    }

    @Override
    @SafeVarargs
    public final boolean isSpecifiedCheckUsed(Class<? extends AbstractChecking> ... types) {
        for (CheckingFactory checkingFactory : this.checkingFactoryTemplates.values()) {
            if (!checkingFactory.isLazyLoaded()) continue;
            for (Class<? extends AbstractChecking> type : types) {
                if (checkingFactory.getType() != type) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getMinFrameRow() {
        return this.findMin(this.isNeedGenerateFramedCaptcha() ? Integer.valueOf(FramedCaptchaSettings.IMP.FRAMED_CAPTCHA.FRAME_SIZES.getMinRow()) : null, this.isNeedGenerateAnimatedFramedCaptcha() ? Integer.valueOf(AnimatedFramedCaptchaSettings.IMP.ANIMATED_FRAMED_CAPTCHA.FRAME_SIZES.getMinRow()) : null, this.isNeedGenerateFramedPuzzle() ? Integer.valueOf(FramedPuzzleSettings.IMP.FRAMED_PUZZLE.FRAME_SIZES.getMinRow()) : null, this.isNeedGenerateAnimatedFramedPuzzle() ? Integer.valueOf(AnimatedFramedPuzzleSettings.IMP.ANIMATED_FRAMED_PUZZLE.FRAME_SIZES.getMinRow()) : null, this.isNeedGeneratePickCaptcha() ? Integer.valueOf(PickCaptchaSettings.IMP.PICK_CAPTCHA.FRAME_SIZES.getMinRow()) : null);
    }

    @Override
    public int getMinFrameColumn() {
        return this.findMin(this.isNeedGenerateFramedCaptcha() ? Integer.valueOf(FramedCaptchaSettings.IMP.FRAMED_CAPTCHA.FRAME_SIZES.getMinColumn()) : null, this.isNeedGenerateAnimatedFramedCaptcha() ? Integer.valueOf(AnimatedFramedCaptchaSettings.IMP.ANIMATED_FRAMED_CAPTCHA.FRAME_SIZES.getMinColumn()) : null, this.isNeedGenerateFramedPuzzle() ? Integer.valueOf(FramedPuzzleSettings.IMP.FRAMED_PUZZLE.FRAME_SIZES.getMinColumn()) : null, this.isNeedGenerateAnimatedFramedPuzzle() ? Integer.valueOf(AnimatedFramedPuzzleSettings.IMP.ANIMATED_FRAMED_PUZZLE.FRAME_SIZES.getMinColumn()) : null, this.isNeedGeneratePickCaptcha() ? Integer.valueOf(PickCaptchaSettings.IMP.PICK_CAPTCHA.FRAME_SIZES.getMinColumn()) : null);
    }

    @Override
    public int getMaxFrameRow() {
        return this.findMax(this.isNeedGenerateFramedCaptcha() ? Integer.valueOf(FramedCaptchaSettings.IMP.FRAMED_CAPTCHA.FRAME_SIZES.getMaxRow()) : null, this.isNeedGenerateAnimatedFramedCaptcha() ? Integer.valueOf(AnimatedFramedCaptchaSettings.IMP.ANIMATED_FRAMED_CAPTCHA.FRAME_SIZES.getMaxRow()) : null, this.isNeedGenerateFramedPuzzle() ? Integer.valueOf(FramedPuzzleSettings.IMP.FRAMED_PUZZLE.FRAME_SIZES.getMaxRow()) : null, this.isNeedGenerateAnimatedFramedPuzzle() ? Integer.valueOf(AnimatedFramedPuzzleSettings.IMP.ANIMATED_FRAMED_PUZZLE.FRAME_SIZES.getMaxRow()) : null, this.isNeedGeneratePickCaptcha() ? Integer.valueOf(PickCaptchaSettings.IMP.PICK_CAPTCHA.FRAME_SIZES.getMaxRow()) : null);
    }

    @Override
    public int getMaxFrameColumn() {
        return this.findMax(this.isNeedGenerateFramedCaptcha() ? Integer.valueOf(FramedCaptchaSettings.IMP.FRAMED_CAPTCHA.FRAME_SIZES.getMaxColumn()) : null, this.isNeedGenerateAnimatedFramedCaptcha() ? Integer.valueOf(AnimatedFramedCaptchaSettings.IMP.ANIMATED_FRAMED_CAPTCHA.FRAME_SIZES.getMaxColumn()) : null, this.isNeedGenerateFramedPuzzle() ? Integer.valueOf(FramedPuzzleSettings.IMP.FRAMED_PUZZLE.FRAME_SIZES.getMaxColumn()) : null, this.isNeedGenerateAnimatedFramedPuzzle() ? Integer.valueOf(AnimatedFramedPuzzleSettings.IMP.ANIMATED_FRAMED_PUZZLE.FRAME_SIZES.getMaxColumn()) : null, this.isNeedGeneratePickCaptcha() ? Integer.valueOf(PickCaptchaSettings.IMP.PICK_CAPTCHA.FRAME_SIZES.getMaxColumn()) : null);
    }

    @Override
    public int getMaxAnimationFrames() {
        return this.findMax(this.isNeedGenerateAnimatedHandCaptcha() ? Integer.valueOf(AnimatedHandCaptchaSettings.IMP.ANIMATED_HAND_CAPTCHA.FRAMES_COUNT) : null, this.isNeedGenerateAnimatedFramedCaptcha() ? Integer.valueOf(AnimatedFramedCaptchaSettings.IMP.ANIMATED_FRAMED_CAPTCHA.FRAMES_COUNT) : null, this.isNeedGenerateAnimatedFramedPuzzle() ? Integer.valueOf(AnimatedFramedPuzzleSettings.IMP.ANIMATED_FRAMED_PUZZLE.FRAMES_COUNT) : null);
    }

    private int findMin(Integer ... values) {
        int min2 = Integer.MAX_VALUE;
        for (Integer v : values) {
            if (v == null || v >= min2) continue;
            min2 = v;
        }
        if (min2 == Integer.MAX_VALUE) {
            min2 = 1;
        }
        return min2;
    }

    private int findMax(Integer ... values) {
        int max = 1;
        for (Integer v : values) {
            if (v == null || v <= max) continue;
            max = v;
        }
        return max;
    }

    @Override
    public CheckingListFactory getCurrentCheckingFactory(boolean bedrock) {
        return bedrock ? this.getCurrentCheckingFactoryForBedrock() : this.getCurrentCheckingFactoryForJava();
    }

    @Override
    public CheckingListFactory getCurrentCheckingFactoryForJava() {
        if (this.nullCordX.isCustomProtection()) {
            return this.customCheckingFactoryForJava;
        }
        return this.nullCordX.isUnderBotAttack() ? this.attackCheckingFactoryForJava : this.normalCheckingFactoryForJava;
    }

    @Override
    public CheckingListFactory getCurrentCheckingFactoryForBedrock() {
        if (this.nullCordX.isCustomProtection()) {
            return this.customCheckingFactoryForBedrock;
        }
        return this.nullCordX.isUnderBotAttack() ? this.attackCheckingFactoryForBedrock : this.normalCheckingFactoryForBedrock;
    }

    @Override
    public CheckingListFactory getCustomCheckingFactoryListByName(String name, boolean bedrock) {
        Map<String, CheckingListFactory> factories = bedrock ? this.customCheckingFactoriesForBedrock : this.customCheckingFactoriesForJava;
        return factories.get(name);
    }

    @Override
    public void setCustomCheckingFactoryListByType(CheckingListFactory checkingListFactory, boolean bedrock) {
        if (bedrock) {
            this.customCheckingFactoryForBedrock = checkingListFactory;
        } else {
            this.customCheckingFactoryForJava = checkingListFactory;
        }
    }

    @Override
    public CheckingListFactory getCustomCheckingFactoryListByType(boolean bedrock) {
        return bedrock ? this.customCheckingFactoryForBedrock : this.customCheckingFactoryForJava;
    }

    private static ConditionEvent parseConditionEvent(String name, Map<String, CheckingFactory> checkingFactoryTemplates) {
        ConditionType onSuccessType = null;
        try {
            onSuccessType = ConditionType.valueOf(name.toUpperCase(Locale.ROOT));
        }
        catch (Exception exception) {
            // empty catch block
        }
        CheckingFactory onSuccessFactory = null;
        if (onSuccessType == null) {
            onSuccessFactory = checkingFactoryTemplates.get(name);
        }
        if (onSuccessType == null && onSuccessFactory == null) {
            return null;
        }
        return new ConditionEvent(onSuccessType, onSuccessFactory);
    }

    public NullCordXLogger getLogger() {
        return this.logger;
    }

    public NullCordXImpl getNullCordX() {
        return this.nullCordX;
    }

    public LanguageManagerImpl getLanguageManager() {
        return this.languageManager;
    }

    public AntiBotChecksCreator getAntiBotChecksCreator() {
        return this.antiBotChecksCreator;
    }

    public Map<String, CheckingFactory> getCheckingFactoryTemplates() {
        return this.checkingFactoryTemplates;
    }

    @Override
    public CheckingListFactory getNormalCheckingFactoryForJava() {
        return this.normalCheckingFactoryForJava;
    }

    @Override
    public CheckingListFactory getAttackCheckingFactoryForJava() {
        return this.attackCheckingFactoryForJava;
    }

    @Override
    public CheckingListFactory getCustomCheckingFactoryForJava() {
        return this.customCheckingFactoryForJava;
    }

    public Map<String, CheckingListFactory> getCustomCheckingFactoriesForJava() {
        return this.customCheckingFactoriesForJava;
    }

    @Override
    public CheckingListFactory getNormalCheckingFactoryForBedrock() {
        return this.normalCheckingFactoryForBedrock;
    }

    @Override
    public CheckingListFactory getAttackCheckingFactoryForBedrock() {
        return this.attackCheckingFactoryForBedrock;
    }

    @Override
    public CheckingListFactory getCustomCheckingFactoryForBedrock() {
        return this.customCheckingFactoryForBedrock;
    }

    public Map<String, CheckingListFactory> getCustomCheckingFactoriesForBedrock() {
        return this.customCheckingFactoriesForBedrock;
    }

    @Override
    public int getClientId() {
        return this.clientId;
    }

    @Override
    public int getKeepAliveId() {
        return this.keepAliveId;
    }

    @Override
    public int getWaitingTeleportId() {
        return this.waitingTeleportId;
    }

    @Override
    public int getPingTransactionId() {
        return this.pingTransactionId;
    }

    public void setCheckingFactoryTemplates(Map<String, CheckingFactory> checkingFactoryTemplates) {
        this.checkingFactoryTemplates = checkingFactoryTemplates;
    }

    @Override
    public void setNormalCheckingFactoryForJava(CheckingListFactory normalCheckingFactoryForJava) {
        this.normalCheckingFactoryForJava = normalCheckingFactoryForJava;
    }

    @Override
    public void setAttackCheckingFactoryForJava(CheckingListFactory attackCheckingFactoryForJava) {
        this.attackCheckingFactoryForJava = attackCheckingFactoryForJava;
    }

    @Override
    public void setCustomCheckingFactoryForJava(CheckingListFactory customCheckingFactoryForJava) {
        this.customCheckingFactoryForJava = customCheckingFactoryForJava;
    }

    public void setCustomCheckingFactoriesForJava(Map<String, CheckingListFactory> customCheckingFactoriesForJava) {
        this.customCheckingFactoriesForJava = customCheckingFactoriesForJava;
    }

    @Override
    public void setNormalCheckingFactoryForBedrock(CheckingListFactory normalCheckingFactoryForBedrock) {
        this.normalCheckingFactoryForBedrock = normalCheckingFactoryForBedrock;
    }

    @Override
    public void setAttackCheckingFactoryForBedrock(CheckingListFactory attackCheckingFactoryForBedrock) {
        this.attackCheckingFactoryForBedrock = attackCheckingFactoryForBedrock;
    }

    @Override
    public void setCustomCheckingFactoryForBedrock(CheckingListFactory customCheckingFactoryForBedrock) {
        this.customCheckingFactoryForBedrock = customCheckingFactoryForBedrock;
    }

    public void setCustomCheckingFactoriesForBedrock(Map<String, CheckingListFactory> customCheckingFactoriesForBedrock) {
        this.customCheckingFactoriesForBedrock = customCheckingFactoriesForBedrock;
    }

    public void setClientId(int clientId) {
        this.clientId = clientId;
    }

    public void setKeepAliveId(int keepAliveId) {
        this.keepAliveId = keepAliveId;
    }

    public void setWaitingTeleportId(int waitingTeleportId) {
        this.waitingTeleportId = waitingTeleportId;
    }

    public void setPingTransactionId(int pingTransactionId) {
        this.pingTransactionId = pingTransactionId;
    }
}

