/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import net.shieldcommunity.nullcordx.antibot.maxmind.connections.MaxMindConnection;
import net.shieldcommunity.nullcordx.libs.ice.tar.TarEntry;
import net.shieldcommunity.nullcordx.libs.ice.tar.TarInputStream;
import net.shieldcommunity.nullcordx.libs.maxmind.db.CHMCache;
import net.shieldcommunity.nullcordx.libs.maxmind.db.Reader;
import net.shieldcommunity.nullcordx.libs.maxmind.geoip2.DatabaseReader;
import net.shieldcommunity.nullcordx.utils.HttpUtils;

public class MaxMindDatabase {
    private final String name;
    private final int maxDatabaseTime;
    private final MaxMindConnection maxMindConnection;
    private final File path;
    private final Logger logger;
    private DatabaseReader reader = null;

    public Long getASN(InetAddress inetAddress) {
        if (this.reader == null) {
            return null;
        }
        try {
            return this.reader.asn(inetAddress).getAutonomousSystemNumber();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getCountryISO(InetAddress inetAddress) {
        if (this.reader == null) {
            return null;
        }
        try {
            return this.reader.country(inetAddress).getCountry().getIsoCode();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void reloadDatabase() {
        long start = System.currentTimeMillis();
        this.closeReader();
        try {
            this.logger.log(Level.INFO, "Loading " + this.name + " GeoIp database...");
            if (this.isDatabaseOutOfDate()) {
                this.logger.log(Level.INFO, this.name + " GeoIp database is out of date or is not exists! Downloading a new one...");
                this.downloadDataBase(this.path);
                this.logger.log(Level.INFO, this.name + " GeoIp database successfully downloaded.");
            }
            this.assignReader();
            long end = System.currentTimeMillis();
            this.logger.log(Level.INFO, this.name + " GeoIp database successfully loaded in " + (end - start) + " ms.");
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to load " + this.name + " GeoIp database", e);
            try {
                this.logger.log(Level.WARNING, "Using the cached " + this.name + " GeoIp database...");
                if (!this.path.exists()) {
                    this.logger.log(Level.SEVERE, "Unable to load " + this.name + " GeoIp database. Cache is not found!");
                    return;
                }
                this.assignReader();
            }
            catch (Exception e2) {
                this.logger.log(Level.SEVERE, "Unable to load " + this.name + " GeoIp database", e2);
            }
        }
    }

    public void checkDatabase() {
        if (this.reader != null && this.isDatabaseOutOfDate()) {
            this.logger.log(Level.INFO, this.name + " GeoIp database is out of date or is not exists!");
            try {
                long start = System.currentTimeMillis();
                this.logger.log(Level.INFO, "Starting to download a new one " + this.name + " GeoIp database...");
                this.downloadDataBase(this.path);
                this.logger.log(Level.INFO, this.name + " GeoIp database successfully downloaded.");
                this.closeReader();
                this.assignReader();
                long end = System.currentTimeMillis();
                this.logger.log(Level.INFO, this.name + " GeoIp database successfully loaded in " + (end - start) + " ms.");
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to load " + this.name + " GeoIp database", e);
            }
        }
    }

    private void assignReader() throws IOException {
        this.reader = new DatabaseReader.Builder(this.path).withCache(new CHMCache(16384)).fileMode(Reader.FileMode.MEMORY).build();
    }

    public void closeReader() {
        if (this.reader != null) {
            try {
                this.logger.log(Level.INFO, "Closing " + this.name + " GeoIp database...");
                this.reader.close();
                this.logger.log(Level.INFO, this.name + " GeoIp database successfully closed.");
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Failed to close " + this.name + " GeoIp database", e);
            }
        }
        this.reader = null;
    }

    private boolean isDatabaseOutOfDate() {
        if (!this.path.exists()) {
            return true;
        }
        return System.currentTimeMillis() - this.path.lastModified() > TimeUnit.DAYS.toMillis(this.maxDatabaseTime);
    }

    private void downloadDataBase(File out) throws Exception {
        try (HttpUtils.HttpByteArrayInputStream inputStream = this.maxMindConnection.openConnection();){
            int code = inputStream.getCode();
            if (code != 200) {
                throw new IOException("Expected response code 200 (HTTP_OK) but received: " + code + ": '" + inputStream.getTextResponse() + "'");
            }
            try (TarInputStream tarIn = new TarInputStream(new GZIPInputStream(new BufferedInputStream(inputStream)));){
                TarEntry entry;
                while ((entry = tarIn.getNextEntry()) != null) {
                    if (!entry.getName().endsWith("mmdb")) continue;
                    this.saveToFile(tarIn, out);
                }
            }
        }
    }

    private void saveToFile(InputStream inputStream, File file) throws IOException {
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file, false));){
            int count;
            byte[] buffer = new byte[2048];
            while ((count = inputStream.read(buffer, 0, 2048)) != -1) {
                if (Thread.interrupted()) {
                    ((OutputStream)outputStream).close();
                    file.delete();
                    return;
                }
                ((OutputStream)outputStream).write(buffer, 0, count);
            }
        }
    }

    public MaxMindDatabase(String name, int maxDatabaseTime, MaxMindConnection maxMindConnection, File path, Logger logger) {
        this.name = name;
        this.maxDatabaseTime = maxDatabaseTime;
        this.maxMindConnection = maxMindConnection;
        this.path = path;
        this.logger = logger;
    }
}

