/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.antiproxy;

import java.net.InetAddress;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.api.antibot.antiproxy.CachedProxyChecker;
import net.shieldcommunity.nullcordx.api.antibot.antiproxy.ProxyResult;
import net.shieldcommunity.nullcordx.api.antibot.antiproxy.services.AbstractAntiProxyService;
import net.shieldcommunity.nullcordx.api.antibot.antiproxy.services.ProxyServiceCheckFailedException;
import net.shieldcommunity.nullcordx.config.AntibotSettings;

public class CachedProxyCheckerImpl
implements CachedProxyChecker {
    private final NullCordXImpl nullCordX;
    private final InetAddress inetAddress;
    private final ReentrantLock lock = new ReentrantLock();
    private ProxyResult cachedResult = ProxyResult.NONE;

    @Override
    public void checkAll(List<AbstractAntiProxyService> abstractAntiProxyServices) {
        this.cachedResult = this.detectProxy(abstractAntiProxyServices);
    }

    private ProxyResult detectProxy(List<AbstractAntiProxyService> abstractAntiProxyServices) {
        Iterator<AbstractAntiProxyService> iterator = abstractAntiProxyServices.iterator();
        if (iterator.hasNext()) {
            AbstractAntiProxyService abstractAntiProxyService = iterator.next();
            try {
                if (this.nullCordX.canSendDebugLog()) {
                    this.nullCordX.sendDebugLog("Trying to check ip " + this.inetAddress.getHostAddress() + " in service " + abstractAntiProxyService.getName());
                }
                ProxyResult result = abstractAntiProxyService.checkProxy(this.inetAddress);
                if (this.nullCordX.canSendDebugLog()) {
                    this.nullCordX.sendDebugLog("Ip " + this.inetAddress.getHostAddress() + " successfully checked in service " + abstractAntiProxyService.getName() + ". Result: " + result);
                }
                return result;
            }
            catch (ProxyServiceCheckFailedException e) {
                String errorMessage = "Failed to check ip " + this.inetAddress.getHostAddress() + " in service " + abstractAntiProxyService.getName();
                if (!this.nullCordX.canSendDebugLog()) {
                    this.nullCordX.getLogger().log(Level.WARNING, errorMessage + ": " + e.getMessage());
                } else {
                    this.nullCordX.getLogger().log(Level.SEVERE, errorMessage, e);
                }
                return !AntibotSettings.IMP.ANTIBOT.ANTI_PROXY_CHECK.DO_NOT_KICK_IF_ERROR ? ProxyResult.ERROR : ProxyResult.ERROR_BUT_ALLOWED;
            }
        }
        return ProxyResult.ALLOWED;
    }

    public CachedProxyCheckerImpl(NullCordXImpl nullCordX, InetAddress inetAddress) {
        this.nullCordX = nullCordX;
        this.inetAddress = inetAddress;
    }

    public NullCordXImpl getNullCordX() {
        return this.nullCordX;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    @Override
    public ProxyResult getCachedResult() {
        return this.cachedResult;
    }

    @Override
    public void setCachedResult(ProxyResult cachedResult) {
        this.cachedResult = cachedResult;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CachedProxyCheckerImpl)) {
            return false;
        }
        CachedProxyCheckerImpl other = (CachedProxyCheckerImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NullCordXImpl this$nullCordX = this.getNullCordX();
        NullCordXImpl other$nullCordX = other.getNullCordX();
        if (this$nullCordX == null ? other$nullCordX != null : !this$nullCordX.equals(other$nullCordX)) {
            return false;
        }
        InetAddress this$inetAddress = this.getInetAddress();
        InetAddress other$inetAddress = other.getInetAddress();
        if (this$inetAddress == null ? other$inetAddress != null : !((Object)this$inetAddress).equals(other$inetAddress)) {
            return false;
        }
        ReentrantLock this$lock = this.getLock();
        ReentrantLock other$lock = other.getLock();
        if (this$lock == null ? other$lock != null : !this$lock.equals(other$lock)) {
            return false;
        }
        ProxyResult this$cachedResult = this.getCachedResult();
        ProxyResult other$cachedResult = other.getCachedResult();
        return !(this$cachedResult == null ? other$cachedResult != null : !((Object)((Object)this$cachedResult)).equals((Object)other$cachedResult));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CachedProxyCheckerImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NullCordXImpl $nullCordX = this.getNullCordX();
        result = result * 59 + ($nullCordX == null ? 43 : $nullCordX.hashCode());
        InetAddress $inetAddress = this.getInetAddress();
        result = result * 59 + ($inetAddress == null ? 43 : ((Object)$inetAddress).hashCode());
        ReentrantLock $lock = this.getLock();
        result = result * 59 + ($lock == null ? 43 : $lock.hashCode());
        ProxyResult $cachedResult = this.getCachedResult();
        result = result * 59 + ($cachedResult == null ? 43 : ((Object)((Object)$cachedResult)).hashCode());
        return result;
    }

    public String toString() {
        return "CachedProxyCheckerImpl(nullCordX=" + this.getNullCordX() + ", inetAddress=" + this.getInetAddress() + ", lock=" + this.getLock() + ", cachedResult=" + this.getCachedResult() + ")";
    }
}

