/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.shieldcommunity.nullcordx.antibot.captcha.GlyphsBounds;
import net.shieldcommunity.nullcordx.antibot.captcha.RenderedGlyph;
import net.shieldcommunity.nullcordx.antibot.captcha.RenderedGlyphListData;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectMap;

public final class RenderedFont {
    private final Int2ObjectMap<RenderedGlyphListData> charToGlyphs;

    public RenderedGlyphListData getGlyphList(char charToGet) {
        return (RenderedGlyphListData)this.charToGlyphs.get(charToGet);
    }

    public GlyphsBounds createGlyphsBounds(String text, int fontSpace, Random random) {
        ArrayList<RenderedGlyph> glyphs = new ArrayList<RenderedGlyph>();
        int width = 0;
        int height = 0;
        for (char c : text.toCharArray()) {
            RenderedGlyphListData renderedGlyphList = this.getGlyphList(c);
            if (renderedGlyphList == null) {
                throw new IllegalStateException("Missing rendered glyph: " + c);
            }
            List<RenderedGlyph> rotatedGlyphs = renderedGlyphList.getData();
            RenderedGlyph randomGlyph = rotatedGlyphs.get(random.nextInt(rotatedGlyphs.size()));
            int localWidth = randomGlyph.getWidth();
            int localHeight = randomGlyph.getHeight();
            width += localWidth + fontSpace;
            if (localHeight > height) {
                height = localHeight;
            }
            glyphs.add(randomGlyph);
        }
        return new GlyphsBounds(glyphs, width, height);
    }

    public RenderedFont(Int2ObjectMap<RenderedGlyphListData> charToGlyphs) {
        this.charToGlyphs = charToGlyphs;
    }

    public Int2ObjectMap<RenderedGlyphListData> getCharToGlyphs() {
        return this.charToGlyphs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenderedFont)) {
            return false;
        }
        RenderedFont other = (RenderedFont)o;
        Int2ObjectMap<RenderedGlyphListData> this$charToGlyphs = this.getCharToGlyphs();
        Int2ObjectMap<RenderedGlyphListData> other$charToGlyphs = other.getCharToGlyphs();
        return !(this$charToGlyphs == null ? other$charToGlyphs != null : !this$charToGlyphs.equals(other$charToGlyphs));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Int2ObjectMap<RenderedGlyphListData> $charToGlyphs = this.getCharToGlyphs();
        result = result * 59 + ($charToGlyphs == null ? 43 : $charToGlyphs.hashCode());
        return result;
    }

    public String toString() {
        return "RenderedFont(charToGlyphs=" + this.getCharToGlyphs() + ")";
    }
}

