/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.painter;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.ColorIndexWrapper;

public class MapBuffer {
    private final int width;
    private final int height;
    private final ColorIndexWrapper colorIndexWrapper;
    private final byte[] mapBuffer;
    private static final int ALPHA_MASK = -16777216;

    public MapBuffer(ColorIndexWrapper colorIndexWrapper, int width, int height) {
        this.width = width;
        this.height = height;
        this.colorIndexWrapper = colorIndexWrapper;
        this.mapBuffer = new byte[width * height];
    }

    public void draw(BufferedImage image) {
        if (!this.colorIndexWrapper.isCanBeLoaded()) {
            return;
        }
        int[] rawImage = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < this.width * this.height; ++i) {
            this.mapBuffer[i] = this.getCachedColor(rawImage[i]);
        }
    }

    private byte getCachedColor(int rgb) {
        if (MapBuffer.getAlpha(rgb) < 128) {
            return 0;
        }
        return this.colorIndexWrapper.getIndexes()[rgb & 0xFFFFFF];
    }

    private static int getAlpha(int rgb) {
        return (rgb & 0xFF000000) >>> 24;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ColorIndexWrapper getColorIndexWrapper() {
        return this.colorIndexWrapper;
    }

    public byte[] getMapBuffer() {
        return this.mapBuffer;
    }
}

