/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.MapCanvasConstants;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.AbstractRenderLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderSession;
import net.shieldcommunity.nullcordx.utils.ImageUtils;

public class RenderLayerSplitter
extends AbstractRenderLayer {
    private final int chunkCount;

    public RenderLayerSplitter(String name, int chunkCount) {
        super(name);
        this.chunkCount = chunkCount;
    }

    @Override
    public BufferedImage drawLayer(BufferedImage image, Color color, Random random, RenderSession renderSession) {
        int rows = MapCanvasConstants.calculateSizeModification(image.getWidth()) * this.chunkCount;
        int columns = MapCanvasConstants.calculateSizeModification(image.getHeight()) * this.chunkCount;
        BufferedImage[] images = ImageUtils.splitImage(image, rows, columns);
        ArrayList<BufferedImage> arrayImages = new ArrayList<BufferedImage>(Arrays.asList(images));
        Collections.shuffle(arrayImages, random);
        return ImageUtils.restoreSplitImage(arrayImages, rows, columns);
    }

    public String toString() {
        return "RenderLayerSplitter(chunkCount=" + this.chunkCount + ")";
    }
}

