/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.settings;

import java.io.File;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.shieldcommunity.nullcordx.antibot.CheckingFactoriesImpl;
import net.shieldcommunity.nullcordx.antibot.captcha.FontListData;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.AnswerGeneratorFactory;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.FontCacheType;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.font.FontListDataTask;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.answer.AbstractCaptchaAnswerGenerator;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.answer.ArithmeticAnswerGenerator;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.answer.ArithmeticOperationType;
import net.shieldcommunity.nullcordx.cache.PerRaCStorage;
import net.shieldcommunity.nullcordx.config.CaptchaSettings;
import net.shieldcommunity.nullcordx.utils.CustomFJPThreadFactory;
import net.shieldcommunity.nullcordx.utils.TasksUtils;

public class ArithmeticAnswerFactory
implements AnswerGeneratorFactory {
    private final String name;
    private final Logger logger;
    private final CheckingFactoriesImpl checkingFactories;
    private final CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.ARITHMETIC_ANSWER_LAYER_TEMPLATE arithmeticAnswerLayerTemplate;
    private final FontCacheType fontCacheType;
    private final File cacheDirectory;

    @Override
    public AbstractCaptchaAnswerGenerator create() {
        try {
            int minRows = 1;
            int maxRows = 1;
            int minColumns = 1;
            int maxColumns = 1;
            if (this.checkingFactories.isFramedCaptchaUsed()) {
                minRows = this.checkingFactories.getMinFrameRow();
                maxRows = this.checkingFactories.getMaxFrameRow();
                minColumns = this.checkingFactories.getMinFrameColumn();
                maxColumns = this.checkingFactories.getMaxFrameColumn();
            }
            PerRaCStorage<FontListData> fontListDataPerRaCStorage = new PerRaCStorage<FontListData>(FontListData.class, minRows, maxRows, minColumns, maxColumns);
            int threads = CaptchaSettings.IMP.CAPTCHA.THREADS_FOR_GENERATION;
            if (threads < 0) {
                threads = Runtime.getRuntime().availableProcessors();
            }
            ForkJoinPool executor = new ForkJoinPool(threads, new CustomFJPThreadFactory("FontLoaderAndResizer", 1), null, false);
            EnumMap<ArithmeticOperationType, char[]> charactersByOperationType = new EnumMap<ArithmeticOperationType, char[]>(ArithmeticOperationType.class);
            if (this.arithmeticAnswerLayerTemplate.ENABLED_ADDITION) {
                charactersByOperationType.put(ArithmeticOperationType.ADDITION, this.arithmeticAnswerLayerTemplate.ADDITION_CHARS.toCharArray());
            }
            if (this.arithmeticAnswerLayerTemplate.ENABLED_SUBSTRACTION) {
                charactersByOperationType.put(ArithmeticOperationType.SUBSTRACTION, this.arithmeticAnswerLayerTemplate.SUBSTRACTION_CHARS.toCharArray());
            }
            if (this.arithmeticAnswerLayerTemplate.ENABLED_MULTIPLICATION) {
                charactersByOperationType.put(ArithmeticOperationType.MULTIPLICATION, this.arithmeticAnswerLayerTemplate.MULTIPLICATION_CHARS.toCharArray());
            }
            if (this.arithmeticAnswerLayerTemplate.ENABLED_DIVISION) {
                charactersByOperationType.put(ArithmeticOperationType.DIVISION, this.arithmeticAnswerLayerTemplate.DIVISION_CHARS.toCharArray());
            }
            HashSet<Character> characterSet = new HashSet<Character>();
            Iterator iterator = charactersByOperationType.values().iterator();
            while (iterator.hasNext()) {
                char[] characters;
                char[] cArray = characters = (char[])iterator.next();
                int n = cArray.length;
                for (int i = 0; i < n; ++i) {
                    char c = cArray[i];
                    characterSet.add(Character.valueOf(c));
                }
            }
            for (int i = 0; i <= this.arithmeticAnswerLayerTemplate.MAX_ARITHMETIC_NUMBER; ++i) {
                for (char c : ("" + i).toCharArray()) {
                    characterSet.add(Character.valueOf(c));
                }
            }
            for (String tmpExample : this.arithmeticAnswerLayerTemplate.ARITHMETIC_EXAMPLES) {
                tmpExample = tmpExample.replace("%first%", "").replace("%second%", "").replace("%operator%", "");
                for (char c : tmpExample.toCharArray()) {
                    characterSet.add(Character.valueOf(c));
                }
            }
            this.logger.log(Level.INFO, "Loading " + characterSet.size() + " characters for arithmetic type fonts for render layer '" + this.name + "'...");
            long start = System.currentTimeMillis();
            List<PerRaCStorage.StorageComputeTask> tasks = fontListDataPerRaCStorage.createTasks(minRows, maxRows, minColumns, maxColumns, (row, column) -> executor.invoke(new FontListDataTask(this.arithmeticAnswerLayerTemplate.FONT_SIZE * row, 128 * column, this.arithmeticAnswerLayerTemplate.ROTATE_COUNT, this.arithmeticAnswerLayerTemplate.OUTLINE, this.arithmeticAnswerLayerTemplate.DEFAULT_FONT_SANS_SERIF, this.arithmeticAnswerLayerTemplate.DEFAULT_FONT_SERIF, this.arithmeticAnswerLayerTemplate.DEFAULT_FONT_MONOSPACED, this.arithmeticAnswerLayerTemplate.DEFAULT_FONT_DIALOG, this.arithmeticAnswerLayerTemplate.DEFAULT_FONT_DIALOG_INPUT, characterSet, this.arithmeticAnswerLayerTemplate.CUSTOM_FONTS, this.fontCacheType, this.cacheDirectory, this.logger)));
            TasksUtils.executeSimpleTasks(executor, this.logger, tasks, (logger, dataToGenerate, perSec) -> logger.log(Level.INFO, "Async arithmetic font loader and resizer for '" + this.name + "' [" + dataToGenerate + "/+" + perSec + " cps]"));
            fontListDataPerRaCStorage.loadFutureTasks(tasks);
            long end = System.currentTimeMillis();
            this.logger.log(Level.INFO, "Loaded " + characterSet.size() + " characters for arithmetic type fonts for render layer '" + this.name + "' with amount of " + fontListDataPerRaCStorage.getAllData().get(0).getLoadedFontsCount() + " fonts in " + (end - start) + "ms");
            return new ArithmeticAnswerGenerator(fontListDataPerRaCStorage, charactersByOperationType, this.arithmeticAnswerLayerTemplate);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to create arithmetic answer for render layer '" + this.name + "'", e);
            return null;
        }
    }

    public ArithmeticAnswerFactory(String name, Logger logger, CheckingFactoriesImpl checkingFactories, CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.ARITHMETIC_ANSWER_LAYER_TEMPLATE arithmeticAnswerLayerTemplate, FontCacheType fontCacheType, File cacheDirectory) {
        this.name = name;
        this.logger = logger;
        this.checkingFactories = checkingFactories;
        this.arithmeticAnswerLayerTemplate = arithmeticAnswerLayerTemplate;
        this.fontCacheType = fontCacheType;
        this.cacheDirectory = cacheDirectory;
    }
}

