/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.settings;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.shieldcommunity.nullcordx.antibot.CheckingFactoriesImpl;
import net.shieldcommunity.nullcordx.antibot.captcha.FontListData;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.AnswerGeneratorFactory;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.FontCacheType;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.font.FontListDataTask;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.answer.AbstractCaptchaAnswerGenerator;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.answer.NumberSpellingAnswerGenerator;
import net.shieldcommunity.nullcordx.cache.PerRaCStorage;
import net.shieldcommunity.nullcordx.config.CaptchaSettings;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.shieldcommunity.nullcordx.utils.CustomFJPThreadFactory;
import net.shieldcommunity.nullcordx.utils.TasksUtils;

public class NumberSpellingFactory
implements AnswerGeneratorFactory {
    private final String name;
    private final Logger logger;
    private final CheckingFactoriesImpl checkingFactories;
    private final CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.NUMBER_SPELLING_ANSWER_LAYER_TEMPLATE numberSpellingAnswerLayerTemplate;
    private final FontCacheType fontCacheType;
    private final File cacheDirectory;

    @Override
    public AbstractCaptchaAnswerGenerator create() {
        try {
            int minRows = 1;
            int maxRows = 1;
            int minColumns = 1;
            int maxColumns = 1;
            if (this.checkingFactories.isFramedCaptchaUsed()) {
                minRows = this.checkingFactories.getMinFrameRow();
                maxRows = this.checkingFactories.getMaxFrameRow();
                minColumns = this.checkingFactories.getMinFrameColumn();
                maxColumns = this.checkingFactories.getMaxFrameColumn();
            }
            PerRaCStorage<FontListData> fontListDataPerRaCStorage = new PerRaCStorage<FontListData>(FontListData.class, minRows, maxRows, minColumns, maxColumns);
            int threads = CaptchaSettings.IMP.CAPTCHA.THREADS_FOR_GENERATION;
            if (threads < 0) {
                threads = Runtime.getRuntime().availableProcessors();
            }
            ForkJoinPool executor = new ForkJoinPool(threads, new CustomFJPThreadFactory("FontLoaderAndResizer", 1), null, false);
            HashSet<Character> characterSet = new HashSet<Character>();
            CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.NUMBER_SPELLING_ANSWER_LAYER_TEMPLATE.HUNDREDS hundreds = this.numberSpellingAnswerLayerTemplate.HUNDREDS;
            CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.NUMBER_SPELLING_ANSWER_LAYER_TEMPLATE.TENTHS tenths = this.numberSpellingAnswerLayerTemplate.TENTHS;
            CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.NUMBER_SPELLING_ANSWER_LAYER_TEMPLATE.UNITS units = this.numberSpellingAnswerLayerTemplate.UNITS;
            CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.NUMBER_SPELLING_ANSWER_LAYER_TEMPLATE.EXCEPTIONS ex = this.numberSpellingAnswerLayerTemplate.EXCEPTIONS;
            List<String> hundredTranslate = Arrays.asList(hundreds.ONE, hundreds.TWO, hundreds.THERE, hundreds.FOUR, hundreds.FIVE, hundreds.SIX, hundreds.SEVEN, hundreds.EIGHT, hundreds.NINE);
            List<String> tenTranslate = Arrays.asList(tenths.ONE, tenths.TWO, tenths.THERE, tenths.FOUR, tenths.FIVE, tenths.SIX, tenths.SEVEN, tenths.EIGHT, tenths.NINE);
            List<String> oneTranslate = Arrays.asList(units.ONE, units.TWO, units.THERE, units.FOUR, units.FIVE, units.SIX, units.SEVEN, units.EIGHT, units.NINE);
            Int2ObjectMap<String> exceptions = NumberSpellingFactory.createExceptionsMap(ex);
            for (String hundres : hundredTranslate) {
                for (char c : hundres.toCharArray()) {
                    characterSet.add(Character.valueOf(c));
                }
            }
            for (String ten : tenTranslate) {
                for (char c : ten.toCharArray()) {
                    characterSet.add(Character.valueOf(c));
                }
            }
            for (String one : oneTranslate) {
                for (char c : one.toCharArray()) {
                    characterSet.add(Character.valueOf(c));
                }
            }
            for (String exc : exceptions.values()) {
                for (char c : exc.toCharArray()) {
                    characterSet.add(Character.valueOf(c));
                }
            }
            this.logger.log(Level.INFO, "Loading " + characterSet.size() + " characters for number spelling type fonts for render layer '" + this.name + "'...");
            long start = System.currentTimeMillis();
            List<PerRaCStorage.StorageComputeTask> tasks = fontListDataPerRaCStorage.createTasks(minRows, maxRows, minColumns, maxColumns, (row, column) -> executor.invoke(new FontListDataTask(this.numberSpellingAnswerLayerTemplate.FONT_SIZE * row, 128 * column, this.numberSpellingAnswerLayerTemplate.ROTATE_COUNT, this.numberSpellingAnswerLayerTemplate.OUTLINE, this.numberSpellingAnswerLayerTemplate.DEFAULT_FONT_SANS_SERIF, this.numberSpellingAnswerLayerTemplate.DEFAULT_FONT_SERIF, this.numberSpellingAnswerLayerTemplate.DEFAULT_FONT_MONOSPACED, this.numberSpellingAnswerLayerTemplate.DEFAULT_FONT_DIALOG, this.numberSpellingAnswerLayerTemplate.DEFAULT_FONT_DIALOG_INPUT, characterSet, this.numberSpellingAnswerLayerTemplate.CUSTOM_FONTS, this.fontCacheType, this.cacheDirectory, this.logger)));
            TasksUtils.executeSimpleTasks(executor, this.logger, tasks, (logger, dataToGenerate, perSec) -> logger.log(Level.INFO, "Async number-spelling font loader and resizer for '" + this.name + "' [" + dataToGenerate + "/+" + perSec + " cps]"));
            fontListDataPerRaCStorage.loadFutureTasks(tasks);
            long end = System.currentTimeMillis();
            this.logger.log(Level.INFO, "Loaded " + characterSet.size() + " characters for number spelling type fonts for render layer '" + this.name + "' with amount of " + fontListDataPerRaCStorage.getAllData().get(0).getLoadedFontsCount() + " fonts in " + (end - start) + "ms");
            Int2ObjectOpenHashMap<List<String>> readySpellings = new Int2ObjectOpenHashMap<List<String>>();
            for (int i = 100; i <= 999; ++i) {
                String chars = "" + i;
                ArrayList<String> spells = new ArrayList<String>();
                int hundred = Integer.parseInt(String.valueOf(chars.charAt(0)));
                String stringHundred = hundredTranslate.get(hundred - 1);
                spells.add(stringHundred);
                int exceptionValue = Integer.parseInt(chars.substring(1));
                if (exceptionValue >= 11 && exceptionValue <= 19) {
                    spells.add((String)exceptions.get(exceptionValue));
                } else {
                    int one;
                    int ten = Integer.parseInt(String.valueOf(chars.charAt(1)));
                    if (ten > 0) {
                        String valueTen = tenTranslate.get(ten - 1);
                        spells.add(valueTen);
                    }
                    if ((one = Integer.parseInt(String.valueOf(chars.charAt(2)))) > 0) {
                        String valueOne = oneTranslate.get(one - 1);
                        spells.add(valueOne);
                    }
                }
                readySpellings.put(i, (List<String>)spells);
            }
            return new NumberSpellingAnswerGenerator(fontListDataPerRaCStorage, readySpellings, this.numberSpellingAnswerLayerTemplate);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to create number spelling answer for render layer '" + this.name + "'", e);
            return null;
        }
    }

    private static Int2ObjectMap<String> createExceptionsMap(CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.NUMBER_SPELLING_ANSWER_LAYER_TEMPLATE.EXCEPTIONS ex) {
        Int2ObjectOpenHashMap<String> exceptions = new Int2ObjectOpenHashMap<String>();
        exceptions.put(11, ex.ELEVEN);
        exceptions.put(12, ex.TWELVE);
        exceptions.put(13, ex.THIRTEEN);
        exceptions.put(14, ex.FOURTEEN);
        exceptions.put(15, ex.FIFTEEN);
        exceptions.put(16, ex.SIXTEEN);
        exceptions.put(17, ex.SEVENTEEN);
        exceptions.put(18, ex.EIGHTEEN);
        exceptions.put(19, ex.NINETEEN);
        return exceptions;
    }

    public NumberSpellingFactory(String name, Logger logger, CheckingFactoriesImpl checkingFactories, CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.NUMBER_SPELLING_ANSWER_LAYER_TEMPLATE numberSpellingAnswerLayerTemplate, FontCacheType fontCacheType, File cacheDirectory) {
        this.name = name;
        this.logger = logger;
        this.checkingFactories = checkingFactories;
        this.numberSpellingAnswerLayerTemplate = numberSpellingAnswerLayerTemplate;
        this.fontCacheType = fontCacheType;
        this.cacheDirectory = cacheDirectory;
    }
}

