/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.antibot.captcha.GenerationStateWrapper;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.MapPalette;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderSession;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.CaptchaGenerationTask;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.filecache.CaptchaFileCacheType;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.resizer.GroupedImage;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.resizer.ResizedImage;
import net.shieldcommunity.nullcordx.api.utils.FastRandom;
import net.shieldcommunity.nullcordx.cache.CachedEntityFrameDataImpl;
import net.shieldcommunity.nullcordx.cache.CachedMapDataPacket;
import net.shieldcommunity.nullcordx.cache.CaptchaHolderImpl;
import net.shieldcommunity.nullcordx.cache.PerRaCStorage;
import net.shieldcommunity.nullcordx.cache.cachedframes.CachedFramesPickCaptchaImpl;
import net.shieldcommunity.nullcordx.config.FrameSizes;
import net.shieldcommunity.nullcordx.config.captcha.PickCaptchaSettings;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.util.XoRoShiRo128PlusRandom;
import net.shieldcommunity.nullcordx.protocol.ProtocolMapData;
import net.shieldcommunity.nullcordx.protocol.packets.MapDataPacket;
import net.shieldcommunity.nullcordx.utils.CompressorThreadLocal;
import net.shieldcommunity.nullcordx.utils.ImageUtils;

public class PickCaptchaGenerationTask
extends CaptchaGenerationTask<CachedFramesPickCaptchaImpl<CachedMapDataPacket>> {
    private final Map<String, GroupedImage> groupedImages;

    public PickCaptchaGenerationTask(ForkJoinPool executor, Logger logger, NullCordXImpl nullCordX, GenerationStateWrapper generationStateWrapper, CompressorThreadLocal compressorThreadLocal, boolean force, CaptchaHolderImpl<CachedFramesPickCaptchaImpl<CachedMapDataPacket>> holder, List<Color> colors, List<RenderLayer> groupedRenderLayers, List<RenderLayer> postRenderLayers, String cacheHash, CaptchaFileCacheType<CachedFramesPickCaptchaImpl<CachedMapDataPacket>> cacheType, Map<String, GroupedImage> groupedImages) {
        super(executor, logger, nullCordX, generationStateWrapper, compressorThreadLocal, force, holder, colors, groupedRenderLayers, postRenderLayers, cacheHash, cacheType);
        this.groupedImages = groupedImages;
    }

    @Override
    public void generate(File cachedCaptchaFile) {
        if (this.groupedImages == null) {
            this.logger.log(Level.SEVERE, "Failed to generate pick captcha. Groups for captcha were not found. Make sure that you correctly set up the directory where the groups are located and that they also contain images.");
            this.generationStateWrapper.setCancelled(true);
            return;
        }
        XoRoShiRo128PlusRandom rnd = FastRandom.getFastRandom();
        FrameSizes.Frame frame = PickCaptchaSettings.IMP.PICK_CAPTCHA.FRAME_SIZES.getRandomFrame(rnd);
        int row = frame.getRow();
        int column = frame.getColumn();
        ArrayList<GroupedImage> groups = new ArrayList<GroupedImage>(this.groupedImages.values());
        GroupedImage mainGroupTheme = (GroupedImage)groups.get(((Random)rnd).nextInt(groups.size()));
        groups.remove(mainGroupTheme);
        HashSet<GroupedImage> readyGroups = new HashSet<GroupedImage>();
        readyGroups.add(mainGroupTheme);
        int groupsCounts = PickCaptchaSettings.IMP.PICK_CAPTCHA.MAX_GROUPS_PER_CAPTCHA;
        for (int i = 0; i < groupsCounts; ++i) {
            readyGroups.add((GroupedImage)groups.get(((Random)rnd).nextInt(groups.size())));
        }
        ArrayList readyGroupsList = new ArrayList(readyGroups);
        ImageData[] readyImages = new ImageData[row * column];
        RenderSession renderSession = new RenderSession();
        while (PickCaptchaGenerationTask.isArrayContainsNull(readyImages)) {
            if (this.generationStateWrapper.isCancelled()) {
                return;
            }
            int randomX = ((Random)rnd).nextInt(row);
            int randomY = ((Random)rnd).nextInt(column);
            ImageData randomImageLocation = readyImages[randomY * row + randomX];
            if (randomImageLocation != null) continue;
            GroupedImage group = (GroupedImage)readyGroupsList.get(((Random)rnd).nextInt(readyGroupsList.size()));
            ArrayList<ResizedImage> images = new ArrayList<ResizedImage>(group.getImages());
            ResizedImage randomResizedImage = (ResizedImage)images.get(((Random)rnd).nextInt(images.size()));
            PerRaCStorage<BufferedImage> randomPerRac = randomResizedImage.getStorage();
            int randomSizeX = ((Random)rnd).nextInt(PickCaptchaSettings.IMP.PICK_CAPTCHA.MAX_IMAGE_ROW) + 1;
            int randomSizeY = ((Random)rnd).nextInt(PickCaptchaSettings.IMP.PICK_CAPTCHA.MAX_IMAGE_COLUMN) + 1;
            if (randomSizeX > row) {
                randomSizeX = row;
            }
            if (randomSizeY > column) {
                randomSizeY = column;
            }
            if (!PickCaptchaGenerationTask.canPlaceImage(readyImages, row, column, randomSizeX, randomSizeY, randomX, randomY)) continue;
            BufferedImage randomImage = randomPerRac.getDataByRaC(randomSizeX, randomSizeY);
            Color randomColor = (Color)this.colors.get(((Random)rnd).nextInt(this.colors.size()));
            ImageData[] localImage = PickCaptchaGenerationTask.convertImageToImageData(randomImage, group, randomSizeX, randomSizeY, this.postRenderLayers, randomColor, rnd, renderSession);
            PickCaptchaGenerationTask.placeImageInsideImage(readyImages, row, localImage, randomSizeX, randomSizeY, randomX, randomY);
        }
        ArrayList<CachedMapDataPacket> frames = new ArrayList<CachedMapDataPacket>();
        ArrayList<MapDataGenerationTask> mapDataTasks = new ArrayList<MapDataGenerationTask>();
        Int2ObjectOpenHashMap<String> answerPerMap = new Int2ObjectOpenHashMap<String>();
        for (int mapId = 1; mapId <= row * column; ++mapId) {
            ImageData imageData = readyImages[mapId - 1];
            mapDataTasks.add(new MapDataGenerationTask(this.generationStateWrapper, this.compressorThreadLocal, mapId, imageData.getImage()));
            answerPerMap.put(mapId, imageData.getName());
        }
        for (MapDataGenerationTask task : PickCaptchaGenerationTask.invokeAll(mapDataTasks)) {
            try {
                frames.add((CachedMapDataPacket)task.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Collections.shuffle(frames, rnd);
        CachedEntityFrameDataImpl cachedEntityFrameData = this.nullCordX.getCachedCaptchaManager().getCachedEntityFrameData().getDataByRaC(row, column);
        CachedFramesPickCaptchaImpl cachedFrames = new CachedFramesPickCaptchaImpl(1, Collections.unmodifiableList(frames), cachedEntityFrameData, answerPerMap, mainGroupTheme.getName());
        this.holder.setNewCaptcha(null, cachedFrames);
        if (this.generationStateWrapper.isCancelled()) {
            return;
        }
        this.cacheType.saveCaptchaCache(null, ProtocolConstants.SUPPORTED_VERSION_IDS_CHANGED, cachedFrames, cachedCaptchaFile);
    }

    private static <T> boolean isArrayContainsNull(T[] array) {
        for (T data : array) {
            if (data != null) continue;
            return true;
        }
        return false;
    }

    private static ImageData[] convertImageToImageData(BufferedImage image, GroupedImage groupedImage, int rows, int columns, List<RenderLayer> postRenderLayers, Color color, Random rnd, RenderSession renderSession) {
        if (rows == 1 && columns == 1) {
            return new ImageData[]{new ImageData(groupedImage.getName(), PickCaptchaGenerationTask.applyRenderLayerForImage(image, postRenderLayers, color, rnd, renderSession))};
        }
        ImageData[] imageData = new ImageData[rows * columns];
        BufferedImage[] splitImage = ImageUtils.splitImage(PickCaptchaGenerationTask.applyRenderLayerForImage(image, postRenderLayers, color, rnd, renderSession), rows, columns);
        for (int i = 0; i < imageData.length; ++i) {
            imageData[i] = new ImageData(groupedImage.getName(), splitImage[i]);
        }
        return imageData;
    }

    private static BufferedImage applyRenderLayerForImage(BufferedImage image, List<RenderLayer> postRenderLayers, Color color, Random rnd, RenderSession renderSession) {
        return RenderLayer.renderCurrentLayers(image, postRenderLayers, color, rnd, renderSession);
    }

    private static boolean canPlaceImage(ImageData[] source, int sourceRows, int sourceColumns, int localRows, int localColumns, int localX, int localY) {
        if (localRows > sourceRows || localColumns > sourceColumns) {
            return false;
        }
        for (int x = 0; x < localRows; ++x) {
            for (int y = 0; y < localColumns; ++y) {
                if (x + localX >= sourceRows || y + localY >= sourceColumns) {
                    return false;
                }
                int index = (y + localY) * sourceRows + (x + localX);
                if (index >= source.length) {
                    return false;
                }
                ImageData currentImage = source[index];
                if (currentImage == null) continue;
                return false;
            }
        }
        return true;
    }

    private static void placeImageInsideImage(ImageData[] source, int sourceSize, ImageData[] local, int localRows, int localColumns, int localX, int localY) {
        for (int x = 0; x < localRows; ++x) {
            for (int y = 0; y < localColumns; ++y) {
                source[(y + localY) * sourceSize + (x + localX)] = local[y * localRows + x];
            }
        }
    }

    private static final class ImageData {
        private final String name;
        private final BufferedImage image;

        public ImageData(String name, BufferedImage image) {
            this.name = name;
            this.image = image;
        }

        public String getName() {
            return this.name;
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImageData)) {
                return false;
            }
            ImageData other = (ImageData)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            BufferedImage this$image = this.getImage();
            BufferedImage other$image = other.getImage();
            return !(this$image == null ? other$image != null : !this$image.equals(other$image));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            BufferedImage $image = this.getImage();
            result = result * 59 + ($image == null ? 43 : $image.hashCode());
            return result;
        }

        public String toString() {
            return "PickCaptchaGenerationTask.ImageData(name=" + this.getName() + ", image=" + this.getImage() + ")";
        }
    }

    private static class MapDataGenerationTask
    extends RecursiveTask<CachedMapDataPacket> {
        private final GenerationStateWrapper generationStateWrapper;
        private final CompressorThreadLocal compressorThreadLocal;
        private final int mapId;
        private final BufferedImage image;

        @Override
        protected CachedMapDataPacket compute() {
            if (this.generationStateWrapper.isCancelled()) {
                return new CachedMapDataPacket();
            }
            ProtocolMapData map = MapPalette.imageToMapData(this.image);
            return CachedMapDataPacket.create(new MapDataPacket(this.mapId, 0, map), this.compressorThreadLocal);
        }

        public MapDataGenerationTask(GenerationStateWrapper generationStateWrapper, CompressorThreadLocal compressorThreadLocal, int mapId, BufferedImage image) {
            this.generationStateWrapper = generationStateWrapper;
            this.compressorThreadLocal = compressorThreadLocal;
            this.mapId = mapId;
            this.image = image;
        }
    }
}

