/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.filecache;

import io.netty.buffer.ByteBuf;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.filecache.CaptchaFileCacheType;
import net.shieldcommunity.nullcordx.cache.CachedMapDataPacket;
import net.shieldcommunity.nullcordx.cache.CachedPacket;
import net.shieldcommunity.nullcordx.cache.CaptchaHolderImpl;
import net.shieldcommunity.nullcordx.utils.IOUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum HandCaptchaFileCache implements CaptchaFileCacheType<CachedMapDataPacket>
{
    BINZ{

        @Override
        public String getCacheName() {
            return "hand_captcha.binz";
        }

        @Override
        public void saveCaptchaCache(String answer, List<Integer> supportedVersions, CachedMapDataPacket readyPacket, File cachedCaptchaFile) {
            ByteBuf out;
            ByteBuf buffer = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
            try {
                HandCaptchaFileCache.save(answer, readyPacket, buffer);
                out = IOUtils.compress(buffer);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                CachedPacket.releaseByteBufSafe(buffer);
            }
            if (out == null) {
                return;
            }
            try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(cachedCaptchaFile.toPath(), new OpenOption[0]));){
                int size = out.readableBytes();
                for (int i = 0; i < size; ++i) {
                    outputStream.write(out.readByte());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                CachedPacket.releaseByteBufSafe(out);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void loadCaptchaCache(NullCordXImpl nullCordX, File cachedCaptchaFile, CaptchaHolderImpl<CachedMapDataPacket> holder) {
            ByteBuf out;
            byte[] bytes;
            try {
                bytes = Files.readAllBytes(cachedCaptchaFile.toPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ByteBuf buffer = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
            try {
                buffer.writeBytes(bytes);
                out = IOUtils.decompress(buffer);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                CachedPacket.releaseByteBufSafe(buffer);
            }
            if (out == null) {
                return;
            }
            try {
                HandCaptchaFileCache.load(out, holder);
            }
            finally {
                CachedPacket.releaseByteBufSafe(out);
            }
        }
    }
    ,
    BIN{

        @Override
        public String getCacheName() {
            return "hand_captcha.bin";
        }

        @Override
        public void saveCaptchaCache(String answer, List<Integer> supportedVersions, CachedMapDataPacket readyPacket, File cachedCaptchaFile) {
            ByteBuf buffer = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
            try {
                HandCaptchaFileCache.save(answer, readyPacket, buffer);
                try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(cachedCaptchaFile.toPath(), new OpenOption[0]));){
                    int size = buffer.readableBytes();
                    for (int i = 0; i < size; ++i) {
                        outputStream.write(buffer.readByte());
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                CachedPacket.releaseByteBufSafe(buffer);
            }
        }

        @Override
        public void loadCaptchaCache(NullCordXImpl nullCordX, File cachedCaptchaFile, CaptchaHolderImpl<CachedMapDataPacket> holder) {
            byte[] bytes;
            try {
                bytes = Files.readAllBytes(cachedCaptchaFile.toPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ByteBuf buffer = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
            try {
                buffer.writeBytes(bytes);
                HandCaptchaFileCache.load(buffer, holder);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                CachedPacket.releaseByteBufSafe(buffer);
            }
        }
    }
    ,
    NONE{

        @Override
        public String getCacheName() {
            return null;
        }

        @Override
        public void saveCaptchaCache(String answer, List<Integer> supportedVersions, CachedMapDataPacket readyPacket, File cachedCaptchaFile) {
        }

        @Override
        public void loadCaptchaCache(NullCordXImpl nullCordX, File cachedCaptchaFile, CaptchaHolderImpl<CachedMapDataPacket> holder) {
        }
    };


    private static void save(String answer, CachedMapDataPacket readyPacket, ByteBuf buffer) {
        buffer.writeInt(4);
        IOUtils.writeString(answer, buffer);
        readyPacket.serialize(buffer);
    }

    private static void load(ByteBuf out, CaptchaHolderImpl<CachedMapDataPacket> holder) {
        int captchaVersion = out.readInt();
        if (captchaVersion != 4) {
            throw new IllegalStateException("Wrong captcha version! We got: " + captchaVersion);
        }
        String answer = IOUtils.readString(out);
        CachedMapDataPacket readyPacket = CachedMapDataPacket.deserialize(out);
        if (out.isReadable()) {
            throw new IllegalStateException("Data larger than expected. Extra bytes: " + out.readableBytes());
        }
        holder.setNewCaptcha(() -> answer, readyPacket);
    }
}

