/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.tasks.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RecursiveTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.shieldcommunity.nullcordx.antibot.captcha.FontListData;
import net.shieldcommunity.nullcordx.antibot.captcha.RenderedFont;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.FontCacheType;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.font.RenderedFontTask;
import net.shieldcommunity.nullcordx.config.CaptchaSettings;
import net.shieldcommunity.nullcordx.config.FilePaths;
import org.apache.commons.codec.digest.DigestUtils;

public class FontListDataTask
extends RecursiveTask<FontListData> {
    private final int size;
    private final int height;
    private final int rotateCount;
    private final boolean outline;
    private final CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.DEFAULT_FONT_DATA sansSerif;
    private final CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.DEFAULT_FONT_DATA serif;
    private final CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.DEFAULT_FONT_DATA monospaced;
    private final CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.DEFAULT_FONT_DATA dialog;
    private final CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.DEFAULT_FONT_DATA dialogInput;
    private final Set<Character> characters;
    private final FilePaths customFontsDir;
    private final FontCacheType fontCacheType;
    private final File cacheDirectory;
    private final Logger logger;

    @Override
    protected FontListData compute() {
        File cacheFile;
        if (!this.cacheDirectory.exists()) {
            this.cacheDirectory.mkdirs();
        }
        List<FontFileChecksum> fontFileChecksums = this.calculateCustomFontsHash(this.customFontsDir);
        int configurationHash = this.hashCode();
        String hash = configurationHash + "-" + fontFileChecksums.hashCode();
        String fileName = this.fontCacheType.getCacheFileName(hash);
        if (fileName != null && (cacheFile = new File(this.cacheDirectory, fileName)).exists() && !cacheFile.isDirectory()) {
            try {
                return this.fontCacheType.loadFontFromCache(fileName, cacheFile);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to load font with hash '" + hash + "'. Regenerating...");
                return this.generate(fontFileChecksums, hash);
            }
        }
        return this.generate(fontFileChecksums, hash);
    }

    private List<FontFileChecksum> calculateCustomFontsHash(FilePaths filePaths) {
        if (filePaths == null) {
            return Collections.emptyList();
        }
        List<File> files = filePaths.calculateExistsFiles(this.logger, "fonts");
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FontFileChecksum> checksums = new ArrayList<FontFileChecksum>();
        for (File file : files) {
            try {
                InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);
                try {
                    checksums.add(new FontFileChecksum(file, DigestUtils.md5Hex(is)));
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to calculate checksum for custom font file '" + file.toPath() + "'", e);
            }
        }
        return checksums;
    }

    public FontListData generate(List<FontFileChecksum> fontFileChecksums, String hash) {
        ArrayList<Font> fonts = new ArrayList<Font>();
        HashMap<TextAttribute, Object> captchaFontSettings = new HashMap<TextAttribute, Object>();
        captchaFontSettings.put(TextAttribute.SIZE, this.size);
        if (this.sansSerif.ENABLED) {
            fonts.add(this.createDefaultFontByType("SansSerif", this.sansSerif, captchaFontSettings));
        }
        if (this.serif.ENABLED) {
            fonts.add(this.createDefaultFontByType("Serif", this.serif, captchaFontSettings));
        }
        if (this.monospaced.ENABLED) {
            fonts.add(this.createDefaultFontByType("Monospaced", this.monospaced, captchaFontSettings));
        }
        if (this.dialog.ENABLED) {
            fonts.add(this.createDefaultFontByType("Dialog", this.dialog, captchaFontSettings));
        }
        if (this.dialogInput.ENABLED) {
            fonts.add(this.createDefaultFontByType("DialogInput", this.dialogInput, captchaFontSettings));
        }
        for (FontFileChecksum fontFileChecksum : fontFileChecksums) {
            File file = fontFileChecksum.getFile();
            if (!file.exists() || file.isDirectory()) continue;
            try {
                Font forSingleCaptchaFont = Font.createFont(0, file);
                forSingleCaptchaFont = forSingleCaptchaFont.deriveFont(captchaFontSettings);
                GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(forSingleCaptchaFont);
                fonts.add(forSingleCaptchaFont);
            }
            catch (FontFormatException | IOException e) {
                this.logger.log(Level.SEVERE, "Failed to load custom font '" + file.toPath() + "'", e);
            }
        }
        ArrayList<RenderedFontTask> tasks = new ArrayList<RenderedFontTask>();
        for (Font font : fonts) {
            tasks.add(new RenderedFontTask(font, new FontRenderContext(null, true, true), this.characters, this.height, this.rotateCount, this.outline));
        }
        ArrayList<RenderedFont> arrayList = new ArrayList<RenderedFont>();
        try {
            for (RenderedFontTask task : FontListDataTask.invokeAll(tasks)) {
                arrayList.add((RenderedFont)task.get());
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        String string = this.fontCacheType.getCacheFileName(hash);
        FontListData fontListData = new FontListData(string != null ? string : "none", arrayList);
        if (string != null) {
            try {
                File cacheFile = new File(this.cacheDirectory, string);
                this.fontCacheType.saveFontToCache(fontListData, cacheFile);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return fontListData;
    }

    private Font createDefaultFontByType(String type, CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.DEFAULT_FONT_DATA data, Map<TextAttribute, Object> captchaFontSettings) {
        return new Font(type, FontListDataTask.calculateFontStyle(data.ITALIC, data.BOLD), this.size).deriveFont(captchaFontSettings);
    }

    private static int calculateFontStyle(boolean italic, boolean bold) {
        return (italic ? 2 : 0) | (bold ? 1 : 0);
    }

    public FontListDataTask(int size, int height, int rotateCount, boolean outline, CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.DEFAULT_FONT_DATA sansSerif, CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.DEFAULT_FONT_DATA serif, CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.DEFAULT_FONT_DATA monospaced, CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.DEFAULT_FONT_DATA dialog, CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.DEFAULT_FONT_DATA dialogInput, Set<Character> characters, FilePaths customFontsDir, FontCacheType fontCacheType, File cacheDirectory, Logger logger) {
        this.size = size;
        this.height = height;
        this.rotateCount = rotateCount;
        this.outline = outline;
        this.sansSerif = sansSerif;
        this.serif = serif;
        this.monospaced = monospaced;
        this.dialog = dialog;
        this.dialogInput = dialogInput;
        this.characters = characters;
        this.customFontsDir = customFontsDir;
        this.fontCacheType = fontCacheType;
        this.cacheDirectory = cacheDirectory;
        this.logger = logger;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FontListDataTask)) {
            return false;
        }
        FontListDataTask other = (FontListDataTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (this.height != other.height) {
            return false;
        }
        if (this.rotateCount != other.rotateCount) {
            return false;
        }
        if (this.outline != other.outline) {
            return false;
        }
        CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.DEFAULT_FONT_DATA this$sansSerif = this.sansSerif;
        CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.DEFAULT_FONT_DATA other$sansSerif = other.sansSerif;
        if (this$sansSerif == null ? other$sansSerif != null : !((Object)this$sansSerif).equals(other$sansSerif)) {
            return false;
        }
        CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.DEFAULT_FONT_DATA this$serif = this.serif;
        CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.DEFAULT_FONT_DATA other$serif = other.serif;
        if (this$serif == null ? other$serif != null : !((Object)this$serif).equals(other$serif)) {
            return false;
        }
        CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.DEFAULT_FONT_DATA this$monospaced = this.monospaced;
        CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.DEFAULT_FONT_DATA other$monospaced = other.monospaced;
        if (this$monospaced == null ? other$monospaced != null : !((Object)this$monospaced).equals(other$monospaced)) {
            return false;
        }
        CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.DEFAULT_FONT_DATA this$dialog = this.dialog;
        CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.DEFAULT_FONT_DATA other$dialog = other.dialog;
        if (this$dialog == null ? other$dialog != null : !((Object)this$dialog).equals(other$dialog)) {
            return false;
        }
        CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.DEFAULT_FONT_DATA this$dialogInput = this.dialogInput;
        CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.DEFAULT_FONT_DATA other$dialogInput = other.dialogInput;
        if (this$dialogInput == null ? other$dialogInput != null : !((Object)this$dialogInput).equals(other$dialogInput)) {
            return false;
        }
        Set<Character> this$characters = this.characters;
        Set<Character> other$characters = other.characters;
        if (this$characters == null ? other$characters != null : !((Object)this$characters).equals(other$characters)) {
            return false;
        }
        FilePaths this$customFontsDir = this.customFontsDir;
        FilePaths other$customFontsDir = other.customFontsDir;
        return !(this$customFontsDir == null ? other$customFontsDir != null : !((Object)this$customFontsDir).equals(other$customFontsDir));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FontListDataTask;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.size;
        result = result * 59 + this.height;
        result = result * 59 + this.rotateCount;
        result = result * 59 + (this.outline ? 79 : 97);
        CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.DEFAULT_FONT_DATA $sansSerif = this.sansSerif;
        result = result * 59 + ($sansSerif == null ? 43 : ((Object)$sansSerif).hashCode());
        CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.DEFAULT_FONT_DATA $serif = this.serif;
        result = result * 59 + ($serif == null ? 43 : ((Object)$serif).hashCode());
        CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.DEFAULT_FONT_DATA $monospaced = this.monospaced;
        result = result * 59 + ($monospaced == null ? 43 : ((Object)$monospaced).hashCode());
        CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.DEFAULT_FONT_DATA $dialog = this.dialog;
        result = result * 59 + ($dialog == null ? 43 : ((Object)$dialog).hashCode());
        CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.DEFAULT_FONT_DATA $dialogInput = this.dialogInput;
        result = result * 59 + ($dialogInput == null ? 43 : ((Object)$dialogInput).hashCode());
        Set<Character> $characters = this.characters;
        result = result * 59 + ($characters == null ? 43 : ((Object)$characters).hashCode());
        FilePaths $customFontsDir = this.customFontsDir;
        result = result * 59 + ($customFontsDir == null ? 43 : ((Object)$customFontsDir).hashCode());
        return result;
    }

    public static final class FontFileChecksum {
        private final File file;
        private final String checksum;

        public FontFileChecksum(File file, String checksum) {
            this.file = file;
            this.checksum = checksum;
        }

        public File getFile() {
            return this.file;
        }

        public String getChecksum() {
            return this.checksum;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FontFileChecksum)) {
                return false;
            }
            FontFileChecksum other = (FontFileChecksum)o;
            File this$file = this.getFile();
            File other$file = other.getFile();
            if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
                return false;
            }
            String this$checksum = this.getChecksum();
            String other$checksum = other.getChecksum();
            return !(this$checksum == null ? other$checksum != null : !this$checksum.equals(other$checksum));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            File $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
            String $checksum = this.getChecksum();
            result = result * 59 + ($checksum == null ? 43 : $checksum.hashCode());
            return result;
        }

        public String toString() {
            return "FontListDataTask.FontFileChecksum(file=" + this.getFile() + ", checksum=" + this.getChecksum() + ")";
        }
    }
}

