/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.tasks.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.RecursiveTask;
import net.shieldcommunity.nullcordx.antibot.captcha.RenderedFont;
import net.shieldcommunity.nullcordx.antibot.captcha.RenderedGlyphListData;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.font.GlyphRenderTask;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

public class RenderedFontTask
extends RecursiveTask<RenderedFont> {
    private final Font font;
    private final FontRenderContext ctx;
    private final Set<Character> characters;
    private final int height;
    private final int rotateCount;
    private final boolean outline;

    @Override
    protected RenderedFont compute() {
        Int2ObjectOpenHashMap<RenderedGlyphListData> charToGlyphs = new Int2ObjectOpenHashMap<RenderedGlyphListData>();
        boolean rotate = this.rotateCount != 0;
        int rotateCount = rotate ? this.rotateCount : 1;
        ArrayList<GlyphRenderTask> tasks = new ArrayList<GlyphRenderTask>();
        Iterator<Serializable> iterator = this.characters.iterator();
        while (iterator.hasNext()) {
            char c = iterator.next().charValue();
            tasks.add(new GlyphRenderTask(c, this.font, this.ctx, this.height, rotate, rotateCount, this.outline));
        }
        try {
            for (GlyphRenderTask data : RenderedFontTask.invokeAll(tasks)) {
                RenderedGlyphListData rgld = (RenderedGlyphListData)data.get();
                charToGlyphs.put(rgld.getGlyph(), rgld);
            }
            return new RenderedFont(charToGlyphs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RenderedFontTask(Font font, FontRenderContext ctx, Set<Character> characters, int height, int rotateCount, boolean outline) {
        this.font = font;
        this.ctx = ctx;
        this.characters = characters;
        this.height = height;
        this.rotateCount = rotateCount;
        this.outline = outline;
    }
}

