/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.virtual.checks;

import java.net.InetAddress;
import net.md_5.bungee.BungeeCord;
import net.shieldcommunity.nullcordx.antibot.maxmind.AntiASNManagerImpl;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.AbstractBoundingChecking;
import net.shieldcommunity.nullcordx.api.KickType;
import net.shieldcommunity.nullcordx.api.NullCordX;
import net.shieldcommunity.nullcordx.api.antibot.ExecutorCallback;
import net.shieldcommunity.nullcordx.api.antibot.maxmind.CachedDataChecker;
import net.shieldcommunity.nullcordx.api.antibot.maxmind.MaxMindResult;
import net.shieldcommunity.nullcordx.api.antibot.maxmind.asnlimiter.ASNResultData;
import net.shieldcommunity.nullcordx.api.checking.CheckingFactory;
import net.shieldcommunity.nullcordx.api.checking.CheckingUser;
import net.shieldcommunity.nullcordx.api.utils.location.AxisAlignedBounding;
import net.shieldcommunity.nullcordx.config.AntibotSettings;

public class ASNCheck
extends AbstractBoundingChecking {
    private final AntiASNManagerImpl antiASNManager = BungeeCord.getInstance().getNullCordX().getAntiASNManager();

    public ASNCheck(CheckingFactory checkingFactory, CheckingUser connector, NullCordX nullCordX, AxisAlignedBounding axisAlignedBounding) {
        super(checkingFactory, connector, nullCordX, axisAlignedBounding);
    }

    @Override
    public String getName() {
        return "ASN";
    }

    @Override
    public void onAdded(boolean flush) {
        this.connector.disableFalling();
        this.connector.sendCachedPacket(this.nullCordX.getCachedPacketManager().getCachedSynchronizePlayerPosition());
        this.connector.awaitTeleportConfirm();
        this.startCheck();
    }

    @Override
    public void onRemoved() {
    }

    @Override
    public void onScheduledTask() {
        this.connector.sendCachedPacketWithDelay(this.nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(this.connector.getLanguageType()).getCachedMessageASNChecking(), AntibotSettings.IMP.ANTIBOT.DIMENSION.MESSAGES.CHECKING_MESSAGES_DELAY);
    }

    public void startCheck() {
        this.connector.getChannel().getHandle().eventLoop().execute(() -> {
            if (this.connector.isDisconnected()) {
                return;
            }
            this.startLookup();
        });
    }

    private void startLookup() {
        final InetAddress address = this.connector.getInetAddress();
        CachedDataChecker cachedASNChecker = this.antiASNManager.getCheckerByAddress(address);
        if (cachedASNChecker != null) {
            MaxMindResult result;
            ASNResultData asnResultData = (ASNResultData)cachedASNChecker.getCachedResult();
            if (this.nullCordX.canSendDebugLog()) {
                this.nullCordX.sendDebugLog("ASN cached check result for address '" + address.getHostAddress() + "': " + asnResultData);
            }
            if (!(result = asnResultData.getResult()).isCheckAgainIfCached()) {
                Long asn = asnResultData.getAsn();
                if (asn != null && this.antiASNManager.isBlacklistedASN(asn)) {
                    this.complete(KickType.ASN, "Blacklisted asn");
                } else {
                    this.complete();
                }
                return;
            }
        }
        this.antiASNManager.submitLookup(address, new ExecutorCallback<CachedDataChecker<ASNResultData>>(){

            @Override
            public boolean canExecute() {
                return !ASNCheck.this.connector.isDisconnected();
            }

            @Override
            public void onExecute(CachedDataChecker<ASNResultData> cachedASNChecker) {
                if (ASNCheck.this.connector.isDisconnected()) {
                    return;
                }
                ASNCheck.this.connector.getChannel().getHandle().eventLoop().execute(() -> {
                    if (ASNCheck.this.connector.isDisconnected()) {
                        return;
                    }
                    ASNResultData cachedResult = (ASNResultData)cachedASNChecker.getCachedResult();
                    if (ASNCheck.this.nullCordX.canSendDebugLog()) {
                        ASNCheck.this.nullCordX.sendDebugLog("ASN check result for address '" + address.getHostAddress() + "': " + cachedResult);
                    }
                    MaxMindResult result = cachedResult.getResult();
                    switch (result) {
                        case SUCCESSFULLY: {
                            Long asn = cachedResult.getAsn();
                            if (asn != null && ASNCheck.this.antiASNManager.isBlacklistedASN(asn)) {
                                ASNCheck.this.complete(KickType.ASN, "Blacklisted asn");
                                break;
                            }
                            ASNCheck.this.complete();
                            break;
                        }
                        case ALREADY_CHECKING: {
                            ASNCheck.this.complete(KickType.ALREADY_CHECKING, "The address is already being verified for asn");
                            break;
                        }
                        case ERROR: {
                            ASNCheck.this.complete(KickType.CHECKING_ERROR, "Error while checking for asn");
                            break;
                        }
                        default: {
                            ASNCheck.this.complete();
                        }
                    }
                });
            }
        });
    }
}

