/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.virtual.checks;

import net.md_5.bungee.BungeeCord;
import net.shieldcommunity.nullcordx.antibot.attributeslimiter.AntiBotAttributesLimiter;
import net.shieldcommunity.nullcordx.antibot.attributeslimiter.AttributeLookupResponse;
import net.shieldcommunity.nullcordx.antibot.attributeslimiter.AttributeResponse;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.AbstractBoundingChecking;
import net.shieldcommunity.nullcordx.api.KickType;
import net.shieldcommunity.nullcordx.api.NullCordX;
import net.shieldcommunity.nullcordx.api.checking.CheckingFactory;
import net.shieldcommunity.nullcordx.api.checking.CheckingUser;
import net.shieldcommunity.nullcordx.api.utils.location.AxisAlignedBounding;
import net.shieldcommunity.nullcordx.config.AntibotSettings;

public class AttributesCheck
extends AbstractBoundingChecking {
    private final AntiBotAttributesLimiter antiBotAttributesLimiter = BungeeCord.getInstance().getNullCordX().getAntiBotAttributesLimiter();

    public AttributesCheck(CheckingFactory checkingFactory, CheckingUser connector, NullCordX nullCordX, AxisAlignedBounding region) {
        super(checkingFactory, connector, nullCordX, region);
    }

    @Override
    public String getName() {
        return "Attributes";
    }

    @Override
    public void onAdded(boolean flush) {
        this.connector.disableFalling();
        this.connector.sendCachedPacket(this.nullCordX.getCachedPacketManager().getCachedSynchronizePlayerPosition());
        this.connector.awaitTeleportConfirm();
        this.connector.getChannel().getHandle().eventLoop().execute(() -> {
            if (this.connector.isDisconnected()) {
                return;
            }
            this.startLookup();
        });
    }

    @Override
    public void onRemoved() {
    }

    @Override
    public void onScheduledTask() {
        this.connector.sendCachedPacketWithDelay(this.nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(this.connector.getLanguageType()).getCachedMessageCountryChecking(), AntibotSettings.IMP.ANTIBOT.DIMENSION.MESSAGES.CHECKING_MESSAGES_DELAY);
    }

    private void startLookup() {
        this.antiBotAttributesLimiter.submitLookup(this.connector.getName(), this.connector.getBrand(), new AttributeLookupResponse(){

            @Override
            public boolean canExecute() {
                return !AttributesCheck.this.connector.isDisconnected();
            }

            @Override
            public void onExecute(AttributeResponse attributeResponse) {
                if (AttributesCheck.this.connector.isDisconnected()) {
                    return;
                }
                AttributesCheck.this.connector.getChannel().getHandle().eventLoop().execute(() -> {
                    if (AttributesCheck.this.connector.isDisconnected()) {
                        return;
                    }
                    if (AttributesCheck.this.nullCordX.canSendDebugLog()) {
                        AttributesCheck.this.nullCordX.sendDebugLog("Attributes check result for name '" + AttributesCheck.this.connector.getName() + "': " + attributeResponse);
                    }
                    if (attributeResponse.isNicknameDetected()) {
                        AttributesCheck.this.complete(KickType.BLACKLISTED_USERNAME, "Blacklisted username detected");
                        return;
                    }
                    if (attributeResponse.isBrandDetected()) {
                        AttributesCheck.this.complete(KickType.BLACKLISTED_BRAND, "Blacklisted brand detected");
                        return;
                    }
                    AttributesCheck.this.complete();
                });
            }
        });
    }
}

