/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.virtual.checks;

import java.net.InetAddress;
import net.md_5.bungee.BungeeCord;
import net.shieldcommunity.nullcordx.antibot.maxmind.AntiCountryManagerImpl;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.AbstractBoundingChecking;
import net.shieldcommunity.nullcordx.api.KickType;
import net.shieldcommunity.nullcordx.api.NullCordX;
import net.shieldcommunity.nullcordx.api.antibot.ExecutorCallback;
import net.shieldcommunity.nullcordx.api.antibot.maxmind.CachedDataChecker;
import net.shieldcommunity.nullcordx.api.antibot.maxmind.MaxMindResult;
import net.shieldcommunity.nullcordx.api.antibot.maxmind.countrylimiter.CountryResultData;
import net.shieldcommunity.nullcordx.api.checking.CheckingFactory;
import net.shieldcommunity.nullcordx.api.checking.CheckingUser;
import net.shieldcommunity.nullcordx.api.utils.location.AxisAlignedBounding;
import net.shieldcommunity.nullcordx.config.AntibotSettings;

public class CountryCheck
extends AbstractBoundingChecking {
    private final AntiCountryManagerImpl antiCountryManager = BungeeCord.getInstance().getNullCordX().getAntiCountryManager();

    public CountryCheck(CheckingFactory checkingFactory, CheckingUser connector, NullCordX nullCordX, AxisAlignedBounding axisAlignedBounding) {
        super(checkingFactory, connector, nullCordX, axisAlignedBounding);
    }

    @Override
    public String getName() {
        return "Country";
    }

    @Override
    public void onAdded(boolean flush) {
        this.connector.disableFalling();
        this.connector.sendCachedPacket(this.nullCordX.getCachedPacketManager().getCachedSynchronizePlayerPosition());
        this.connector.awaitTeleportConfirm();
        this.startCheck();
    }

    @Override
    public void onRemoved() {
    }

    @Override
    public void onScheduledTask() {
        this.connector.sendCachedPacketWithDelay(this.nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(this.connector.getLanguageType()).getCachedMessageCountryChecking(), AntibotSettings.IMP.ANTIBOT.DIMENSION.MESSAGES.CHECKING_MESSAGES_DELAY);
    }

    public void startCheck() {
        this.connector.getChannel().getHandle().eventLoop().execute(() -> {
            if (this.connector.isDisconnected()) {
                return;
            }
            this.startLookup();
        });
    }

    private void startLookup() {
        final InetAddress address = this.connector.getInetAddress();
        CachedDataChecker cachedCountryChecker = this.antiCountryManager.getCheckerByAddress(address);
        if (cachedCountryChecker != null) {
            MaxMindResult result;
            CountryResultData countryResultData = (CountryResultData)cachedCountryChecker.getCachedResult();
            if (this.nullCordX.canSendDebugLog()) {
                this.nullCordX.sendDebugLog("Country cached check result for address '" + address.getHostAddress() + "': " + countryResultData);
            }
            if (!(result = countryResultData.getResult()).isCheckAgainIfCached()) {
                String countryISO = countryResultData.getCountryISO();
                if (countryISO != null && this.antiCountryManager.isBlacklistedCountryISO(countryISO)) {
                    this.complete(KickType.COUNTRY, "Blacklisted country");
                } else {
                    this.complete();
                }
                return;
            }
        }
        this.antiCountryManager.submitLookup(address, new ExecutorCallback<CachedDataChecker<CountryResultData>>(){

            @Override
            public boolean canExecute() {
                return !CountryCheck.this.connector.isDisconnected();
            }

            @Override
            public void onExecute(CachedDataChecker<CountryResultData> cachedCountryChecker) {
                if (CountryCheck.this.connector.isDisconnected()) {
                    return;
                }
                CountryCheck.this.connector.getChannel().getHandle().eventLoop().execute(() -> {
                    if (CountryCheck.this.connector.isDisconnected()) {
                        return;
                    }
                    CountryResultData cachedResult = (CountryResultData)cachedCountryChecker.getCachedResult();
                    if (CountryCheck.this.nullCordX.canSendDebugLog()) {
                        CountryCheck.this.nullCordX.sendDebugLog("Country check result for address '" + address.getHostAddress() + "': " + cachedResult);
                    }
                    MaxMindResult result = cachedResult.getResult();
                    switch (result) {
                        case SUCCESSFULLY: {
                            String countryISO = cachedResult.getCountryISO();
                            if (countryISO != null && CountryCheck.this.antiCountryManager.isBlacklistedCountryISO(countryISO)) {
                                CountryCheck.this.complete(KickType.COUNTRY, "Blacklisted country");
                                break;
                            }
                            CountryCheck.this.complete();
                            break;
                        }
                        case ALREADY_CHECKING: {
                            CountryCheck.this.complete(KickType.ALREADY_CHECKING, "The address is already being verified for country");
                            break;
                        }
                        case ERROR: {
                            CountryCheck.this.complete(KickType.CHECKING_ERROR, "Error while checking for country");
                            break;
                        }
                        default: {
                            CountryCheck.this.complete();
                        }
                    }
                });
            }
        });
    }
}

