/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.virtual.checks;

import java.util.Collection;
import java.util.Map;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.FramedCaptchaCheck;
import net.shieldcommunity.nullcordx.api.KickType;
import net.shieldcommunity.nullcordx.api.NullCordX;
import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;
import net.shieldcommunity.nullcordx.api.cache.CaptchaHolder;
import net.shieldcommunity.nullcordx.api.cache.cachedframes.CachedFramesFramedPuzzle;
import net.shieldcommunity.nullcordx.api.checking.CheckingFactory;
import net.shieldcommunity.nullcordx.api.checking.CheckingUser;
import net.shieldcommunity.nullcordx.api.utils.location.AxisAlignedBounding;
import net.shieldcommunity.nullcordx.cache.CachedArrayPackets;
import net.shieldcommunity.nullcordx.cache.CachedMessagesByLanguage;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.protocol.ProtocolItemFrameRotationType;
import net.shieldcommunity.nullcordx.protocol.packets.EntityInteractPacket;

public class FramedPuzzleCheck
extends FramedCaptchaCheck {
    private final boolean completeOnlyOnChat;
    private final boolean expectCode;
    protected CachedFramesFramedPuzzle<? extends ByteBufPacket> currentFrames = null;

    public FramedPuzzleCheck(CheckingFactory checkingFactory, CheckingUser connector, NullCordX nullCordX, AxisAlignedBounding axisAlignedBounding, int maxAttempts, int maxSolves, boolean newCaptchaOnFail, String answerPrefix, boolean completeOnlyOnChat, boolean expectCode, CachedMessagesByLanguage<CachedArrayPackets> messagesAttemptsByLanguage) {
        super(checkingFactory, connector, nullCordX, axisAlignedBounding, maxAttempts, maxSolves, newCaptchaOnFail, answerPrefix, messagesAttemptsByLanguage);
        this.completeOnlyOnChat = completeOnlyOnChat;
        this.expectCode = expectCode;
    }

    @Override
    public String getName() {
        return "FramedPuzzle";
    }

    @Override
    public void onAdded(boolean flush) {
        this.connector.disableFalling();
        this.connector.sendCachedPacket(this.nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(this.connector.getLanguageType()).getCachedMessageCheckingFramedPuzzle());
        this.sendCaptcha(flush);
    }

    @Override
    public void onScheduledTask() {
        this.connector.sendCachedPacketWithDelay(this.nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(this.connector.getLanguageType()).getCachedMessageCheckingFramedPuzzle(), AntibotSettings.IMP.ANTIBOT.DIMENSION.MESSAGES.CHECKING_MESSAGES_DELAY);
    }

    @Override
    public void sendCaptcha(boolean flush) {
        CaptchaHolder<? extends CachedFramesFramedPuzzle<? extends ByteBufPacket>> holder;
        if (this.entityFrameData != null) {
            if (this.connector.getProtocolVersion() == 755) {
                this.connector.sendCachedPackets(this.entityFrameData.getCachedRemoveItemFramesLegacy());
            } else {
                this.connector.sendCachedPacket(this.entityFrameData.getCachedRemoveItemFrames());
            }
        }
        if ((holder = this.nullCordX.getCachedCaptchaManager().getCachedFramedPuzzlePackets().randomCaptcha()) == null) {
            this.complete(KickType.FAILED_CAPTCHA, this.getName() + " was not generated");
            return;
        }
        this.captchaAnswerGenerator = holder.getAnswer();
        CachedFramesFramedPuzzle<? extends ByteBufPacket> cachedFrames = holder.getCaptcha();
        this.entityFrameData = cachedFrames.getEntityFrameData();
        this.resetFrameRotations(this.entityFrameData);
        this.spawnEntityFrames();
        Collection<ByteBufPacket> metas = this.entityFrameData.getFrameMetaByRotation(ProtocolItemFrameRotationType.UP).values();
        for (ByteBufPacket meta : metas) {
            this.connector.sendCachedPacket(meta);
        }
        this.currentFrames = cachedFrames;
        for (ByteBufPacket packet : cachedFrames.getFrames()) {
            this.connector.sendCachedPacket(packet);
        }
        this.teleportToCaptcha();
        if (flush) {
            this.connector.getChannel().getHandle().flush();
        }
    }

    @Override
    public void handle(EntityInteractPacket entityInteractPacket) throws Exception {
        super.handle(entityInteractPacket);
        if (!this.completeOnlyOnChat && this.canCompletePuzzle()) {
            this.onCaptchaComplete(true);
        }
    }

    @Override
    public void onMessageReceived(String message) {
        if (this.completeOnlyOnChat) {
            if (this.expectCode) {
                super.onMessageReceived(message);
                return;
            }
            this.onCaptchaComplete(this.canCompletePuzzle());
        }
    }

    @Override
    public Boolean isCorrectMessage(String message) {
        if (!this.canCompletePuzzle()) {
            return false;
        }
        return super.isCorrectMessage(message);
    }

    public boolean canCompletePuzzle() {
        for (Map.Entry entry : this.currentFrames.getAllRotations()) {
            FramedCaptchaCheck.FrameRotation frameRotation = (FramedCaptchaCheck.FrameRotation)this.rotatedFramesByMapId.get((Integer)entry.getKey());
            if (frameRotation.getRotation() == entry.getValue()) continue;
            return false;
        }
        return true;
    }
}

