/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.virtual.checks;

import java.net.InetAddress;
import net.md_5.bungee.BungeeCord;
import net.shieldcommunity.nullcordx.antibot.antiproxy.AntiProxyManagerImpl;
import net.shieldcommunity.nullcordx.antibot.antiproxy.CachedProxyCheckerImpl;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.AbstractBoundingChecking;
import net.shieldcommunity.nullcordx.api.KickType;
import net.shieldcommunity.nullcordx.api.NullCordX;
import net.shieldcommunity.nullcordx.api.antibot.ExecutorCallback;
import net.shieldcommunity.nullcordx.api.antibot.antiproxy.CachedProxyChecker;
import net.shieldcommunity.nullcordx.api.antibot.antiproxy.ProxyResult;
import net.shieldcommunity.nullcordx.api.checking.CheckingFactory;
import net.shieldcommunity.nullcordx.api.checking.CheckingUser;
import net.shieldcommunity.nullcordx.api.utils.location.AxisAlignedBounding;
import net.shieldcommunity.nullcordx.config.AntibotSettings;

public class ProxyCheck
extends AbstractBoundingChecking {
    private final AntiProxyManagerImpl antiProxyManager = BungeeCord.getInstance().getNullCordX().getAntiProxyManager();

    public ProxyCheck(CheckingFactory checkingFactory, CheckingUser connector, NullCordX nullCordX, AxisAlignedBounding axisAlignedBounding) {
        super(checkingFactory, connector, nullCordX, axisAlignedBounding);
    }

    @Override
    public String getName() {
        return "Proxy";
    }

    @Override
    public void onAdded(boolean flush) {
        this.connector.disableFalling();
        this.connector.sendCachedPacket(this.nullCordX.getCachedPacketManager().getCachedSynchronizePlayerPosition());
        this.connector.awaitTeleportConfirm();
        this.startCheck();
    }

    @Override
    public void onRemoved() {
    }

    @Override
    public void onScheduledTask() {
        this.connector.sendCachedPacketWithDelay(this.nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(this.connector.getLanguageType()).getCachedMessageProxyChecking(), AntibotSettings.IMP.ANTIBOT.DIMENSION.MESSAGES.CHECKING_MESSAGES_DELAY);
    }

    public void startCheck() {
        this.connector.getChannel().getHandle().eventLoop().execute(() -> {
            if (this.connector.isDisconnected()) {
                return;
            }
            this.startLookup();
        });
    }

    private void startLookup() {
        final InetAddress address = this.connector.getInetAddress();
        CachedProxyCheckerImpl cachedProxyChecker = this.antiProxyManager.getCheckerByAddress(address);
        if (cachedProxyChecker != null) {
            ProxyResult result = cachedProxyChecker.getCachedResult();
            if (this.nullCordX.canSendDebugLog()) {
                this.nullCordX.sendDebugLog("Proxy cached check result for address '" + address.getHostAddress() + "': " + result);
            }
            if (!result.isCheckAgainIfCached()) {
                if (result.isAllowed()) {
                    this.complete();
                } else {
                    this.complete(KickType.PROXY, "Proxy detected");
                }
                return;
            }
        }
        this.antiProxyManager.submitLookup(address, new ExecutorCallback<CachedProxyChecker>(){

            @Override
            public boolean canExecute() {
                return !ProxyCheck.this.connector.isDisconnected();
            }

            @Override
            public void onExecute(CachedProxyChecker cachedProxyChecker) {
                if (ProxyCheck.this.connector.isDisconnected()) {
                    return;
                }
                ProxyCheck.this.connector.getChannel().getHandle().eventLoop().execute(() -> {
                    if (ProxyCheck.this.connector.isDisconnected()) {
                        return;
                    }
                    ProxyResult result = cachedProxyChecker.getCachedResult();
                    if (ProxyCheck.this.nullCordX.canSendDebugLog()) {
                        ProxyCheck.this.nullCordX.sendDebugLog("Proxy check result for address '" + address.getHostAddress() + "': " + result);
                    }
                    switch (result) {
                        case DETECTED: {
                            ProxyCheck.this.complete(KickType.PROXY, "Proxy detected");
                            break;
                        }
                        case ALREADY_CHECKING: {
                            ProxyCheck.this.complete(KickType.ALREADY_CHECKING, "The address is already being verified for proxy");
                            break;
                        }
                        case ERROR: {
                            ProxyCheck.this.complete(KickType.CHECKING_ERROR, "Error while checking for proxy");
                            break;
                        }
                        default: {
                            ProxyCheck.this.complete();
                        }
                    }
                });
            }
        });
    }
}

