/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.virtual.ping;

public class AveragePingData {
    private long totalPing = 0L;
    private int receivedCount = 0;

    public void addPing(long ping) {
        this.totalPing += ping;
        ++this.receivedCount;
    }

    public long calculateAveragePing() {
        if (this.totalPing <= 0L || this.receivedCount <= 0) {
            return 0L;
        }
        return this.totalPing / (long)this.receivedCount;
    }

    public void reset() {
        this.totalPing = 0L;
        this.receivedCount = 0;
    }

    public String toString() {
        return "AveragePingData{totalPing=" + this.totalPing + ", receivedCount=" + this.receivedCount + ", average=" + this.calculateAveragePing() + "}";
    }

    public long getTotalPing() {
        return this.totalPing;
    }

    public int getReceivedCount() {
        return this.receivedCount;
    }

    public void setTotalPing(long totalPing) {
        this.totalPing = totalPing;
    }

    public void setReceivedCount(int receivedCount) {
        this.receivedCount = receivedCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AveragePingData)) {
            return false;
        }
        AveragePingData other = (AveragePingData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalPing() != other.getTotalPing()) {
            return false;
        }
        return this.getReceivedCount() == other.getReceivedCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AveragePingData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $totalPing = this.getTotalPing();
        result = result * 59 + (int)($totalPing >>> 32 ^ $totalPing);
        result = result * 59 + this.getReceivedCount();
        return result;
    }
}

