/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.api.utils.location;

import net.shieldcommunity.nullcordx.api.utils.location.AxisAlignedBounding;
import net.shieldcommunity.nullcordx.api.utils.location.Vector3D;

public final class AxisAlignedBoundingBox
implements AxisAlignedBounding {
    private final Vector3D first;
    private final Vector3D second;

    public AxisAlignedBoundingBox(Vector3D first, Vector3D second) {
        double xMin = Math.min(first.getX(), second.getX());
        double yMin = Math.min(first.getY(), second.getY());
        double zMin = Math.min(first.getZ(), second.getZ());
        this.first = new Vector3D(xMin, yMin, zMin);
        double xMax = Math.max(first.getX(), second.getX());
        double yMax = Math.max(first.getY(), second.getY());
        double zMax = Math.max(first.getZ(), second.getZ());
        this.second = new Vector3D(xMax, yMax, zMax);
    }

    @Override
    public boolean isInside(double xLocIn, double yLocIn, double zLocIn) {
        return xLocIn >= this.first.getX() && xLocIn <= this.second.getX() && yLocIn >= this.first.getY() && yLocIn <= this.second.getY() && zLocIn >= this.first.getZ() && zLocIn <= this.second.getZ();
    }

    public static AxisAlignedBoundingBox createFromLocationAndSize(Vector3D position, int xSize, int ySize, int zSize) {
        Vector3D first = Vector3D.of(position.getX() + (double)xSize, position.getY() + (double)ySize, position.getZ() + (double)zSize);
        Vector3D second = Vector3D.of(position.getX() - (double)xSize, position.getY() - (double)ySize, position.getZ() - (double)zSize);
        return new AxisAlignedBoundingBox(first, second);
    }

    public Vector3D getFirst() {
        return this.first;
    }

    public Vector3D getSecond() {
        return this.second;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AxisAlignedBoundingBox)) {
            return false;
        }
        AxisAlignedBoundingBox other = (AxisAlignedBoundingBox)o;
        Vector3D this$first = this.getFirst();
        Vector3D other$first = other.getFirst();
        if (this$first == null ? other$first != null : !((Object)this$first).equals(other$first)) {
            return false;
        }
        Vector3D this$second = this.getSecond();
        Vector3D other$second = other.getSecond();
        return !(this$second == null ? other$second != null : !((Object)this$second).equals(other$second));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Vector3D $first = this.getFirst();
        result = result * 59 + ($first == null ? 43 : ((Object)$first).hashCode());
        Vector3D $second = this.getSecond();
        result = result * 59 + ($second == null ? 43 : ((Object)$second).hashCode());
        return result;
    }

    public String toString() {
        return "AxisAlignedBoundingBox(first=" + this.getFirst() + ", second=" + this.getSecond() + ")";
    }
}

