/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.blacklist;

import java.net.InetAddress;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.blacklist.BlacklistHandler;
import net.shieldcommunity.nullcordx.config.ConfigSettings;
import net.shieldcommunity.nullcordx.libs.benmanes.caffeine.cache.Caffeine;
import net.shieldcommunity.nullcordx.libs.benmanes.caffeine.cache.LoadingCache;

public class BlacklistDefault
implements BlacklistHandler {
    private LoadingCache<InetAddress, InetAddress> cache = null;

    @Override
    public void load() {
        if (this.cache != null) {
            return;
        }
        this.cache = Caffeine.newBuilder().executor(NullCordXImpl.GLOBAL_CACHE_EXECUTOR).scheduler(NullCordXImpl.GLOBAL_CACHE_SCHEDULER).initialCapacity(1000).expireAfterWrite(ConfigSettings.IMP.PROTECTION.BLACKLIST.MAX_TIME, TimeUnit.SECONDS).build(key -> key);
    }

    @Override
    public void unload() {
        if (this.cache == null) {
            return;
        }
        this.cache.invalidateAll();
        this.cache = null;
    }

    @Override
    public void blackList(InetAddress address) {
        if (this.cache == null) {
            return;
        }
        this.cache.get(address);
    }

    @Override
    public void unBlacklist(InetAddress address) {
        if (this.cache == null) {
            return;
        }
        this.cache.invalidate(address);
    }

    @Override
    public void invalidateAll() {
        if (this.cache == null) {
            return;
        }
        this.cache.invalidateAll();
    }

    @Override
    public boolean isBlacklisted(InetAddress address) {
        if (this.cache == null) {
            return false;
        }
        return this.cache.getIfPresent(address) != null;
    }

    @Override
    public Set<InetAddress> getAllInetAddress() {
        if (this.cache == null) {
            return new HashSet<InetAddress>();
        }
        return this.cache.asMap().keySet();
    }
}

