/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.blacklist;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.shieldcommunity.nullcordx.blacklist.BlacklistHandler;
import net.shieldcommunity.nullcordx.blacklist.BlacklistManager;
import net.shieldcommunity.nullcordx.config.ConfigSettings;

public class BlacklistExternal
implements BlacklistHandler {
    private final Logger logger;
    private final BlacklistManager blacklistManager;
    private ExecutorService executor = null;

    @Override
    public void load() {
        if (this.executor != null) {
            return;
        }
        int threads = ConfigSettings.IMP.PROTECTION.BLACKLIST.EXTERNAL.THREAD_POOL_SIZE;
        if (threads <= 0) {
            threads = 1;
        }
        this.executor = Executors.newFixedThreadPool(threads, new ThreadFactoryBuilder().setNameFormat("NullCordX-BlackListExternal-thread-%d").build());
        for (String command : ConfigSettings.IMP.PROTECTION.BLACKLIST.EXTERNAL.ON_LOAD_EXECUTE) {
            String replaced = command.replace("%max_time%", String.valueOf(ConfigSettings.IMP.PROTECTION.BLACKLIST.MAX_TIME));
            String[] args = replaced.split(" ");
            this.blacklistManager.executeCommandSafe(args);
        }
    }

    @Override
    public void unload() {
        if (this.executor == null) {
            return;
        }
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.log(Level.SEVERE, "Error during shutdown executor", e);
        }
        this.executor = null;
    }

    @Override
    public void blackList(InetAddress address) {
        if (this.executor == null) {
            return;
        }
        this.executor.execute(() -> {
            for (String command : ConfigSettings.IMP.PROTECTION.BLACKLIST.EXTERNAL.ON_BLACKLIST_EXECUTE) {
                String replaced = command.replace("%address%", address.getHostAddress());
                String[] args = replaced.split(" ");
                this.blacklistManager.executeCommandSafe(args);
            }
        });
    }

    @Override
    public void unBlacklist(InetAddress address) {
        if (this.executor == null) {
            return;
        }
        this.executor.execute(() -> {
            for (String command : ConfigSettings.IMP.PROTECTION.BLACKLIST.EXTERNAL.ON_UNBLACKLIST_EXECUTE) {
                String replaced = command.replace("%address%", address.getHostAddress());
                String[] args = replaced.split(" ");
                this.blacklistManager.executeCommandSafe(args);
            }
        });
    }

    @Override
    public void invalidateAll() {
        if (this.executor == null) {
            return;
        }
        this.executor.execute(() -> {
            for (String command : ConfigSettings.IMP.PROTECTION.BLACKLIST.EXTERNAL.ON_UNBLACKLIST_ALL_EXECUTE) {
                String[] args = command.split(" ");
                this.blacklistManager.executeCommandSafe(args);
            }
        });
    }

    @Override
    public boolean isBlacklisted(InetAddress address) {
        return false;
    }

    @Override
    public Set<InetAddress> getAllInetAddress() {
        return new HashSet<InetAddress>();
    }

    public BlacklistExternal(Logger logger, BlacklistManager blacklistManager) {
        this.logger = logger;
        this.blacklistManager = blacklistManager;
    }
}

