/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.blacklist;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import net.shieldcommunity.nullcordx.ManagerComponent;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.NullCordXLogger;
import net.shieldcommunity.nullcordx.blacklist.BlacklistDefault;
import net.shieldcommunity.nullcordx.blacklist.BlacklistExternal;
import net.shieldcommunity.nullcordx.blacklist.BlacklistHandler;
import net.shieldcommunity.nullcordx.blacklist.ProxyBlacklistManager;
import net.shieldcommunity.nullcordx.config.ConfigSettings;
import net.shieldcommunity.nullcordx.libs.google.inject.Inject;
import net.shieldcommunity.nullcordx.libs.google.inject.Singleton;
import net.shieldcommunity.nullcordx.utils.InetAddressSet;

@Singleton
public class BlacklistManager
extends ManagerComponent {
    private final ProxyBlacklistManager proxyBlacklistManager;
    private BlacklistHandler blackList = null;
    private Set<Class<?>> blacklistedExceptions = new HashSet();
    private InetAddressSet noBlacklist = new InetAddressSet();

    @Inject
    public BlacklistManager(NullCordXLogger logger, NullCordXImpl nullCordX, ProxyBlacklistManager proxyBlacklistManager) {
        super(logger, nullCordX, "BlackListManager");
        this.proxyBlacklistManager = proxyBlacklistManager;
    }

    @Override
    protected void onLoad(ForkJoinPool executor) {
        if (!ConfigSettings.IMP.PROTECTION.BLACKLIST.ENABLED) {
            this.logger.log(Level.INFO, this.componentName + " disabled by configuration!");
            return;
        }
        this.noBlacklist = ConfigSettings.IMP.PROTECTION.BLACKLIST.NO_BLACKLIST.calculateAddresses(this.logger, "no blacklist addresses");
        this.blackList = ConfigSettings.IMP.PROTECTION.BLACKLIST.EXTERNAL.ENABLED ? new BlacklistExternal(this.logger, this) : new BlacklistDefault();
        this.blackList.load();
        this.proxyBlacklistManager.load(executor, this);
        HashSet blacklistedExceptions = new HashSet();
        for (String exceptionName : ConfigSettings.IMP.PROTECTION.ANTIEXPLOIT.INITIAL_HANDLER_EXCEPTION_BLACKLIST.EXCEPTION_LIST) {
            try {
                Class<?> exceptionClass = Class.forName(exceptionName);
                blacklistedExceptions.add(exceptionClass);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Could not find an exception '" + exceptionName + "'!");
            }
        }
        this.blacklistedExceptions = Collections.unmodifiableSet(blacklistedExceptions);
    }

    @Override
    protected void onUnload() {
        if (this.blackList != null) {
            this.blackList.unload();
        }
        if (this.proxyBlacklistManager.isLoaded()) {
            this.proxyBlacklistManager.unload();
        }
    }

    public void blackList(InetAddress address, String reason) {
        if (this.nullCordX.canSendDebugLog()) {
            this.nullCordX.sendDebugLog("Blacklist reason: '" + reason + "' for address " + address.getHostAddress() + " with seconds " + ConfigSettings.IMP.PROTECTION.BLACKLIST.MAX_TIME);
        }
        if (this.blackList == null) {
            return;
        }
        if (this.isNoBlacklisted(address)) {
            return;
        }
        this.blackList.blackList(address);
        if (this.nullCordX.canSendAntibotLog()) {
            this.nullCordX.sendAntibotLog("Blacklisted " + address.getHostAddress() + " for " + ConfigSettings.IMP.PROTECTION.BLACKLIST.MAX_TIME + " seconds. Reason: '" + reason + "'");
        }
    }

    public boolean isNoBlacklisted(InetAddress address) {
        if (this.noBlacklist == null) {
            return false;
        }
        return this.noBlacklist.contains(address);
    }

    public void unBlacklist(InetAddress address) {
        if (this.blackList == null) {
            return;
        }
        this.blackList.unBlacklist(address);
    }

    public void invalidateAll() {
        if (this.blackList == null) {
            return;
        }
        this.blackList.invalidateAll();
    }

    public boolean isBlacklisted(InetAddress address) {
        if (this.blackList == null) {
            return false;
        }
        return this.blackList.isBlacklisted(address);
    }

    public Set<InetAddress> getAllInetAddress() {
        if (this.blackList == null) {
            return new HashSet<InetAddress>();
        }
        return this.blackList.getAllInetAddress();
    }

    public boolean isBlacklistedException(Class<?> clazz) {
        if (!ConfigSettings.IMP.PROTECTION.ANTIEXPLOIT.INITIAL_HANDLER_EXCEPTION_BLACKLIST.WHITELIST) {
            return this.blacklistedExceptions.contains(clazz);
        }
        return !this.blacklistedExceptions.contains(clazz);
    }

    public void executeCommandSafe(String ... commands) {
        block3: {
            try {
                if (this.nullCordX.canSendDebugLog()) {
                    this.nullCordX.sendDebugLog("Executing command '" + Arrays.toString(commands) + "'");
                }
                new ProcessBuilder(commands).start();
            }
            catch (Exception exception) {
                if (!this.nullCordX.canSendDebugLog()) break block3;
                this.nullCordX.sendDebugLog("Error when executing command '" + Arrays.toString(commands) + "': " + exception.getMessage());
            }
        }
    }

    public ProxyBlacklistManager getProxyBlacklistManager() {
        return this.proxyBlacklistManager;
    }

    public BlacklistHandler getBlackList() {
        return this.blackList;
    }
}

