/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.cache;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.shieldcommunity.nullcordx.LocalScheduler;
import net.shieldcommunity.nullcordx.ManagerComponent;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.NullCordXLogger;
import net.shieldcommunity.nullcordx.antibot.CheckingFactoriesImpl;
import net.shieldcommunity.nullcordx.antibot.captcha.AnimatedFramesEntityMetaListData;
import net.shieldcommunity.nullcordx.antibot.captcha.BufferedGif;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.CaptchaDataSettings;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.CacheCleanupUtils;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.filecache.CombinedCaptchaFileCacheType;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.resizer.ResizedGif;
import net.shieldcommunity.nullcordx.antibot.virtual.VirtualConnector;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.AnimatedCaptchaCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.AnimatedFramedCaptchaCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.AnimatedFramedPuzzleCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.AnimatedHandCaptchaCheck;
import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;
import net.shieldcommunity.nullcordx.api.cache.CachedCaptchaManager;
import net.shieldcommunity.nullcordx.api.checking.AbstractChecking;
import net.shieldcommunity.nullcordx.api.utils.location.DirectionType;
import net.shieldcommunity.nullcordx.cache.CachedCaptchaPacketsImpl;
import net.shieldcommunity.nullcordx.cache.CachedEntityFrameDataImpl;
import net.shieldcommunity.nullcordx.cache.CachedItemFrameRotationDataImpl;
import net.shieldcommunity.nullcordx.cache.CachedMapDataPacket;
import net.shieldcommunity.nullcordx.cache.CachedPacket;
import net.shieldcommunity.nullcordx.cache.CachedSpawnEntityItemFramePacketImpl;
import net.shieldcommunity.nullcordx.cache.CaptchaHolderImpl;
import net.shieldcommunity.nullcordx.cache.PerRaCStorage;
import net.shieldcommunity.nullcordx.cache.cachedframes.CachedFramesAnimatedFramedCaptchaImpl;
import net.shieldcommunity.nullcordx.cache.cachedframes.CachedFramesAnimatedFramedPuzzleImpl;
import net.shieldcommunity.nullcordx.cache.cachedframes.CachedFramesFramedCaptchaImpl;
import net.shieldcommunity.nullcordx.cache.cachedframes.CachedFramesFramedPuzzleImpl;
import net.shieldcommunity.nullcordx.cache.cachedframes.CachedFramesImpl;
import net.shieldcommunity.nullcordx.cache.cachedframes.CachedFramesPickCaptchaImpl;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.config.CaptchaSettings;
import net.shieldcommunity.nullcordx.config.ConfigSettings;
import net.shieldcommunity.nullcordx.config.bungee.BungeeCordSettings;
import net.shieldcommunity.nullcordx.config.captcha.AnimatedFramedCaptchaSettings;
import net.shieldcommunity.nullcordx.config.captcha.AnimatedFramedPuzzleSettings;
import net.shieldcommunity.nullcordx.config.captcha.AnimatedHandCaptchaSettings;
import net.shieldcommunity.nullcordx.config.captcha.FramedCaptchaSettings;
import net.shieldcommunity.nullcordx.config.captcha.FramedPuzzleSettings;
import net.shieldcommunity.nullcordx.config.captcha.HandCaptchaSettings;
import net.shieldcommunity.nullcordx.config.captcha.PickCaptchaSettings;
import net.shieldcommunity.nullcordx.libs.google.inject.Inject;
import net.shieldcommunity.nullcordx.libs.google.inject.Singleton;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.shieldcommunity.nullcordx.protocol.EntityMetadata;
import net.shieldcommunity.nullcordx.protocol.EntityMetadataFieldType;
import net.shieldcommunity.nullcordx.protocol.EntityMetadataIndexType;
import net.shieldcommunity.nullcordx.protocol.ProtocolEntityType;
import net.shieldcommunity.nullcordx.protocol.ProtocolItemFrameRotationType;
import net.shieldcommunity.nullcordx.protocol.ProtocolItemType;
import net.shieldcommunity.nullcordx.protocol.ProtocolSpawnEntityFrameRotation;
import net.shieldcommunity.nullcordx.protocol.RotationData;
import net.shieldcommunity.nullcordx.protocol.SlotData;
import net.shieldcommunity.nullcordx.protocol.packets.RemoveEntitiesPacket;
import net.shieldcommunity.nullcordx.protocol.packets.SetEntityMetadataPacket;
import net.shieldcommunity.nullcordx.protocol.packets.SpawnEntityPacket;
import net.shieldcommunity.nullcordx.tasks.SafeScheduledTask;

@Singleton
public class CachedCaptchaManagerImpl
extends ManagerComponent
implements CachedCaptchaManager {
    public static final int CAPTCHA_CACHE_VERSION = 4;
    private final LocalScheduler localScheduler;
    private final CachedCaptchaPacketsImpl<CachedMapDataPacket> cachedHandCaptchaPackets = new CachedCaptchaPacketsImpl("HandCaptcha");
    private final CachedCaptchaPacketsImpl<CachedFramesImpl<CachedMapDataPacket>> cachedAnimatedHandCaptchaPackets = new CachedCaptchaPacketsImpl("AnimatedHandCaptcha");
    private final CachedCaptchaPacketsImpl<CachedFramesFramedCaptchaImpl<CachedMapDataPacket>> cachedFramedCaptchaPackets = new CachedCaptchaPacketsImpl("FramedCaptcha");
    private final CachedCaptchaPacketsImpl<CachedFramesAnimatedFramedCaptchaImpl<CachedFramesAnimatedFramedCaptchaImpl<CachedMapDataPacket>>> cachedAnimatedFramedCaptchaPackets = new CachedCaptchaPacketsImpl("AnimatedFramedCaptcha");
    private final CachedCaptchaPacketsImpl<CachedFramesFramedPuzzleImpl<CachedMapDataPacket>> cachedFramedPuzzlePackets = new CachedCaptchaPacketsImpl("FramedPuzzle");
    private final CachedCaptchaPacketsImpl<CachedFramesAnimatedFramedPuzzleImpl<CachedFramesAnimatedFramedPuzzleImpl<CachedMapDataPacket>>> cachedAnimatedFramedPuzzlePackets = new CachedCaptchaPacketsImpl("AnimatedFramedPuzzle");
    private final CachedCaptchaPacketsImpl<CachedFramesPickCaptchaImpl<CachedMapDataPacket>> cachedPickCaptchaPackets = new CachedCaptchaPacketsImpl("PickCaptcha");
    private PerRaCStorage<CachedEntityFrameDataImpl> cachedEntityFrameData;
    private ScheduledExecutorService animatedCaptchaTimer = null;
    private PerRaCStorage<AnimatedFramesEntityMetaListData> animatedFramesEntityMetaData = null;
    private String handCaptchaSettingsHash = "none";
    private String animatedHandCaptchaSettingsHash = "none";
    private String framedCaptchaSettingsHash = "none";
    private String animatedFramedCaptchaSettingsHash = "none";
    private String framedPuzzleSettingsHash = "none";
    private String animatedFramedPuzzleSettingsHash = "none";
    private String pickCaptchaSettingsHash = "none";
    public static final int ENTITY_ITEM_FRAME_ID_START = 250;

    @Inject
    public CachedCaptchaManagerImpl(NullCordXLogger logger, NullCordXImpl nullCordX, LocalScheduler localScheduler) {
        super(logger, nullCordX, "CachedCaptchaManager");
        this.localScheduler = localScheduler;
    }

    @Override
    protected void onLoad(ForkJoinPool executor) {
        this.loadFramedCaptcha(executor);
        this.initDirtyCaptchaCheckTask();
    }

    @Override
    protected void onUnload() {
        this.unloadAnimationDataForCaptcha();
        this.cachedHandCaptchaPackets.release();
        this.cachedAnimatedHandCaptchaPackets.release();
        this.cachedFramedCaptchaPackets.release();
        this.cachedAnimatedFramedCaptchaPackets.release();
        this.cachedFramedPuzzlePackets.release();
        this.cachedAnimatedFramedPuzzlePackets.release();
        this.cachedPickCaptchaPackets.release();
        for (CachedEntityFrameDataImpl entity : this.cachedEntityFrameData.getAllData()) {
            entity.release();
        }
    }

    private void initDirtyCaptchaCheckTask() {
        this.handCaptchaSettingsHash = CachedCaptchaManagerImpl.createCaptchaSettingsHash("hand_captcha", HandCaptchaSettings.IMP);
        this.animatedHandCaptchaSettingsHash = CachedCaptchaManagerImpl.createCaptchaSettingsHash("animated_hand_captcha", AnimatedHandCaptchaSettings.IMP);
        this.framedCaptchaSettingsHash = CachedCaptchaManagerImpl.createCaptchaSettingsHash("framed_captcha", FramedCaptchaSettings.IMP);
        this.animatedFramedCaptchaSettingsHash = CachedCaptchaManagerImpl.createCaptchaSettingsHash("animated_framed_captcha", AnimatedFramedCaptchaSettings.IMP);
        this.framedPuzzleSettingsHash = CachedCaptchaManagerImpl.createCaptchaSettingsHash("framed_puzzle", FramedPuzzleSettings.IMP);
        this.animatedFramedPuzzleSettingsHash = CachedCaptchaManagerImpl.createCaptchaSettingsHash("animated_framed_puzzle", AnimatedFramedPuzzleSettings.IMP);
        this.pickCaptchaSettingsHash = CachedCaptchaManagerImpl.createCaptchaSettingsHash("pick_captcha", PickCaptchaSettings.IMP);
        HashSet<String> hashes = new HashSet<String>();
        hashes.add(this.handCaptchaSettingsHash);
        hashes.add(this.animatedHandCaptchaSettingsHash);
        hashes.add(this.framedCaptchaSettingsHash);
        hashes.add(this.animatedFramedCaptchaSettingsHash);
        hashes.add(this.framedPuzzleSettingsHash);
        hashes.add(this.animatedFramedPuzzleSettingsHash);
        hashes.add(this.pickCaptchaSettingsHash);
        CacheCleanupUtils.doCleanup(this.logger, CaptchaDataSettings.GLOBAL_CAPTCHA_CACHE_DIRECTORY, hashes, (logger, count) -> logger.log(Level.INFO, "Deleted " + count + " outdated cached captcha files."));
        this.localScheduler.scheduleWithFixedDelay(new SafeScheduledTask(this.logger){

            @Override
            public void doTask() {
                CachedCaptchaManagerImpl.this.checkDirtyCaptcha(CachedCaptchaManagerImpl.this.cachedHandCaptchaPackets, new File(CaptchaDataSettings.GLOBAL_CAPTCHA_CACHE_DIRECTORY, CachedCaptchaManagerImpl.this.handCaptchaSettingsHash));
                CachedCaptchaManagerImpl.this.checkDirtyCaptcha(CachedCaptchaManagerImpl.this.cachedAnimatedHandCaptchaPackets, new File(CaptchaDataSettings.GLOBAL_CAPTCHA_CACHE_DIRECTORY, CachedCaptchaManagerImpl.this.animatedHandCaptchaSettingsHash));
                CachedCaptchaManagerImpl.this.checkDirtyCaptcha(CachedCaptchaManagerImpl.this.cachedFramedCaptchaPackets, new File(CaptchaDataSettings.GLOBAL_CAPTCHA_CACHE_DIRECTORY, CachedCaptchaManagerImpl.this.framedCaptchaSettingsHash));
                CachedCaptchaManagerImpl.this.checkDirtyCaptcha(CachedCaptchaManagerImpl.this.cachedAnimatedFramedCaptchaPackets, new File(CaptchaDataSettings.GLOBAL_CAPTCHA_CACHE_DIRECTORY, CachedCaptchaManagerImpl.this.animatedFramedCaptchaSettingsHash));
                CachedCaptchaManagerImpl.this.checkDirtyCaptcha(CachedCaptchaManagerImpl.this.cachedFramedPuzzlePackets, new File(CaptchaDataSettings.GLOBAL_CAPTCHA_CACHE_DIRECTORY, CachedCaptchaManagerImpl.this.framedPuzzleSettingsHash));
                CachedCaptchaManagerImpl.this.checkDirtyCaptcha(CachedCaptchaManagerImpl.this.cachedAnimatedFramedPuzzlePackets, new File(CaptchaDataSettings.GLOBAL_CAPTCHA_CACHE_DIRECTORY, CachedCaptchaManagerImpl.this.animatedFramedPuzzleSettingsHash));
                CachedCaptchaManagerImpl.this.checkDirtyCaptcha(CachedCaptchaManagerImpl.this.cachedPickCaptchaPackets, new File(CaptchaDataSettings.GLOBAL_CAPTCHA_CACHE_DIRECTORY, CachedCaptchaManagerImpl.this.pickCaptchaSettingsHash));
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    private <T extends ByteBufPacket> void checkDirtyCaptcha(CachedCaptchaPacketsImpl<T> cachedCaptchaPackets, File cacheDirectory) {
        CaptchaDataSettings captchaDataSettings = this.nullCordX.getCaptchaGenerator().getCaptchaDataSettings();
        if (captchaDataSettings == null) {
            return;
        }
        if (captchaDataSettings.getCaptchaFileCacheType() == CombinedCaptchaFileCacheType.NONE) {
            return;
        }
        CaptchaHolderImpl<T>[] holders = cachedCaptchaPackets.getCaptchas();
        if (holders == null) {
            return;
        }
        for (CaptchaHolderImpl<T> holder : holders) {
            File markDeletedFile;
            if (!holder.isActuallyDirty() || holder.isDeleted()) continue;
            File captchaNumberCache = new File(cacheDirectory, String.valueOf(holder.getNumber()));
            if (!captchaNumberCache.exists()) {
                captchaNumberCache.mkdirs();
            }
            if (!(markDeletedFile = new File(captchaNumberCache, "mark_deleted.tmp")).exists()) {
                try {
                    markDeletedFile.createNewFile();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            holder.setDeleted(true);
        }
    }

    private void loadFramedCaptcha(ForkJoinPool executor) {
        CheckingFactoriesImpl checkingFactories = this.nullCordX.getCaptchaGenerator().getCheckingFactories();
        PerRaCStorage<CachedEntityFrameDataImpl> cachedEntityFrameData = new PerRaCStorage<CachedEntityFrameDataImpl>(CachedEntityFrameDataImpl.class, checkingFactories.getMinFrameRow(), checkingFactories.getMaxFrameRow(), checkingFactories.getMinFrameColumn(), checkingFactories.getMaxFrameColumn());
        cachedEntityFrameData.loadNow(executor, (row, column) -> {
            AntibotSettings.ANTIBOT.DIMENSION.LOCATION location = AntibotSettings.IMP.ANTIBOT.DIMENSION.LOCATION;
            int centerX = (int)Math.round((double)Math.max(column, row) / AntibotSettings.IMP.ANTIBOT.DIMENSION.ITEM_FRAME.DISTANCE_MODIFIER);
            int centerY = (int)Math.round((double)column / 2.0) - 1;
            int centerZ = (int)Math.round((double)row / 2.0);
            int currentX = (int)(location.X - (double)centerX);
            int currentY = (int)(location.Y - (double)centerY);
            int currentZ = (int)(location.Z - (double)centerZ);
            ArrayList<CachedSpawnEntityItemFramePacketImpl> itemFrames = new ArrayList<CachedSpawnEntityItemFramePacketImpl>();
            EnumMap cachedMetaDataForFrames = new EnumMap(ProtocolItemFrameRotationType.class);
            for (ProtocolItemFrameRotationType rotation : ProtocolItemFrameRotationType.values()) {
                cachedMetaDataForFrames.put(rotation, new LinkedHashMap());
            }
            ArrayList<Integer> entityFramesList = new ArrayList<Integer>();
            Int2ObjectOpenHashMap<ByteBufPacket> cachedEmptyMetadata = new Int2ObjectOpenHashMap<ByteBufPacket>();
            int countEntityId = 250;
            int countMapId = 1;
            ProtocolSpawnEntityFrameRotation entityFrameRotation = ProtocolSpawnEntityFrameRotation.EAST;
            DirectionType directionType = DirectionType.EAST;
            for (int y = column; y > 0; --y) {
                for (int z = row; z > 0; --z) {
                    double localX = currentX;
                    double localY = currentY + y;
                    double localZ = currentZ + z;
                    itemFrames.add(new CachedSpawnEntityItemFramePacketImpl(CachedPacket.create(new SpawnEntityPacket(countEntityId, UUID.randomUUID(), ProtocolEntityType.ITEM_FRAME, localX, localY, localZ, 0.0f, entityFrameRotation.getDegrees(), entityFrameRotation.getDegrees(), entityFrameRotation, 0.0f, 0.0f, 0.0f), Protocol.FILTER), countEntityId, countMapId, localX, localY, localZ, directionType));
                    for (ProtocolItemFrameRotationType rotation : ProtocolItemFrameRotationType.values()) {
                        ArrayList<EntityMetadata> entityMetadata = new ArrayList<EntityMetadata>();
                        entityMetadata.add(new EntityMetadata(EntityMetadataIndexType.ITEM_FRAME_ITEM, EntityMetadataFieldType.SLOT, new SlotData(ProtocolItemType.FILLED_MAP, 1, countMapId)));
                        entityMetadata.add(new EntityMetadata(EntityMetadataIndexType.ITEM_FRAME_ROTATION, EntityMetadataFieldType.VAR_INT, new RotationData(rotation)));
                        ((Map)cachedMetaDataForFrames.get((Object)rotation)).put(countEntityId, CachedPacket.create(new SetEntityMetadataPacket(countEntityId, entityMetadata), Protocol.FILTER));
                    }
                    ArrayList<EntityMetadata> entityMetadata = new ArrayList<EntityMetadata>();
                    entityMetadata.add(new EntityMetadata(EntityMetadataIndexType.ITEM_FRAME_ITEM, EntityMetadataFieldType.SLOT, new SlotData(ProtocolItemType.AIR, 1, countMapId)));
                    cachedEmptyMetadata.put(countEntityId, (ByteBufPacket)CachedPacket.create(new SetEntityMetadataPacket(countEntityId, entityMetadata), Protocol.FILTER));
                    entityFramesList.add(countEntityId);
                    ++countEntityId;
                    ++countMapId;
                }
            }
            Collections.shuffle(itemFrames);
            Collections.shuffle(entityFramesList);
            CachedPacket removeEntitiesPacket = CachedPacket.create(new RemoveEntitiesPacket(entityFramesList), Protocol.FILTER);
            ArrayList<CachedPacket> removeEntitiesLegacyPacket = new ArrayList<CachedPacket>();
            Iterator iterator = entityFramesList.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                removeEntitiesLegacyPacket.add(CachedPacket.create(new RemoveEntitiesPacket(Collections.singletonList(id)), Protocol.FILTER));
            }
            Collections.shuffle(removeEntitiesLegacyPacket);
            return new CachedEntityFrameDataImpl(row, column, Collections.unmodifiableList(itemFrames), Collections.unmodifiableMap(cachedMetaDataForFrames), cachedEmptyMetadata, removeEntitiesPacket, Collections.unmodifiableList(removeEntitiesLegacyPacket));
        });
        this.cachedEntityFrameData = cachedEntityFrameData;
    }

    private void unloadAnimationDataForCaptcha() {
        this.unloadAnimatedCaptchaTimer();
        this.unloadAnimatedFramesEntityMetaData();
    }

    private void unloadAnimatedCaptchaTimer() {
        if (this.animatedCaptchaTimer == null) {
            return;
        }
        try {
            this.animatedCaptchaTimer.shutdown();
            this.animatedCaptchaTimer.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.log(Level.SEVERE, "Failed to shutdown animation captcha scheduler", e);
        }
        this.animatedCaptchaTimer = null;
    }

    private void unloadAnimatedFramesEntityMetaData() {
        if (this.animatedFramesEntityMetaData == null) {
            return;
        }
        for (AnimatedFramesEntityMetaListData data : this.animatedFramesEntityMetaData.getAllData()) {
            for (CachedItemFrameRotationDataImpl itemFrameRotationData : data.getData()) {
                itemFrameRotationData.release();
            }
        }
        this.animatedFramesEntityMetaData = null;
    }

    public void loadAnimationDataForCaptcha(ForkJoinPool executor) {
        this.loadAnimatedCaptchaTimer();
        this.loadAnimatedFramesEntityMetaData(executor);
    }

    private void loadAnimatedCaptchaTimer() {
        long delay;
        if (this.animatedCaptchaTimer != null) {
            return;
        }
        this.animatedCaptchaTimer = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("NullCordX-CaptchaAnimation-%d").build());
        CheckingFactoriesImpl checkingFactories = this.nullCordX.getCaptchaGenerator().getCheckingFactories();
        if (checkingFactories.isNeedGenerateAnimatedHandCaptcha()) {
            delay = AnimatedHandCaptchaSettings.IMP.ANIMATED_HAND_CAPTCHA.ANIMATION_DELAY;
            this.animatedCaptchaTimer.scheduleWithFixedDelay(new AnimationTask(this.logger, this.nullCordX, abstractChecking -> abstractChecking instanceof AnimatedHandCaptchaCheck), delay, delay, TimeUnit.MILLISECONDS);
        }
        if (checkingFactories.isNeedGenerateAnimatedFramedCaptcha()) {
            delay = AnimatedFramedCaptchaSettings.IMP.ANIMATED_FRAMED_CAPTCHA.ANIMATION_DELAY;
            this.animatedCaptchaTimer.scheduleWithFixedDelay(new AnimationTask(this.logger, this.nullCordX, abstractChecking -> abstractChecking instanceof AnimatedFramedCaptchaCheck), delay, delay, TimeUnit.MILLISECONDS);
        }
        if (checkingFactories.isNeedGenerateAnimatedFramedPuzzle()) {
            delay = AnimatedFramedPuzzleSettings.IMP.ANIMATED_FRAMED_PUZZLE.ANIMATION_DELAY;
            this.animatedCaptchaTimer.scheduleWithFixedDelay(new AnimationTask(this.logger, this.nullCordX, abstractChecking -> abstractChecking instanceof AnimatedFramedPuzzleCheck), delay, delay, TimeUnit.MILLISECONDS);
        }
    }

    private void loadAnimatedFramesEntityMetaData(ForkJoinPool executor) {
        if (this.animatedFramesEntityMetaData != null) {
            return;
        }
        CheckingFactoriesImpl checkingFactories = this.nullCordX.getCaptchaGenerator().getCheckingFactories();
        this.animatedFramesEntityMetaData = new PerRaCStorage<AnimatedFramesEntityMetaListData>(AnimatedFramesEntityMetaListData.class, checkingFactories.getMinFrameRow(), checkingFactories.getMaxFrameRow(), checkingFactories.getMinFrameColumn(), checkingFactories.getMaxFrameColumn());
        int maxFrames = 0;
        List<ResizedGif> resizedGifs = this.nullCordX.getCaptchaGenerator().getCaptchaDataSettings().getAllGifs();
        if (resizedGifs != null) {
            for (ResizedGif resizedGif : resizedGifs) {
                BufferedGif bufferedGif = resizedGif.getStorage().getDataByRaC(1, 1);
                int size = bufferedGif.getFrames().size();
                if (size <= maxFrames) continue;
                maxFrames = size;
            }
        }
        if (maxFrames < checkingFactories.getMaxAnimationFrames()) {
            maxFrames = checkingFactories.getMaxAnimationFrames();
        }
        int finalMaxFrames = maxFrames;
        this.animatedFramesEntityMetaData.loadNow(executor, (row, column) -> {
            ArrayList<CachedItemFrameRotationDataImpl> framesAndEntityData = new ArrayList<CachedItemFrameRotationDataImpl>();
            for (int frameId = 1; frameId <= finalMaxFrames; ++frameId) {
                CachedItemFrameRotationDataImpl cachedItemFrameRotationData = new CachedItemFrameRotationDataImpl();
                int maxMapId = frameId * (row * column);
                int mapId = maxMapId - row * column;
                for (int countEntityId = 250; countEntityId <= row * column + 250; ++countEntityId) {
                    ++mapId;
                    for (ProtocolItemFrameRotationType rotation : ProtocolItemFrameRotationType.values()) {
                        ArrayList<EntityMetadata> entityMetadata = new ArrayList<EntityMetadata>();
                        entityMetadata.add(new EntityMetadata(EntityMetadataIndexType.ITEM_FRAME_ITEM, EntityMetadataFieldType.SLOT, new SlotData(ProtocolItemType.FILLED_MAP, 1, mapId)));
                        entityMetadata.add(new EntityMetadata(EntityMetadataIndexType.ITEM_FRAME_ROTATION, EntityMetadataFieldType.VAR_INT, new RotationData(rotation)));
                        cachedItemFrameRotationData.add(rotation, countEntityId, CachedPacket.create(new SetEntityMetadataPacket(countEntityId, entityMetadata), Protocol.FILTER));
                    }
                }
                framesAndEntityData.add(cachedItemFrameRotationData);
            }
            return new AnimatedFramesEntityMetaListData(framesAndEntityData);
        });
    }

    private static String createCaptchaSettingsHash(String data, Object object) {
        return String.valueOf(Objects.hash(4, ProtocolConstants.SUPPORTED_VERSION_IDS_CHANGED, BungeeCordSettings.IMP.NETWORK_COMPRESSION_THRESHOLD, ConfigSettings.IMP.PERFORMANCE.COMPRESSION.CACHED_PACKET.LEVEL, CaptchaSettings.IMP, data, object));
    }

    public LocalScheduler getLocalScheduler() {
        return this.localScheduler;
    }

    public CachedCaptchaPacketsImpl<CachedMapDataPacket> getCachedHandCaptchaPackets() {
        return this.cachedHandCaptchaPackets;
    }

    public CachedCaptchaPacketsImpl<CachedFramesImpl<CachedMapDataPacket>> getCachedAnimatedHandCaptchaPackets() {
        return this.cachedAnimatedHandCaptchaPackets;
    }

    public CachedCaptchaPacketsImpl<CachedFramesFramedCaptchaImpl<CachedMapDataPacket>> getCachedFramedCaptchaPackets() {
        return this.cachedFramedCaptchaPackets;
    }

    public CachedCaptchaPacketsImpl<CachedFramesAnimatedFramedCaptchaImpl<CachedFramesAnimatedFramedCaptchaImpl<CachedMapDataPacket>>> getCachedAnimatedFramedCaptchaPackets() {
        return this.cachedAnimatedFramedCaptchaPackets;
    }

    public CachedCaptchaPacketsImpl<CachedFramesFramedPuzzleImpl<CachedMapDataPacket>> getCachedFramedPuzzlePackets() {
        return this.cachedFramedPuzzlePackets;
    }

    public CachedCaptchaPacketsImpl<CachedFramesAnimatedFramedPuzzleImpl<CachedFramesAnimatedFramedPuzzleImpl<CachedMapDataPacket>>> getCachedAnimatedFramedPuzzlePackets() {
        return this.cachedAnimatedFramedPuzzlePackets;
    }

    public CachedCaptchaPacketsImpl<CachedFramesPickCaptchaImpl<CachedMapDataPacket>> getCachedPickCaptchaPackets() {
        return this.cachedPickCaptchaPackets;
    }

    public PerRaCStorage<CachedEntityFrameDataImpl> getCachedEntityFrameData() {
        return this.cachedEntityFrameData;
    }

    public ScheduledExecutorService getAnimatedCaptchaTimer() {
        return this.animatedCaptchaTimer;
    }

    public PerRaCStorage<AnimatedFramesEntityMetaListData> getAnimatedFramesEntityMetaData() {
        return this.animatedFramesEntityMetaData;
    }

    public String getHandCaptchaSettingsHash() {
        return this.handCaptchaSettingsHash;
    }

    public String getAnimatedHandCaptchaSettingsHash() {
        return this.animatedHandCaptchaSettingsHash;
    }

    public String getFramedCaptchaSettingsHash() {
        return this.framedCaptchaSettingsHash;
    }

    public String getAnimatedFramedCaptchaSettingsHash() {
        return this.animatedFramedCaptchaSettingsHash;
    }

    public String getFramedPuzzleSettingsHash() {
        return this.framedPuzzleSettingsHash;
    }

    public String getAnimatedFramedPuzzleSettingsHash() {
        return this.animatedFramedPuzzleSettingsHash;
    }

    public String getPickCaptchaSettingsHash() {
        return this.pickCaptchaSettingsHash;
    }

    private static class AnimationTask
    extends SafeScheduledTask {
        private final NullCordXImpl nullCordX;
        private final Predicate<AbstractChecking> predicate;

        public AnimationTask(Logger logger, NullCordXImpl nullCordX, Predicate<AbstractChecking> predicate) {
            super(logger);
            this.nullCordX = nullCordX;
            this.predicate = predicate;
        }

        @Override
        public void doTask() {
            for (VirtualConnector connector : this.nullCordX.getUserManager().getAllCheckingUsers()) {
                AbstractChecking checking;
                if (!connector.isConnected() || connector.isCompleted() || (checking = connector.getCurrentChecking()) == null || !(checking instanceof AnimatedCaptchaCheck)) continue;
                AnimatedCaptchaCheck animatedCaptchaCheck = (AnimatedCaptchaCheck)((Object)checking);
                if (!this.predicate.test(checking)) continue;
                connector.getChannel().getHandle().eventLoop().execute(() -> {
                    if (!connector.isConnected() || connector.isCompleted()) {
                        return;
                    }
                    animatedCaptchaCheck.handleAnimation(true);
                });
            }
        }
    }
}

