/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.cache;

import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;
import net.shieldcommunity.nullcordx.api.cache.CachedCaptchaPackets;
import net.shieldcommunity.nullcordx.api.utils.FastRandom;
import net.shieldcommunity.nullcordx.cache.CaptchaHolderImpl;

public class CachedCaptchaPacketsImpl<T extends ByteBufPacket>
implements CachedCaptchaPackets<T> {
    private final String name;
    private CaptchaHolderImpl<T>[] captchas = new CaptchaHolderImpl[0];

    @Override
    public void release() {
        if (this.captchas == null) {
            return;
        }
        for (CaptchaHolderImpl<T> holder : this.captchas) {
            holder.release();
        }
    }

    @Override
    public CaptchaHolderImpl<T> randomCaptcha() {
        if (this.captchas == null || this.captchas.length == 0) {
            return null;
        }
        CaptchaHolderImpl<T> holder = this.captchas[FastRandom.getFastRandom().nextInt(this.captchas.length)];
        if (holder.getCaptcha() == null) {
            return null;
        }
        holder.setDirty(true);
        return holder;
    }

    public void clear() {
        if (this.captchas == null) {
            return;
        }
        this.release();
        this.captchas = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public CaptchaHolderImpl<T>[] getCaptchas() {
        return this.captchas;
    }

    public CachedCaptchaPacketsImpl(String name) {
        this.name = name;
    }

    public void setCaptchas(CaptchaHolderImpl<T>[] captchas) {
        this.captchas = captchas;
    }
}

