/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.cache;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.Adler32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;
import net.shieldcommunity.nullcordx.cache.CachedPacket;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.objects.ObjectSet;
import net.shieldcommunity.nullcordx.natives.ByteBufAllocationUtils;
import net.shieldcommunity.nullcordx.natives.compression.Compressor;
import net.shieldcommunity.nullcordx.protocol.packets.MapDataPacket;
import net.shieldcommunity.nullcordx.utils.CompressorThreadLocal;
import net.shieldcommunity.nullcordx.utils.IOUtils;
import net.shieldcommunity.nullcordx.utils.WrappedCompressors;

public class CachedMapDataPacket
implements ByteBufPacket {
    private Int2ObjectMap<PerVersionBufData> packetsPerProtocol = new Int2ObjectOpenHashMap<PerVersionBufData>();
    private ByteBuf zlibHeader = null;
    private Int2ObjectMap<ByteBuf> prependByHash;
    private Int2ObjectMap<ByteBufData> commonDataByHash;
    private Int2ObjectMap<ByteBufData> pixelsDataByHash;
    private Int2ObjectMap<ByteBuf> adlerByHash;

    public static CachedMapDataPacket create(MapDataPacket mapDataPacket, CompressorThreadLocal compressorThreadLocal) {
        CachedMapDataPacket cachedPacket = new CachedMapDataPacket();
        cachedPacket.encode(mapDataPacket, BungeeCord.getInstance().config.getCompressionThreshold(), ProtocolConstants.SUPPORTED_VERSION_IDS_CHANGED, compressorThreadLocal);
        return cachedPacket;
    }

    private void encode(MapDataPacket mapDataPacket, int compressThreshold, List<Integer> versions, CompressorThreadLocal compressorThreadLocal) {
        if (compressThreshold != -1) {
            this.encodeWithCompression(mapDataPacket, compressThreshold, versions, compressorThreadLocal);
        } else {
            this.encodeWithoutCompression(mapDataPacket, versions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeWithCompression(MapDataPacket mapDataPacket, int compressThreshold, List<Integer> versions, CompressorThreadLocal compressorThreadLocal) {
        WrappedCompressors wrappedCompressors = (WrappedCompressors)compressorThreadLocal.get();
        int compressionLevel = compressorThreadLocal.getCompressionLevel();
        Int2ObjectOpenHashMap<ByteBuf> prependByHash = new Int2ObjectOpenHashMap<ByteBuf>();
        Int2ObjectOpenHashMap<ByteBufData> commonDataByHash = new Int2ObjectOpenHashMap<ByteBufData>();
        Int2ObjectOpenHashMap<ByteBufData> pixelsDataByHash = new Int2ObjectOpenHashMap<ByteBufData>();
        Int2ObjectOpenHashMap<ByteBuf> adlerByHash = new Int2ObjectOpenHashMap<ByteBuf>();
        ByteBuf zlibHeaderBuf = CachedMapDataPacket.createZlibHeader(compressionLevel);
        ByteBuf tmpBuffer = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
        Adler32 adler32 = new Adler32();
        try {
            Int2ObjectOpenHashMap<PerVersionBufData> samePerVersionBufData = new Int2ObjectOpenHashMap<PerVersionBufData>();
            for (int version : versions) {
                PerVersionBufData currentPerVersionBufData;
                int perVersionBufDataHash;
                PerVersionBufData perVersionBufData;
                CompositeByteBuf compositeByteBuf;
                ByteBuf samePrependBuffer;
                int bufPrependHash;
                int packetLength;
                tmpBuffer.resetReaderIndex();
                tmpBuffer.resetWriterIndex();
                int packetId = CachedPacket.getPacketId(mapDataPacket, version, Protocol.FILTER);
                DefinedPacket.writeVarInt(packetId, tmpBuffer);
                mapDataPacket.writeCommonData(tmpBuffer, version);
                int bufCommonHash = tmpBuffer.hashCode();
                ByteBufData sameBufCommon = this.calculateByteBufAndCompress(bufCommonHash, tmpBuffer, commonDataByHash, wrappedCompressors, true);
                tmpBuffer.resetReaderIndex();
                tmpBuffer.resetWriterIndex();
                mapDataPacket.writePixels(tmpBuffer, version);
                int bufPixelsHash = tmpBuffer.hashCode();
                ByteBufData sameBufPixels = this.calculateByteBufAndCompress(bufPixelsHash, tmpBuffer, pixelsDataByHash, wrappedCompressors, false);
                tmpBuffer.resetReaderIndex();
                tmpBuffer.resetWriterIndex();
                CachedMapDataPacket.encodeAdler(adler32, tmpBuffer, sameBufCommon.getUncompressed(), sameBufPixels.getUncompressed());
                int bufAdlerHash = tmpBuffer.hashCode();
                ByteBuf sameAdlerBuffer = this.calculateByteBuf(bufAdlerHash, tmpBuffer, adlerByHash);
                tmpBuffer.resetReaderIndex();
                tmpBuffer.resetWriterIndex();
                int uncompressedLength = sameBufCommon.getUncompressed().readableBytes() + sameBufPixels.getUncompressed().readableBytes();
                if (uncompressedLength >= compressThreshold) {
                    sameBufCommon.setCompressedUsed(true);
                    sameBufPixels.setCompressedUsed(true);
                    packetLength = DefinedPacket.varIntBytes(uncompressedLength) + zlibHeaderBuf.readableBytes() + sameBufCommon.getCompressed().readableBytes() + sameBufPixels.getCompressed().readableBytes() + sameAdlerBuffer.readableBytes();
                    DefinedPacket.writeVarInt(packetLength, tmpBuffer);
                    DefinedPacket.writeVarInt(uncompressedLength, tmpBuffer);
                    bufPrependHash = tmpBuffer.hashCode();
                    samePrependBuffer = this.calculateByteBuf(bufPrependHash, tmpBuffer, prependByHash);
                    compositeByteBuf = IOUtils.allocateCompositeByteBufBySettings(5);
                    compositeByteBuf.addComponent(true, samePrependBuffer.retain());
                    compositeByteBuf.addComponent(true, zlibHeaderBuf.retain());
                    compositeByteBuf.addComponent(true, sameBufCommon.getCompressed().retain());
                    compositeByteBuf.addComponent(true, sameBufPixels.getCompressed().retain());
                    compositeByteBuf.addComponent(true, sameAdlerBuffer.retain());
                    perVersionBufData = new PerVersionBufData(compositeByteBuf, true, bufPrependHash, bufCommonHash, bufPixelsHash, bufAdlerHash);
                    perVersionBufDataHash = perVersionBufData.hashCode();
                    currentPerVersionBufData = (PerVersionBufData)samePerVersionBufData.get(perVersionBufDataHash);
                    if (currentPerVersionBufData != null) {
                        this.packetsPerProtocol.put(version, currentPerVersionBufData);
                        perVersionBufData.release();
                        continue;
                    }
                    this.packetsPerProtocol.put(version, perVersionBufData);
                    samePerVersionBufData.put(perVersionBufDataHash, perVersionBufData);
                    continue;
                }
                sameBufCommon.setUncompressedUsed(true);
                sameBufPixels.setUncompressedUsed(true);
                packetLength = DefinedPacket.varIntBytes(0) + sameBufCommon.getUncompressed().readableBytes() + sameBufPixels.getUncompressed().readableBytes();
                DefinedPacket.writeVarInt(packetLength, tmpBuffer);
                DefinedPacket.writeVarInt(0, tmpBuffer);
                bufPrependHash = tmpBuffer.hashCode();
                samePrependBuffer = this.calculateByteBuf(bufPrependHash, tmpBuffer, prependByHash);
                compositeByteBuf = IOUtils.allocateCompositeByteBufBySettings(3);
                compositeByteBuf.addComponent(true, samePrependBuffer.retain());
                compositeByteBuf.addComponent(true, sameBufCommon.getUncompressed().retain());
                compositeByteBuf.addComponent(true, sameBufPixels.getUncompressed().retain());
                perVersionBufData = new PerVersionBufData(compositeByteBuf, false, bufPrependHash, bufCommonHash, bufPixelsHash, bufAdlerHash);
                perVersionBufDataHash = perVersionBufData.hashCode();
                currentPerVersionBufData = (PerVersionBufData)samePerVersionBufData.get(perVersionBufDataHash);
                if (currentPerVersionBufData != null) {
                    this.packetsPerProtocol.put(version, currentPerVersionBufData);
                    perVersionBufData.release();
                    continue;
                }
                this.packetsPerProtocol.put(version, perVersionBufData);
                samePerVersionBufData.put(perVersionBufDataHash, perVersionBufData);
            }
        }
        finally {
            CachedPacket.releaseByteBufSafe(tmpBuffer);
        }
        for (ByteBufData buf : commonDataByHash.values()) {
            buf.releaseUnused();
        }
        for (ByteBufData buf : pixelsDataByHash.values()) {
            buf.releaseUnused();
        }
        this.zlibHeader = zlibHeaderBuf;
        this.prependByHash = prependByHash;
        this.commonDataByHash = commonDataByHash;
        this.pixelsDataByHash = pixelsDataByHash;
        this.adlerByHash = adlerByHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeWithoutCompression(MapDataPacket mapDataPacket, List<Integer> versions) {
        Int2ObjectOpenHashMap<ByteBuf> prependByHash = new Int2ObjectOpenHashMap<ByteBuf>();
        Int2ObjectOpenHashMap<ByteBufData> commonDataByHash = new Int2ObjectOpenHashMap<ByteBufData>();
        Int2ObjectOpenHashMap<ByteBufData> pixelsDataByHash = new Int2ObjectOpenHashMap<ByteBufData>();
        ByteBuf tmpBuffer = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
        try {
            Int2ObjectOpenHashMap<PerVersionBufData> samePerVersionBufData = new Int2ObjectOpenHashMap<PerVersionBufData>();
            for (int version : versions) {
                tmpBuffer.resetReaderIndex();
                tmpBuffer.resetWriterIndex();
                int packetId = CachedPacket.getPacketId(mapDataPacket, version, Protocol.FILTER);
                DefinedPacket.writeVarInt(packetId, tmpBuffer);
                mapDataPacket.writeCommonData(tmpBuffer, version);
                int bufCommonHash = tmpBuffer.hashCode();
                ByteBufData sameBufCommon = this.calculateByteBufData(bufCommonHash, tmpBuffer, commonDataByHash);
                tmpBuffer.resetReaderIndex();
                tmpBuffer.resetWriterIndex();
                mapDataPacket.writePixels(tmpBuffer, version);
                int bufPixelsHash = tmpBuffer.hashCode();
                ByteBufData sameBufPixels = this.calculateByteBufData(bufPixelsHash, tmpBuffer, pixelsDataByHash);
                tmpBuffer.resetReaderIndex();
                tmpBuffer.resetWriterIndex();
                sameBufCommon.setUncompressedUsed(true);
                sameBufPixels.setUncompressedUsed(true);
                int length = sameBufCommon.getUncompressed().readableBytes() + sameBufPixels.getUncompressed().readableBytes();
                DefinedPacket.writeVarInt(length, tmpBuffer);
                int bufPrependHash = tmpBuffer.hashCode();
                ByteBuf sameBufPrepend = this.calculateByteBuf(bufPrependHash, tmpBuffer, prependByHash);
                CompositeByteBuf compositeByteBuf = IOUtils.allocateCompositeByteBufBySettings(3);
                compositeByteBuf.addComponent(true, sameBufPrepend.retain());
                compositeByteBuf.addComponent(true, sameBufCommon.getUncompressed().retain());
                compositeByteBuf.addComponent(true, sameBufPixels.getUncompressed().retain());
                PerVersionBufData perVersionBufData = new PerVersionBufData(compositeByteBuf, false, bufPrependHash, bufCommonHash, bufPixelsHash, 0);
                int perVersionBufDataHash = perVersionBufData.hashCode();
                PerVersionBufData currentPerVersionBufData = (PerVersionBufData)samePerVersionBufData.get(perVersionBufDataHash);
                if (currentPerVersionBufData != null) {
                    this.packetsPerProtocol.put(version, currentPerVersionBufData);
                    perVersionBufData.release();
                    continue;
                }
                this.packetsPerProtocol.put(version, perVersionBufData);
                samePerVersionBufData.put(perVersionBufDataHash, perVersionBufData);
            }
        }
        finally {
            CachedPacket.releaseByteBufSafe(tmpBuffer);
        }
        for (ByteBufData buf : commonDataByHash.values()) {
            buf.releaseUnused();
        }
        for (ByteBufData buf : pixelsDataByHash.values()) {
            buf.releaseUnused();
        }
        this.prependByHash = prependByHash;
        this.commonDataByHash = commonDataByHash;
        this.pixelsDataByHash = pixelsDataByHash;
    }

    private ByteBufData calculateByteBufData(int hash, ByteBuf buf, Int2ObjectMap<ByteBufData> cache) {
        ByteBufData sameBufCommon = (ByteBufData)cache.get(hash);
        if (sameBufCommon == null) {
            ByteBuf newBuf = IOUtils.allocateByteBufBySettings(buf.readableBytes());
            newBuf.writeBytes(buf);
            ByteBufData newByteBufData = new ByteBufData(newBuf, null);
            cache.put(hash, newByteBufData);
            sameBufCommon = newByteBufData;
        }
        return sameBufCommon;
    }

    private ByteBuf calculateByteBuf(int hash, ByteBuf buf, Int2ObjectMap<ByteBuf> cache) {
        ByteBuf sameBufCommon = (ByteBuf)cache.get(hash);
        if (sameBufCommon == null) {
            ByteBuf newBuf = IOUtils.allocateByteBufBySettings(buf.readableBytes());
            newBuf.writeBytes(buf);
            cache.put(hash, newBuf);
            sameBufCommon = newBuf;
        }
        return sameBufCommon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBufData calculateByteBufAndCompress(int hash, ByteBuf buf, Int2ObjectMap<ByteBufData> cache, WrappedCompressors wrappedCompressors, boolean skipEndBlock) {
        ByteBufData sameBufCommon = (ByteBufData)cache.get(hash);
        if (sameBufCommon == null) {
            ByteBufData byteBufData;
            block28: {
                ByteBuf newBuf = IOUtils.allocateByteBufBySettings(buf.readableBytes());
                newBuf.writeBytes(buf);
                if (!skipEndBlock) {
                    ByteBuf compressedOut = IOUtils.getByteBufAllocatorBySettings().directBuffer(newBuf.readableBytes());
                    try {
                        ByteBuf retainedDuplicate = newBuf.retainedDuplicate();
                        try {
                            Compressor compressor = wrappedCompressors.getCompressor();
                            ByteBuf compatibleIn = ByteBufAllocationUtils.makeCorrect(IOUtils.getByteBufAllocatorBySettings(), compressor, retainedDuplicate);
                            try {
                                compressor.deflate(compatibleIn, compressedOut);
                            }
                            catch (DataFormatException e) {
                                throw new RuntimeException(e);
                            }
                            finally {
                                CachedPacket.releaseByteBufSafe(compatibleIn);
                            }
                            ByteBuf newCompressedOut = IOUtils.allocateByteBufBySettings(compressedOut.readableBytes() - 6);
                            compressedOut.skipBytes(2);
                            int writerIndex = compressedOut.writerIndex();
                            compressedOut.writerIndex(writerIndex - 4);
                            newCompressedOut.writeBytes(compressedOut);
                            byteBufData = new ByteBufData(newBuf, newCompressedOut);
                            break block28;
                        }
                        finally {
                            CachedPacket.releaseByteBufSafe(retainedDuplicate);
                        }
                    }
                    finally {
                        CachedPacket.releaseByteBufSafe(compressedOut);
                    }
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ByteBuf compressed = IOUtils.allocateByteBufBySettings();
                Deflater deflater = wrappedCompressors.getDeflater();
                try (DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater, true);){
                    ByteBuf retainedDuplicate = newBuf.retainedDuplicate();
                    try {
                        int readableBytes = retainedDuplicate.readableBytes();
                        for (int i = 0; i < readableBytes; ++i) {
                            deflaterOutputStream.write(retainedDuplicate.readByte());
                        }
                        deflaterOutputStream.flush();
                        compressed.writeBytes(byteArrayOutputStream.toByteArray());
                    }
                    finally {
                        CachedPacket.releaseByteBufSafe(retainedDuplicate);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    deflater.reset();
                }
                byteBufData = new ByteBufData(newBuf, compressed);
            }
            cache.put(hash, byteBufData);
            sameBufCommon = byteBufData;
        }
        return sameBufCommon;
    }

    @Override
    public ByteBuf getByteBufByProtocol(int protocol) {
        return ((PerVersionBufData)this.packetsPerProtocol.get(protocol)).getCompositeByteBuf();
    }

    @Override
    public void release() {
        for (PerVersionBufData perVersionBufData : this.packetsPerProtocol.values()) {
            perVersionBufData.release();
        }
        if (this.zlibHeader != null) {
            CachedPacket.releaseByteBufSafe(this.zlibHeader);
            this.zlibHeader = null;
        }
        if (this.prependByHash != null) {
            for (ByteBuf buf : this.prependByHash.values()) {
                CachedPacket.releaseByteBufSafe(buf);
            }
            this.prependByHash = null;
        }
        if (this.adlerByHash != null) {
            for (ByteBuf buf : this.adlerByHash.values()) {
                CachedPacket.releaseByteBufSafe(buf);
            }
            this.adlerByHash = null;
        }
        if (this.commonDataByHash != null) {
            for (ByteBufData byteBufData : this.commonDataByHash.values()) {
                byteBufData.releaseAll();
            }
            this.commonDataByHash = null;
        }
        if (this.pixelsDataByHash != null) {
            for (ByteBufData byteBufData : this.pixelsDataByHash.values()) {
                byteBufData.releaseAll();
            }
            this.pixelsDataByHash = null;
        }
    }

    @Override
    public boolean isForceCopyOnOnlineMode() {
        return true;
    }

    private static ByteBuf createZlibHeader(int compressionLevel) {
        ByteBuf header = IOUtils.allocateByteBufBySettings(2, 2);
        header.writeByte(120);
        header.writeByte(CachedMapDataPacket.getFLGByCompression(compressionLevel));
        return header;
    }

    private static byte getFLGByCompression(int compression) {
        switch (compression) {
            case 0: 
            case 1: {
                return 1;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 94;
            }
            case 6: {
                return -100;
            }
            case 7: 
            case 8: 
            case 9: {
                return -38;
            }
        }
        throw new IllegalStateException("Compression " + compression + " is not supported.");
    }

    private static void encodeAdler(Adler32 adler32, ByteBuf output, ByteBuf firstBuf, ByteBuf secondBuf) {
        adler32.reset();
        byte[] first = ByteBufUtil.getBytes(firstBuf);
        adler32.update(first, 0, first.length);
        byte[] second = ByteBufUtil.getBytes(secondBuf);
        adler32.update(second, 0, second.length);
        int sum = (int)adler32.getValue();
        output.writeByte(sum >> 24);
        output.writeByte(sum >> 16);
        output.writeByte(sum >> 8);
        output.writeByte(sum);
    }

    public static CachedMapDataPacket deserialize(ByteBuf input) {
        ByteBuf zlibHeader = IOUtils.getAndReadByteArray(input);
        Int2ObjectOpenHashMap<ByteBuf> prependByHash = new Int2ObjectOpenHashMap<ByteBuf>();
        int prependByHashSize = input.readInt();
        for (int i = 0; i < prependByHashSize; ++i) {
            int hash = input.readInt();
            ByteBuf data = IOUtils.getAndReadByteArray(input);
            prependByHash.put(hash, data);
        }
        Int2ObjectOpenHashMap<ByteBufData> commonDataByHash = new Int2ObjectOpenHashMap<ByteBufData>();
        int commonDataByHashSize = input.readInt();
        for (int i = 0; i < commonDataByHashSize; ++i) {
            int hash = input.readInt();
            ByteBuf uncompressed = IOUtils.getAndReadByteArray(input);
            ByteBuf compressed = IOUtils.getAndReadByteArray(input);
            ByteBufData byteBufData = new ByteBufData(uncompressed, compressed);
            byteBufData.setUncompressedUsed(uncompressed != null);
            byteBufData.setCompressedUsed(compressed != null);
            commonDataByHash.put(hash, byteBufData);
        }
        Int2ObjectOpenHashMap<ByteBufData> pixelsDataByHash = new Int2ObjectOpenHashMap<ByteBufData>();
        int pixelsDataByHashSize = input.readInt();
        for (int i = 0; i < pixelsDataByHashSize; ++i) {
            int hash = input.readInt();
            ByteBuf uncompressed = IOUtils.getAndReadByteArray(input);
            ByteBuf compressed = IOUtils.getAndReadByteArray(input);
            ByteBufData byteBufData = new ByteBufData(uncompressed, compressed);
            byteBufData.setUncompressedUsed(uncompressed != null);
            byteBufData.setCompressedUsed(compressed != null);
            pixelsDataByHash.put(hash, byteBufData);
        }
        Int2ObjectOpenHashMap<ByteBuf> adlerByHash = null;
        int adlerByHashSize = input.readInt();
        if (adlerByHashSize > 0) {
            adlerByHash = new Int2ObjectOpenHashMap<ByteBuf>();
        }
        for (int i = 0; i < adlerByHashSize; ++i) {
            int hash = input.readInt();
            ByteBuf data = IOUtils.getAndReadByteArray(input);
            adlerByHash.put(hash, data);
        }
        Int2ObjectOpenHashMap<PerVersionBufData> samePerVersionBufData = new Int2ObjectOpenHashMap<PerVersionBufData>();
        Int2ObjectOpenHashMap<PerVersionBufData> packetsPerProtocol = new Int2ObjectOpenHashMap<PerVersionBufData>();
        int versionSize = input.readInt();
        for (int i = 0; i < versionSize; ++i) {
            int version = input.readInt();
            boolean compressed = input.readBoolean();
            int prependHash = input.readInt();
            ByteBuf prependBuf = (ByteBuf)prependByHash.get(prependHash);
            if (prependBuf == null) {
                throw new IllegalStateException("Prepend hash " + prependHash + " not found for version " + version);
            }
            int commonHash = input.readInt();
            ByteBufData commonBufData = (ByteBufData)commonDataByHash.get(commonHash);
            if (commonBufData == null) {
                throw new IllegalStateException("Common hash " + commonHash + " not found for version " + version);
            }
            int pixelHash = input.readInt();
            ByteBufData pixelsBufData = (ByteBufData)pixelsDataByHash.get(pixelHash);
            if (pixelsBufData == null) {
                throw new IllegalStateException("Pixels hash " + pixelHash + " not found for version " + version);
            }
            int adlerHash = input.readInt();
            if (compressed && zlibHeader != null && adlerByHash != null) {
                ByteBuf adlerBuf = (ByteBuf)adlerByHash.get(adlerHash);
                if (adlerBuf == null) {
                    throw new IllegalStateException("Adler hash " + adlerHash + " not found for version " + version);
                }
                CompositeByteBuf compositeByteBuf = IOUtils.allocateCompositeByteBufBySettings(5);
                compositeByteBuf.addComponent(true, prependBuf.retain());
                compositeByteBuf.addComponent(true, zlibHeader.retain());
                compositeByteBuf.addComponent(true, commonBufData.getCompressed().retain());
                compositeByteBuf.addComponent(true, pixelsBufData.getCompressed().retain());
                compositeByteBuf.addComponent(true, adlerBuf.retain());
                PerVersionBufData perVersionBufData = new PerVersionBufData(compositeByteBuf, true, prependHash, commonHash, pixelHash, adlerHash);
                int perVersionBufDataHash = perVersionBufData.hashCode();
                PerVersionBufData currentPerVersionBufData = (PerVersionBufData)samePerVersionBufData.get(perVersionBufDataHash);
                if (currentPerVersionBufData != null) {
                    packetsPerProtocol.put(version, currentPerVersionBufData);
                    perVersionBufData.release();
                    continue;
                }
                packetsPerProtocol.put(version, perVersionBufData);
                samePerVersionBufData.put(perVersionBufDataHash, perVersionBufData);
                continue;
            }
            CompositeByteBuf compositeByteBuf = IOUtils.allocateCompositeByteBufBySettings(3);
            compositeByteBuf.addComponent(true, prependBuf.retain());
            compositeByteBuf.addComponent(true, commonBufData.getUncompressed().retain());
            compositeByteBuf.addComponent(true, pixelsBufData.getUncompressed().retain());
            PerVersionBufData perVersionBufData = new PerVersionBufData(compositeByteBuf, false, prependHash, commonHash, pixelHash, adlerHash);
            int perVersionBufDataHash = perVersionBufData.hashCode();
            PerVersionBufData currentPerVersionBufData = (PerVersionBufData)samePerVersionBufData.get(perVersionBufDataHash);
            if (currentPerVersionBufData != null) {
                packetsPerProtocol.put(version, currentPerVersionBufData);
                perVersionBufData.release();
                continue;
            }
            packetsPerProtocol.put(version, perVersionBufData);
            samePerVersionBufData.put(perVersionBufDataHash, perVersionBufData);
        }
        CachedMapDataPacket cachedMapDataPacket = new CachedMapDataPacket();
        cachedMapDataPacket.setPacketsPerProtocol(packetsPerProtocol);
        cachedMapDataPacket.setZlibHeader(zlibHeader);
        cachedMapDataPacket.setPrependByHash(prependByHash);
        cachedMapDataPacket.setCommonDataByHash(commonDataByHash);
        cachedMapDataPacket.setPixelsDataByHash(pixelsDataByHash);
        cachedMapDataPacket.setAdlerByHash(adlerByHash);
        return cachedMapDataPacket;
    }

    public void serialize(ByteBuf output) {
        IOUtils.writeByteArray(output, this.zlibHeader);
        ObjectSet<Int2ObjectMap.Entry<ByteBuf>> prependedByHash = this.prependByHash.int2ObjectEntrySet();
        output.writeInt(prependedByHash.size());
        for (Int2ObjectMap.Entry entry : prependedByHash) {
            output.writeInt(entry.getIntKey());
            IOUtils.writeByteArray(output, (ByteBuf)entry.getValue());
        }
        ObjectSet<Int2ObjectMap.Entry<ByteBufData>> commonsByHash = this.commonDataByHash.int2ObjectEntrySet();
        output.writeInt(commonsByHash.size());
        for (Int2ObjectMap.Entry entry : commonsByHash) {
            output.writeInt(entry.getIntKey());
            ByteBufData byteBufData = (ByteBufData)entry.getValue();
            IOUtils.writeByteArray(output, byteBufData.getUncompressed());
            IOUtils.writeByteArray(output, byteBufData.getCompressed());
        }
        ObjectSet<Int2ObjectMap.Entry<ByteBufData>> objectSet = this.pixelsDataByHash.int2ObjectEntrySet();
        output.writeInt(objectSet.size());
        for (Int2ObjectMap.Entry entry : objectSet) {
            output.writeInt(entry.getIntKey());
            ByteBufData byteBufData = (ByteBufData)entry.getValue();
            IOUtils.writeByteArray(output, byteBufData.getUncompressed());
            IOUtils.writeByteArray(output, byteBufData.getCompressed());
        }
        if (this.adlerByHash != null) {
            ObjectSet<Int2ObjectMap.Entry<ByteBuf>> objectSet2 = this.adlerByHash.int2ObjectEntrySet();
            output.writeInt(objectSet2.size());
            for (Int2ObjectMap.Entry entry : objectSet2) {
                output.writeInt(entry.getIntKey());
                IOUtils.writeByteArray(output, (ByteBuf)entry.getValue());
            }
        } else {
            output.writeInt(0);
        }
        ObjectSet<Int2ObjectMap.Entry<PerVersionBufData>> objectSet3 = this.packetsPerProtocol.int2ObjectEntrySet();
        output.writeInt(objectSet3.size());
        for (Int2ObjectMap.Entry entry : objectSet3) {
            output.writeInt(entry.getIntKey());
            PerVersionBufData perVersionBufData = (PerVersionBufData)entry.getValue();
            output.writeBoolean(perVersionBufData.isCompressed());
            output.writeInt(perVersionBufData.getPrependHash());
            output.writeInt(perVersionBufData.getCommonHash());
            output.writeInt(perVersionBufData.getPixelHash());
            output.writeInt(perVersionBufData.getAdlerHash());
        }
    }

    public Int2ObjectMap<PerVersionBufData> getPacketsPerProtocol() {
        return this.packetsPerProtocol;
    }

    public ByteBuf getZlibHeader() {
        return this.zlibHeader;
    }

    public Int2ObjectMap<ByteBuf> getPrependByHash() {
        return this.prependByHash;
    }

    public Int2ObjectMap<ByteBufData> getCommonDataByHash() {
        return this.commonDataByHash;
    }

    public Int2ObjectMap<ByteBufData> getPixelsDataByHash() {
        return this.pixelsDataByHash;
    }

    public Int2ObjectMap<ByteBuf> getAdlerByHash() {
        return this.adlerByHash;
    }

    public void setPacketsPerProtocol(Int2ObjectMap<PerVersionBufData> packetsPerProtocol) {
        this.packetsPerProtocol = packetsPerProtocol;
    }

    public void setZlibHeader(ByteBuf zlibHeader) {
        this.zlibHeader = zlibHeader;
    }

    public void setPrependByHash(Int2ObjectMap<ByteBuf> prependByHash) {
        this.prependByHash = prependByHash;
    }

    public void setCommonDataByHash(Int2ObjectMap<ByteBufData> commonDataByHash) {
        this.commonDataByHash = commonDataByHash;
    }

    public void setPixelsDataByHash(Int2ObjectMap<ByteBufData> pixelsDataByHash) {
        this.pixelsDataByHash = pixelsDataByHash;
    }

    public void setAdlerByHash(Int2ObjectMap<ByteBuf> adlerByHash) {
        this.adlerByHash = adlerByHash;
    }

    private static class ByteBufData {
        private ByteBuf uncompressed;
        private ByteBuf compressed;
        private boolean uncompressedUsed = false;
        private boolean compressedUsed = false;

        public ByteBufData(ByteBuf uncompressed, ByteBuf compressed) {
            this.uncompressed = uncompressed;
            this.compressed = compressed;
        }

        public void releaseUncompressed() {
            if (this.uncompressed == null) {
                return;
            }
            CachedPacket.releaseByteBufSafe(this.uncompressed);
            this.uncompressed = null;
        }

        public void releaseCompressed() {
            if (this.compressed == null) {
                return;
            }
            CachedPacket.releaseByteBufSafe(this.compressed);
            this.compressed = null;
        }

        public void releaseUnused() {
            if (!this.uncompressedUsed) {
                this.releaseUncompressed();
            }
            if (!this.compressedUsed) {
                this.releaseCompressed();
            }
        }

        public void releaseAll() {
            this.releaseUncompressed();
            this.releaseCompressed();
        }

        public ByteBuf getUncompressed() {
            return this.uncompressed;
        }

        public ByteBuf getCompressed() {
            return this.compressed;
        }

        public boolean isUncompressedUsed() {
            return this.uncompressedUsed;
        }

        public boolean isCompressedUsed() {
            return this.compressedUsed;
        }

        public void setUncompressed(ByteBuf uncompressed) {
            this.uncompressed = uncompressed;
        }

        public void setCompressed(ByteBuf compressed) {
            this.compressed = compressed;
        }

        public void setUncompressedUsed(boolean uncompressedUsed) {
            this.uncompressedUsed = uncompressedUsed;
        }

        public void setCompressedUsed(boolean compressedUsed) {
            this.compressedUsed = compressedUsed;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ByteBufData)) {
                return false;
            }
            ByteBufData other = (ByteBufData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isUncompressedUsed() != other.isUncompressedUsed()) {
                return false;
            }
            if (this.isCompressedUsed() != other.isCompressedUsed()) {
                return false;
            }
            ByteBuf this$uncompressed = this.getUncompressed();
            ByteBuf other$uncompressed = other.getUncompressed();
            if (this$uncompressed == null ? other$uncompressed != null : !((Object)this$uncompressed).equals(other$uncompressed)) {
                return false;
            }
            ByteBuf this$compressed = this.getCompressed();
            ByteBuf other$compressed = other.getCompressed();
            return !(this$compressed == null ? other$compressed != null : !((Object)this$compressed).equals(other$compressed));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ByteBufData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isUncompressedUsed() ? 79 : 97);
            result = result * 59 + (this.isCompressedUsed() ? 79 : 97);
            ByteBuf $uncompressed = this.getUncompressed();
            result = result * 59 + ($uncompressed == null ? 43 : ((Object)$uncompressed).hashCode());
            ByteBuf $compressed = this.getCompressed();
            result = result * 59 + ($compressed == null ? 43 : ((Object)$compressed).hashCode());
            return result;
        }

        public String toString() {
            return "CachedMapDataPacket.ByteBufData(uncompressed=" + this.getUncompressed() + ", compressed=" + this.getCompressed() + ", uncompressedUsed=" + this.isUncompressedUsed() + ", compressedUsed=" + this.isCompressedUsed() + ")";
        }
    }

    private static final class PerVersionBufData {
        private final CompositeByteBuf compositeByteBuf;
        private final boolean compressed;
        private final int prependHash;
        private final int commonHash;
        private final int pixelHash;
        private final int adlerHash;

        public void release() {
            CachedPacket.releaseByteBufSafe(this.compositeByteBuf);
        }

        public PerVersionBufData(CompositeByteBuf compositeByteBuf, boolean compressed, int prependHash, int commonHash, int pixelHash, int adlerHash) {
            this.compositeByteBuf = compositeByteBuf;
            this.compressed = compressed;
            this.prependHash = prependHash;
            this.commonHash = commonHash;
            this.pixelHash = pixelHash;
            this.adlerHash = adlerHash;
        }

        public CompositeByteBuf getCompositeByteBuf() {
            return this.compositeByteBuf;
        }

        public boolean isCompressed() {
            return this.compressed;
        }

        public int getPrependHash() {
            return this.prependHash;
        }

        public int getCommonHash() {
            return this.commonHash;
        }

        public int getPixelHash() {
            return this.pixelHash;
        }

        public int getAdlerHash() {
            return this.adlerHash;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PerVersionBufData)) {
                return false;
            }
            PerVersionBufData other = (PerVersionBufData)o;
            if (this.isCompressed() != other.isCompressed()) {
                return false;
            }
            if (this.getPrependHash() != other.getPrependHash()) {
                return false;
            }
            if (this.getCommonHash() != other.getCommonHash()) {
                return false;
            }
            if (this.getPixelHash() != other.getPixelHash()) {
                return false;
            }
            if (this.getAdlerHash() != other.getAdlerHash()) {
                return false;
            }
            CompositeByteBuf this$compositeByteBuf = this.getCompositeByteBuf();
            CompositeByteBuf other$compositeByteBuf = other.getCompositeByteBuf();
            return !(this$compositeByteBuf == null ? other$compositeByteBuf != null : !((Object)this$compositeByteBuf).equals(other$compositeByteBuf));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCompressed() ? 79 : 97);
            result = result * 59 + this.getPrependHash();
            result = result * 59 + this.getCommonHash();
            result = result * 59 + this.getPixelHash();
            result = result * 59 + this.getAdlerHash();
            CompositeByteBuf $compositeByteBuf = this.getCompositeByteBuf();
            result = result * 59 + ($compositeByteBuf == null ? 43 : ((Object)$compositeByteBuf).hashCode());
            return result;
        }

        public String toString() {
            return "CachedMapDataPacket.PerVersionBufData(compositeByteBuf=" + this.getCompositeByteBuf() + ", compressed=" + this.isCompressed() + ", prependHash=" + this.getPrependHash() + ", commonHash=" + this.getCommonHash() + ", pixelHash=" + this.getPixelHash() + ", adlerHash=" + this.getAdlerHash() + ")";
        }
    }
}

