/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.cache;

import com.google.gson.Gson;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.protocol.DefinedPacket;
import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;
import net.shieldcommunity.nullcordx.cache.CachedPacket;
import net.shieldcommunity.nullcordx.utils.IOUtils;

public class CachedMotd
implements ByteBufPacket {
    private final ByteBuf buf;

    public CachedMotd(ServerPing serverPing) {
        BungeeCord bungeeCord = BungeeCord.getInstance();
        Gson gson = bungeeCord.gson;
        String jsonString = gson.toJson(serverPing);
        byte[] bytes = jsonString.getBytes(StandardCharsets.UTF_8);
        int varIntLength = DefinedPacket.varIntBytes(bytes.length);
        int length = bytes.length + varIntLength + 1;
        int lengthOfLength = DefinedPacket.varIntBytes(length);
        this.buf = IOUtils.allocateByteBufBySettings(length + lengthOfLength);
        DefinedPacket.writeVarInt(length, this.buf);
        this.buf.writeByte(0);
        DefinedPacket.writeVarInt(bytes.length, this.buf);
        this.buf.writeBytes(bytes);
    }

    @Override
    public ByteBuf getByteBufByProtocol(int protocol) {
        return this.buf;
    }

    @Override
    public void release() {
        CachedPacket.releaseByteBufSafe(this.buf);
    }
}

