/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.cache;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.zip.DataFormatException;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.compress.PacketCompressor;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.Varint21LengthFieldPrepender;
import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.shieldcommunity.nullcordx.natives.ByteBufAllocationUtils;
import net.shieldcommunity.nullcordx.natives.compression.Compressor;
import net.shieldcommunity.nullcordx.utils.IOUtils;
import net.shieldcommunity.nullcordx.utils.WrappedCompressors;

public class CachedPacket
implements ByteBufPacket {
    private Int2ObjectMap<ByteBuf> packetsPerProtocol;

    private CachedPacket() {
    }

    private void encode(DefinedPacket packet, Protocol protocol, int compressThreshold) {
        this.encode(packet, protocol, compressThreshold, ProtocolConstants.SUPPORTED_VERSION_IDS_CHANGED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encode(DefinedPacket packet, Protocol protocol, int compressThreshold, List<Integer> versions) {
        Int2ObjectOpenHashMap<ByteBuf> packetsPerProtocol = new Int2ObjectOpenHashMap<ByteBuf>();
        Int2ObjectOpenHashMap<ByteBuf> byteBufByHash = new Int2ObjectOpenHashMap<ByteBuf>();
        Compressor compressor = null;
        if (compressThreshold != -1) {
            compressor = ((WrappedCompressors)IOUtils.getCompressorThreadLocal().get()).getCompressor();
        }
        ByteBuf tmpBuffer = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
        try {
            for (int version : versions) {
                tmpBuffer.resetReaderIndex();
                tmpBuffer.resetWriterIndex();
                int packetId = CachedPacket.getPacketId(packet, version, protocol);
                DefinedPacket.writeVarInt(packetId, tmpBuffer);
                packet.write(tmpBuffer, protocol, ProtocolConstants.Direction.TO_CLIENT, version);
                int uncompressedHash = tmpBuffer.hashCode();
                ByteBuf sameBuf = (ByteBuf)byteBufByHash.get(uncompressedHash);
                if (sameBuf != null) {
                    packetsPerProtocol.put(version, sameBuf);
                    continue;
                }
                ByteBuf encodedPacket = IOUtils.getByteBufAllocatorBySettings().heapBuffer(tmpBuffer.readableBytes());
                encodedPacket.writeBytes(tmpBuffer);
                try {
                    if (compressor != null) {
                        ByteBuf compressedAndPrependedBufferData = PacketCompressor.allocateByteBufForCompression(IOUtils.getByteBufAllocatorBySettings(), encodedPacket, compressThreshold);
                        try {
                            CachedPacket.compressAndPrepend(compressor, encodedPacket, compressedAndPrependedBufferData, compressThreshold);
                            ByteBuf trimmedBuff = IOUtils.allocateByteBufBySettings();
                            trimmedBuff.writeBytes(compressedAndPrependedBufferData);
                            byteBufByHash.put(uncompressedHash, trimmedBuff);
                            packetsPerProtocol.put(version, trimmedBuff);
                            continue;
                        }
                        finally {
                            CachedPacket.releaseByteBufSafe(compressedAndPrependedBufferData);
                            continue;
                        }
                    }
                    ByteBuf prependedBufferData = IOUtils.allocateByteBufBySettings(Varint21LengthFieldPrepender.getAllocationCapacity(encodedPacket));
                    Varint21LengthFieldPrepender.encode(encodedPacket, prependedBufferData);
                    byteBufByHash.put(uncompressedHash, prependedBufferData);
                    packetsPerProtocol.put(version, prependedBufferData);
                }
                finally {
                    CachedPacket.releaseByteBufSafe(encodedPacket);
                }
            }
        }
        finally {
            CachedPacket.releaseByteBufSafe(tmpBuffer);
        }
        this.packetsPerProtocol = packetsPerProtocol;
    }

    @Override
    public ByteBuf getByteBufByProtocol(int protocol) {
        if (this.packetsPerProtocol == null) {
            return null;
        }
        return (ByteBuf)this.packetsPerProtocol.get(protocol);
    }

    @Override
    public void release() {
        if (this.packetsPerProtocol == null) {
            return;
        }
        for (ByteBuf buff : this.packetsPerProtocol.values()) {
            CachedPacket.releaseByteBufSafe(buff);
        }
    }

    public static CachedPacket create(DefinedPacket packet, Protocol protocol, int compressThreshold, List<Integer> versions) {
        CachedPacket cachedPacket = new CachedPacket();
        cachedPacket.encode(packet, protocol, compressThreshold, versions);
        return cachedPacket;
    }

    public static CachedPacket create(DefinedPacket packet, Protocol protocol, int compressThreshold) {
        CachedPacket cachedPacket = new CachedPacket();
        cachedPacket.encode(packet, protocol, compressThreshold);
        return cachedPacket;
    }

    public static CachedPacket create(DefinedPacket packet, Protocol protocol, List<Integer> versions) {
        return CachedPacket.create(packet, protocol, BungeeCord.getInstance().config.getCompressionThreshold(), versions);
    }

    public static CachedPacket create(DefinedPacket packet, Protocol protocol) {
        return CachedPacket.create(packet, protocol, BungeeCord.getInstance().config.getCompressionThreshold());
    }

    public static int getPacketId(DefinedPacket packet, int version, Protocol protocol) {
        try {
            return protocol.TO_CLIENT.getId(packet.getClass(), version);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Can not get id for " + packet.getClass().getSimpleName() + "(" + version + ")");
        }
    }

    private static void compressAndPrepend(Compressor compressor, ByteBuf in, ByteBuf out, int threshold) {
        int origSize = in.readableBytes();
        if (origSize < threshold) {
            DefinedPacket.writeVarInt(origSize + 1, out);
            DefinedPacket.writeVarInt(0, out);
            out.writeBytes(in);
            return;
        }
        int uncompressed = in.readableBytes();
        DefinedPacket.write21BitVarInt(0, out);
        DefinedPacket.writeVarInt(uncompressed, out);
        ByteBuf compatibleIn = ByteBufAllocationUtils.makeCorrect(IOUtils.getByteBufAllocatorBySettings(), compressor, in);
        try {
            compressor.deflate(compatibleIn, out);
        }
        catch (DataFormatException e) {
            throw new RuntimeException(e);
        }
        finally {
            CachedPacket.releaseByteBufSafe(compatibleIn);
        }
        int writerIndex = out.writerIndex();
        int packetLength = out.readableBytes() - 3;
        out.writerIndex(0);
        DefinedPacket.write21BitVarInt(packetLength, out);
        out.writerIndex(writerIndex);
    }

    public static void releaseByteBufSafe(ByteBuf buf) {
        if (buf == null) {
            return;
        }
        if (buf.refCnt() == 0) {
            return;
        }
        buf.release();
    }
}

