/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.commands;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.shieldcommunity.nullcordx.api.config.messages.MessagesSettings;
import net.shieldcommunity.nullcordx.chat.modern.ReadyComponentMessage;
import net.shieldcommunity.nullcordx.commands.CommandNode;

public abstract class CommandNodeBungee
extends CommandNode<CommandSender, ReadyComponentMessage> {
    public static final BaseComponent[] SEP = TextComponent.fromLegacyText("\u00a7c\u00a7m--------------------------------------");
    private final String permission;

    public CommandNodeBungee(CommandNodeBungee root, String name, List<String> aliases, String permission) {
        super(root, name, aliases);
        this.permission = permission;
    }

    public CommandNodeBungee(CommandNodeBungee root, String name, String permission) {
        this(root, name, Collections.emptyList(), permission);
    }

    public CommandNodeBungee(CommandNodeBungee root, String name, List<String> aliases) {
        this(root, name, aliases, null);
    }

    public CommandNodeBungee(CommandNodeBungee root, String name) {
        this(root, name, Collections.emptyList());
    }

    public MessagesSettings getMessagesSettings(CommandSender sender) {
        return BungeeCord.getInstance().getNullCordX().getLanguageManager().getMessagesSettingsByLanguage(sender.getLanguageType());
    }

    @Override
    public void onExecuteException(CommandSender sender, String[] args, Exception e) {
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.COMMAND_EXECUTE_EXCEPTION);
        BungeeCord.getInstance().getNullCordX().getLogger().log(Level.SEVERE, "Exception during command execute", e);
    }

    @Override
    public Collection<String> onSuggestException(CommandSender sender, String[] args, Exception e) {
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.COMMAND_SUGGEST_EXCEPTION);
        BungeeCord.getInstance().getNullCordX().getLogger().log(Level.SEVERE, "Exception during command suggest", e);
        return Collections.emptyList();
    }

    @Override
    public void onPermissionFailedExecute(CommandSender sender, String[] args) {
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.DO_NOT_HAVE_PERMISSION);
    }

    @Override
    public Collection<String> onPermissionFailedSuggest(CommandSender sender, String[] args) {
        return Collections.emptyList();
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        if (this.permission == null) {
            return true;
        }
        return sender.hasPermission(this.permission);
    }

    public void sendCurrentHelp(CommandSender sender) {
        List descs = this.getDescription(sender);
        if (descs != null) {
            sender.sendMessage(SEP);
            for (ReadyComponentMessage text : descs) {
                sender.sendMessage((BaseComponent)text);
            }
            sender.sendMessage(SEP);
        }
    }

    public void sendHelp(CommandSender sender) {
        sender.sendMessage(SEP);
        sender.sendMessage(TextComponent.fromLegacyText("\u00a79\u00a7lNull\u00a7b\u00a7lCord\u00a7f\u00a7lX \u00a77\u00bb by \u00a7bshieldcommunity.net \u00a7c3.8.4"));
        sender.sendMessage(" ");
        for (ReadyComponentMessage text : this.getDescriptionListFromRoot(sender)) {
            sender.sendMessage((BaseComponent)text);
        }
        sender.sendMessage(SEP);
    }

    public static void sendPageInfo(CommandSender sender, List<String> data, int page, int pageLimit, MessagesSettings messagesSettings) {
        int newO;
        if (page <= 0) {
            sender.sendMessage((BaseComponent)messagesSettings.MESSAGES.NULLCORDX.PAGE_MUST_BE_GREATER);
            return;
        }
        int offSet = (page - 1) * pageLimit;
        if (offSet >= data.size()) {
            sender.sendMessage((BaseComponent)messagesSettings.MESSAGES.NULLCORDX.PAGE_NOT_FOUND);
            return;
        }
        int maxPage = data.size() / pageLimit + (data.size() % pageLimit > 0 ? 1 : 0);
        sender.sendMessage(SEP);
        sender.sendMessage(new BaseComponent[]{messagesSettings.MESSAGES.NULLCORDX.TOTAL_OBJECTS.replace("count", "" + data.size())});
        sender.sendMessage(new BaseComponent[]{messagesSettings.MESSAGES.NULLCORDX.CURRENT_PAGE.replace("current_page", "" + page).replace("max_page", "" + maxPage)});
        for (int i = 0; i < pageLimit && (newO = offSet + i) < data.size(); ++i) {
            sender.sendMessage(new BaseComponent[]{messagesSettings.MESSAGES.NULLCORDX.PAGE_DATA.replace("number", "" + (newO + 1)).replace("data", data.get(newO))});
        }
        sender.sendMessage(SEP);
    }
}

