/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.commands.proxy.console;

import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.shieldcommunity.nullcordx.chat.modern.ReadyComponentMessage;
import net.shieldcommunity.nullcordx.commands.CommandNodeBungee;
import net.shieldcommunity.nullcordx.utils.InetSocketUtil;

public class ConsoleBanCommand
extends CommandNodeBungee {
    public ConsoleBanCommand(CommandNodeBungee root) {
        super(root, "ban");
    }

    @Override
    public List<ReadyComponentMessage> getDescription(CommandSender sender) {
        return Collections.singletonList(this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.CONSOLE_BAN_DESCRIPTION);
    }

    @Override
    public void onExecute(CommandSender sender, String[] args) {
        if (args.length != 1) {
            this.sendCurrentHelp(sender);
            return;
        }
        String address = args[0];
        InetAddress inetAddress = InetSocketUtil.getAddressSafe(address);
        if (inetAddress == null) {
            sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.INVALID_IP_ADDRESS);
            return;
        }
        BungeeCord.getInstance().getNullCordX().getBlacklistManager().blackList(inetAddress, "executed by 'ban' command");
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.IP_ADDRESS_SUCCESSFULLY_BANNED.replace("address", address));
    }
}

