/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.commands.proxy.console;

import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.UserManagerImpl;
import net.shieldcommunity.nullcordx.api.database.CachedUserData;
import net.shieldcommunity.nullcordx.chat.modern.ReadyComponentMessage;
import net.shieldcommunity.nullcordx.commands.CommandNodeBungee;
import net.shieldcommunity.nullcordx.utils.InetSocketUtil;

public class ConsoleCachedAddCommand
extends CommandNodeBungee {
    public ConsoleCachedAddCommand(CommandNodeBungee root) {
        super(root, "add");
    }

    @Override
    public List<ReadyComponentMessage> getDescription(CommandSender sender) {
        return Collections.singletonList(this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.CONSOLE_CACHED_ADD_DESCRIPTION);
    }

    @Override
    public void onExecute(CommandSender sender, String[] args) {
        if (args.length != 2) {
            this.sendCurrentHelp(sender);
            return;
        }
        String name = args[0];
        NullCordXImpl nullCordX = BungeeCord.getInstance().getNullCordX();
        UserManagerImpl userManager = nullCordX.getUserManager();
        CachedUserData cachedUserData = userManager.getCachedUser(name);
        if (cachedUserData != null) {
            sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.USERNAME_ALREADY_CACHED.replace("user", name));
            return;
        }
        String address = args[1];
        InetAddress inetAddress = InetSocketUtil.getAddressSafe(address);
        if (inetAddress == null) {
            sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.NUMBER_PARSE_FAILED);
            return;
        }
        userManager.saveCachedUser(name, inetAddress, true);
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.SUCCESSFULLY_ADDED_CACHE.replace("user", name));
    }

    @Override
    public Collection<String> onSuggest(CommandSender sender, String[] args) {
        if (args.length != 1) {
            return Collections.emptyList();
        }
        HashSet<String> matches = new HashSet<String>();
        String search = args[0].toLowerCase();
        for (ProxiedPlayer player : BungeeCord.getInstance().getPlayers()) {
            if (!player.getName().toLowerCase().startsWith(search)) continue;
            matches.add(player.getName());
        }
        return matches;
    }
}

