/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.commands.proxy.console;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.antibot.CheckingFactoriesImpl;
import net.shieldcommunity.nullcordx.api.checking.CheckingListFactory;
import net.shieldcommunity.nullcordx.chat.modern.ReadyComponentMessage;
import net.shieldcommunity.nullcordx.commands.CommandNodeBungee;

public class ConsoleCheckCustomCommand
extends CommandNodeBungee {
    public ConsoleCheckCustomCommand(CommandNodeBungee root) {
        super(root, "custom");
    }

    @Override
    public List<ReadyComponentMessage> getDescription(CommandSender sender) {
        return Collections.singletonList(this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.CONSOLE_CHECK_CUSTOM_DESCRIPTION);
    }

    @Override
    public void onExecute(CommandSender sender, String[] args) {
        boolean bedrock;
        if (args.length != 2) {
            this.sendCurrentHelp(sender);
            return;
        }
        try {
            bedrock = Boolean.parseBoolean(args[0]);
        }
        catch (Exception e) {
            sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.BOOLEAN_PARSE_FAILED);
            return;
        }
        String name = args[1].toLowerCase(Locale.ROOT);
        NullCordXImpl nullCordX = BungeeCord.getInstance().getNullCordX();
        CheckingFactoriesImpl checkingFactories = nullCordX.getCheckingFactories();
        CheckingListFactory checkingListFactory = checkingFactories.getCustomCheckingFactoryListByName(name, bedrock);
        if (checkingListFactory == null) {
            sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.FAILED_FIND_CUSTOM_CHECK.replace("check", name));
            return;
        }
        checkingFactories.setCustomCheckingFactoryListByType(checkingListFactory, bedrock);
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.CUSTOM_MODE_SET.replace("check", name));
    }

    @Override
    public Collection<String> onSuggest(CommandSender sender, String[] args) {
        if (args.length == 1) {
            HashSet<String> matches = new HashSet<String>();
            String search = args[0].toLowerCase(Locale.ROOT);
            for (String data : Arrays.asList("true", "false")) {
                if (!data.toLowerCase(Locale.ROOT).startsWith(search)) continue;
                matches.add(data);
            }
            return matches;
        }
        if (args.length == 2) {
            boolean bedrock;
            try {
                bedrock = Boolean.parseBoolean(args[0]);
            }
            catch (Exception e) {
                return Collections.emptyList();
            }
            return ConsoleCheckCustomCommand.getCheckingFactoriesMatches(args, bedrock);
        }
        return Collections.emptyList();
    }

    private static Set<String> getCheckingFactoriesMatches(String[] args, boolean bedrock) {
        CheckingFactoriesImpl checkingFactories = BungeeCord.getInstance().getNullCordX().getCheckingFactories();
        Map<String, CheckingListFactory> factories = bedrock ? checkingFactories.getCustomCheckingFactoriesForBedrock() : checkingFactories.getCustomCheckingFactoriesForJava();
        HashSet<String> matches = new HashSet<String>();
        String search = args[1].toLowerCase(Locale.ROOT);
        for (String data : factories.keySet()) {
            if (!data.toLowerCase(Locale.ROOT).startsWith(search)) continue;
            matches.add(data);
        }
        return matches;
    }
}

