/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.commands.proxy.console;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.shieldcommunity.nullcordx.chat.modern.ReadyComponentMessage;
import net.shieldcommunity.nullcordx.commands.CommandNodeBungee;
import net.shieldcommunity.nullcordx.dump.MainDump;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.ObjectMapper;
import net.shieldcommunity.nullcordx.utils.HttpUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;

public class ConsoleDumpCommand
extends CommandNodeBungee {
    private static final String DUMP_URL = "https://dumps.shieldcommunity.net/";
    private static final String API_VERSION = "v2/";
    private final Logger logger;

    public ConsoleDumpCommand(CommandNodeBungee root, Logger logger) {
        super(root, "dump");
        this.logger = logger;
    }

    @Override
    public List<ReadyComponentMessage> getDescription(CommandSender sender) {
        return Collections.singletonList(this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.CONSOLE_DUMP_DESCRIPTION);
    }

    @Override
    public void onExecute(CommandSender sender, String[] args) {
        if (args.length != 0) {
            this.sendCurrentHelp(sender);
            return;
        }
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.START_COLLECT_INFORMATION);
        Thread thread = new Thread(() -> {
            block16: {
                try {
                    sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.COLLECT_SYSTEM_INFORMATION);
                    String parsedData = new ObjectMapper().writeValueAsString(new MainDump());
                    sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.SENDING_DUMP);
                    URI uri = URI.create("https://dumps.shieldcommunity.net/api/v2/upload");
                    HttpPost httpPost = new HttpPost(uri);
                    httpPost.setEntity(new StringEntity(parsedData));
                    httpPost.setHeader("Content-Type", "application/json");
                    httpPost.setHeader("User-Agent", "NullCordX-3.8.4");
                    try (HttpUtils.HttpByteArrayInputStream inputStream = HttpUtils.makeRequest(httpPost, 10000);){
                        int code = inputStream.getCode();
                        if (code != 200) {
                            if (code == 429) {
                                throw new IOException("You can only upload per 5 minutes");
                            }
                            throw new IOException("Expected response code 200 (HTTP_OK) but received: " + code + ": '" + inputStream.getTextResponse() + "'");
                        }
                        try (JsonReader reader = new Gson().newJsonReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));){
                            JsonElement element = JsonParser.parseReader(reader);
                            String responseKey = element.getAsJsonObject().get("key").getAsString();
                            sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.DUMP_UPLOADED.replace("url", "https://dumps.shieldcommunity.net/v2/" + responseKey));
                        }
                    }
                }
                catch (Exception e) {
                    sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.DUMP_FAILED.replace("error", e.getClass().getSimpleName() + ": " + e.getMessage()));
                    if (!BungeeCord.getInstance().getNullCordX().canSendDebugLog()) break block16;
                    this.logger.log(Level.SEVERE, "Failed to send dump", e);
                }
            }
        });
        thread.start();
    }
}

