/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.commands.proxy.console;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.shieldcommunity.nullcordx.NullCordXException;
import net.shieldcommunity.nullcordx.chat.modern.ReadyComponentMessage;
import net.shieldcommunity.nullcordx.commands.CommandNodeBungee;

public class ConsoleReloadCommand
extends CommandNodeBungee {
    private final Logger logger;

    public ConsoleReloadCommand(CommandNodeBungee root, Logger logger) {
        super(root, "reload");
        this.logger = logger;
    }

    @Override
    public List<ReadyComponentMessage> getDescription(CommandSender sender) {
        return Collections.singletonList(this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.CONSOLE_RELOAD_DESCRIPTION);
    }

    @Override
    public void onExecute(CommandSender sender, String[] args) {
        if (args.length != 0) {
            this.sendCurrentHelp(sender);
            return;
        }
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.TRYING_RELOAD);
        Thread nullCordXThread = new Thread(() -> {
            try {
                BungeeCord.getInstance().reloadNullCordX();
                sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.SUCCESSFULLY_RELOADED);
            }
            catch (NullCordXException e) {
                sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.FAILED_RELOAD.replace("error", e.getMessage()));
            }
            catch (Throwable e) {
                sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.FATAL_ERROR_RELOAD);
                this.logger.log(Level.SEVERE, "Failed to reload", e);
            }
        });
        nullCordXThread.setName("NullCordX-reload");
        nullCordXThread.start();
    }
}

