/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.commands.proxy.console;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.shieldcommunity.nullcordx.cache.CachedPacket;
import net.shieldcommunity.nullcordx.chat.modern.ReadyComponentMessage;
import net.shieldcommunity.nullcordx.commands.CommandNodeBungee;
import net.shieldcommunity.nullcordx.natives.CompressionType;
import net.shieldcommunity.nullcordx.natives.Natives;
import net.shieldcommunity.nullcordx.natives.compression.Compressor;
import net.shieldcommunity.nullcordx.natives.compression.CompressorFactory;
import net.shieldcommunity.nullcordx.natives.compression.Decompressor;
import net.shieldcommunity.nullcordx.statistics.StatisticsManagerImpl;

public class ConsoleTestCompressionCommand
extends CommandNodeBungee {
    private final Logger logger;

    public ConsoleTestCompressionCommand(CommandNodeBungee root, Logger logger) {
        super(root, "testcompression");
        this.logger = logger;
    }

    @Override
    public List<ReadyComponentMessage> getDescription(CommandSender sender) {
        return Collections.singletonList(this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.CONSOLE_TEST_COMPRESSION_DESCRIPTION);
    }

    @Override
    public void onExecute(CommandSender sender, String[] args) {
        int level;
        if (args.length != 1) {
            this.sendCurrentHelp(sender);
            return;
        }
        try {
            level = Integer.parseInt(args[0]);
        }
        catch (Exception e) {
            sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.NUMBER_PARSE_FAILED);
            return;
        }
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.TEST_COMPRESSION_STARTED);
        Thread thread = new Thread(() -> {
            long start = System.currentTimeMillis();
            Random random = new Random();
            List<ByteBuf> uncompressedBuffs = this.createRandomByteBufs(random);
            try {
                CompressorFactory defaultFactory = Natives.loadCompression(CompressionType.JAVA);
                try (Compressor compressor = defaultFactory.createCompressor(level);){
                    List<CompressionData> compressedBuffs = this.createCompressedByteBufs(compressor, uncompressedBuffs);
                    try {
                        HashSet<CompressorFactory> factories = new HashSet<CompressorFactory>();
                        for (CompressionType compressionType : CompressionType.values()) {
                            factories.add(Natives.loadCompression(compressionType));
                        }
                        ExecutorService executor = Executors.newSingleThreadExecutor();
                        try {
                            for (CompressorFactory compressorFactory : factories) {
                                sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.TEST_COMPRESSION_TEST.replace("type", compressorFactory.getName()));
                                CompressionResult compressionResult = executor.submit(new CompressionCounterTask(uncompressedBuffs, compressedBuffs, level, compressorFactory)).get();
                                sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.TEST_COMPRESSION_RESULT.replace("type", compressorFactory.getName()).replace("compression", StatisticsManagerImpl.bytesIntoHumanReadable(compressionResult.getCompressedBytes()) + " (OP: " + compressionResult.getCompressedOperations() + ")").replace("decompression", StatisticsManagerImpl.bytesIntoHumanReadable(compressionResult.getDecompressedBytes()) + " (OP: " + compressionResult.getDecompressedOperations() + ")"));
                            }
                            long end = System.currentTimeMillis();
                            sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.TEST_COMPRESSION_FINISH.replace("time", "" + (end - start)));
                            executor.shutdownNow();
                        }
                        catch (Exception e) {
                            try {
                                this.logger.log(Level.SEVERE, "Failed to test compression", e);
                                executor.shutdownNow();
                            }
                            catch (Throwable throwable) {
                                executor.shutdownNow();
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        for (CompressionData compressionData : compressedBuffs) {
                            CachedPacket.releaseByteBufSafe(compressionData.getBuf());
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "Failed to compress", e);
                }
            }
            finally {
                for (ByteBuf buf : uncompressedBuffs) {
                    CachedPacket.releaseByteBufSafe(buf);
                }
            }
        });
        thread.start();
    }

    private List<ByteBuf> createRandomByteBufs(Random random) {
        ArrayList<ByteBuf> tmp = new ArrayList<ByteBuf>();
        for (int i = 0; i < 2048; ++i) {
            int randomSize = random.nextInt(131072) + 1;
            ByteBuf byteBuf = ByteBufAllocator.DEFAULT.directBuffer(randomSize);
            for (int k = 0; k < randomSize; ++k) {
                byteBuf.writeByte(random.nextInt());
            }
            tmp.add(byteBuf);
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CompressionData> createCompressedByteBufs(Compressor compressor, List<ByteBuf> byteBufs) throws DataFormatException {
        ArrayList<CompressionData> tmp = new ArrayList<CompressionData>();
        for (ByteBuf uncompressed : byteBufs) {
            int uncompressedSize = uncompressed.readableBytes();
            ByteBuf compressedTest = ByteBufAllocator.DEFAULT.directBuffer(uncompressedSize);
            ByteBuf newUncompressed = uncompressed.retainedDuplicate();
            try {
                compressor.deflate(newUncompressed, compressedTest);
                tmp.add(new CompressionData(compressedTest, uncompressedSize));
            }
            finally {
                CachedPacket.releaseByteBufSafe(newUncompressed);
            }
        }
        return tmp;
    }

    private static final class CompressionData {
        private final ByteBuf buf;
        private final int uncompressedSize;

        public CompressionData(ByteBuf buf, int uncompressedSize) {
            this.buf = buf;
            this.uncompressedSize = uncompressedSize;
        }

        public ByteBuf getBuf() {
            return this.buf;
        }

        public int getUncompressedSize() {
            return this.uncompressedSize;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompressionData)) {
                return false;
            }
            CompressionData other = (CompressionData)o;
            if (this.getUncompressedSize() != other.getUncompressedSize()) {
                return false;
            }
            ByteBuf this$buf = this.getBuf();
            ByteBuf other$buf = other.getBuf();
            return !(this$buf == null ? other$buf != null : !((Object)this$buf).equals(other$buf));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getUncompressedSize();
            ByteBuf $buf = this.getBuf();
            result = result * 59 + ($buf == null ? 43 : ((Object)$buf).hashCode());
            return result;
        }

        public String toString() {
            return "ConsoleTestCompressionCommand.CompressionData(buf=" + this.getBuf() + ", uncompressedSize=" + this.getUncompressedSize() + ")";
        }
    }

    private static class CompressionCounterTask
    implements Callable<CompressionResult> {
        private final List<ByteBuf> uncompressed;
        private final List<CompressionData> compressed;
        private final int level;
        private final CompressorFactory compressorFactory;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompressionResult call() throws Exception {
            long averageDecompressedOperations;
            long averageDecompressedBytes;
            long averageCompressedOperations;
            long averageCompressedBytes;
            CompressionTestTask compressionTestTask = new CompressionTestTask(this.uncompressed, this.compressorFactory, this.level);
            try {
                Thread compressionThread = new Thread(compressionTestTask);
                compressionThread.start();
                long compressedBytes = 0L;
                long compressedOperations = 0L;
                long count = 0L;
                for (int i = 0; i < 10; ++i) {
                    Thread.sleep(1000L);
                    compressedBytes += compressionTestTask.getBytes();
                    compressedOperations += compressionTestTask.getOperations();
                    compressionTestTask.setBytes(0L);
                    compressionTestTask.setOperations(0L);
                    ++count;
                }
                averageCompressedBytes = compressedBytes / count;
                averageCompressedOperations = compressedOperations / count;
            }
            finally {
                compressionTestTask.setFinished(true);
            }
            DecompressionTestTask decompressionTestTask = new DecompressionTestTask(this.compressed, this.compressorFactory);
            try {
                Thread decompressionThread = new Thread(decompressionTestTask);
                decompressionThread.start();
                long decompressedBytes = 0L;
                long decompressedOperations = 0L;
                long count = 0L;
                for (int i = 0; i < 10; ++i) {
                    Thread.sleep(1000L);
                    decompressedBytes += decompressionTestTask.getBytes();
                    decompressedOperations += decompressionTestTask.getOperations();
                    decompressionTestTask.setBytes(0L);
                    decompressionTestTask.setOperations(0L);
                    ++count;
                }
                averageDecompressedBytes = decompressedBytes / count;
                averageDecompressedOperations = decompressedOperations / count;
            }
            finally {
                decompressionTestTask.setFinished(true);
            }
            return new CompressionResult(averageCompressedBytes, averageCompressedOperations, averageDecompressedBytes, averageDecompressedOperations);
        }

        public CompressionCounterTask(List<ByteBuf> uncompressed, List<CompressionData> compressed, int level, CompressorFactory compressorFactory) {
            this.uncompressed = uncompressed;
            this.compressed = compressed;
            this.level = level;
            this.compressorFactory = compressorFactory;
        }
    }

    private static final class CompressionResult {
        private final long compressedBytes;
        private final long compressedOperations;
        private final long decompressedBytes;
        private final long decompressedOperations;

        public CompressionResult(long compressedBytes, long compressedOperations, long decompressedBytes, long decompressedOperations) {
            this.compressedBytes = compressedBytes;
            this.compressedOperations = compressedOperations;
            this.decompressedBytes = decompressedBytes;
            this.decompressedOperations = decompressedOperations;
        }

        public long getCompressedBytes() {
            return this.compressedBytes;
        }

        public long getCompressedOperations() {
            return this.compressedOperations;
        }

        public long getDecompressedBytes() {
            return this.decompressedBytes;
        }

        public long getDecompressedOperations() {
            return this.decompressedOperations;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompressionResult)) {
                return false;
            }
            CompressionResult other = (CompressionResult)o;
            if (this.getCompressedBytes() != other.getCompressedBytes()) {
                return false;
            }
            if (this.getCompressedOperations() != other.getCompressedOperations()) {
                return false;
            }
            if (this.getDecompressedBytes() != other.getDecompressedBytes()) {
                return false;
            }
            return this.getDecompressedOperations() == other.getDecompressedOperations();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $compressedBytes = this.getCompressedBytes();
            result = result * 59 + (int)($compressedBytes >>> 32 ^ $compressedBytes);
            long $compressedOperations = this.getCompressedOperations();
            result = result * 59 + (int)($compressedOperations >>> 32 ^ $compressedOperations);
            long $decompressedBytes = this.getDecompressedBytes();
            result = result * 59 + (int)($decompressedBytes >>> 32 ^ $decompressedBytes);
            long $decompressedOperations = this.getDecompressedOperations();
            result = result * 59 + (int)($decompressedOperations >>> 32 ^ $decompressedOperations);
            return result;
        }

        public String toString() {
            return "ConsoleTestCompressionCommand.CompressionResult(compressedBytes=" + this.getCompressedBytes() + ", compressedOperations=" + this.getCompressedOperations() + ", decompressedBytes=" + this.getDecompressedBytes() + ", decompressedOperations=" + this.getDecompressedOperations() + ")";
        }
    }

    private static class DecompressionTestTask
    implements Runnable {
        private final List<CompressionData> buffs;
        private final CompressorFactory compressorFactory;
        private boolean finished = false;
        private long bytes = 0L;
        private long operations = 0L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Random random = new Random();
            try (Decompressor decompressor = this.compressorFactory.createDecompressor();){
                while (!this.finished) {
                    CompressionData compressionData = this.buffs.get(random.nextInt(this.buffs.size()));
                    ByteBuf compressed = compressionData.getBuf().retainedDuplicate();
                    int size = compressionData.getUncompressedSize();
                    int compressedSize = compressed.readableBytes();
                    try {
                        ByteBuf uncompressedOut = ByteBufAllocator.DEFAULT.directBuffer(size);
                        try {
                            decompressor.inflate(compressed, uncompressedOut, size);
                            this.bytes += (long)compressedSize;
                            ++this.operations;
                        }
                        finally {
                            CachedPacket.releaseByteBufSafe(uncompressedOut);
                        }
                    }
                    finally {
                        CachedPacket.releaseByteBufSafe(compressed);
                    }
                }
            }
        }

        public DecompressionTestTask(List<CompressionData> buffs, CompressorFactory compressorFactory) {
            this.buffs = buffs;
            this.compressorFactory = compressorFactory;
        }

        public List<CompressionData> getBuffs() {
            return this.buffs;
        }

        public CompressorFactory getCompressorFactory() {
            return this.compressorFactory;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public long getBytes() {
            return this.bytes;
        }

        public long getOperations() {
            return this.operations;
        }

        public void setFinished(boolean finished) {
            this.finished = finished;
        }

        public void setBytes(long bytes) {
            this.bytes = bytes;
        }

        public void setOperations(long operations) {
            this.operations = operations;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DecompressionTestTask)) {
                return false;
            }
            DecompressionTestTask other = (DecompressionTestTask)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isFinished() != other.isFinished()) {
                return false;
            }
            if (this.getBytes() != other.getBytes()) {
                return false;
            }
            if (this.getOperations() != other.getOperations()) {
                return false;
            }
            List<CompressionData> this$buffs = this.getBuffs();
            List<CompressionData> other$buffs = other.getBuffs();
            if (this$buffs == null ? other$buffs != null : !((Object)this$buffs).equals(other$buffs)) {
                return false;
            }
            CompressorFactory this$compressorFactory = this.getCompressorFactory();
            CompressorFactory other$compressorFactory = other.getCompressorFactory();
            return !(this$compressorFactory == null ? other$compressorFactory != null : !this$compressorFactory.equals(other$compressorFactory));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DecompressionTestTask;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isFinished() ? 79 : 97);
            long $bytes = this.getBytes();
            result = result * 59 + (int)($bytes >>> 32 ^ $bytes);
            long $operations = this.getOperations();
            result = result * 59 + (int)($operations >>> 32 ^ $operations);
            List<CompressionData> $buffs = this.getBuffs();
            result = result * 59 + ($buffs == null ? 43 : ((Object)$buffs).hashCode());
            CompressorFactory $compressorFactory = this.getCompressorFactory();
            result = result * 59 + ($compressorFactory == null ? 43 : $compressorFactory.hashCode());
            return result;
        }

        public String toString() {
            return "ConsoleTestCompressionCommand.DecompressionTestTask(buffs=" + this.getBuffs() + ", compressorFactory=" + this.getCompressorFactory() + ", finished=" + this.isFinished() + ", bytes=" + this.getBytes() + ", operations=" + this.getOperations() + ")";
        }
    }

    private static class CompressionTestTask
    implements Runnable {
        private final List<ByteBuf> buffs;
        private final CompressorFactory compressorFactory;
        private final int level;
        private boolean finished = false;
        private long bytes = 0L;
        private long operations = 0L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Random random = new Random();
            try (Compressor compressor = this.compressorFactory.createCompressor(this.level);){
                while (!this.finished) {
                    ByteBuf uncompressed = this.buffs.get(random.nextInt(this.buffs.size())).retainedDuplicate();
                    try {
                        ByteBuf compressedOut = ByteBufAllocator.DEFAULT.directBuffer(uncompressed.readableBytes());
                        try {
                            compressor.deflate(uncompressed, compressedOut);
                            this.bytes += (long)compressedOut.readableBytes();
                            ++this.operations;
                        }
                        finally {
                            CachedPacket.releaseByteBufSafe(compressedOut);
                        }
                    }
                    finally {
                        CachedPacket.releaseByteBufSafe(uncompressed);
                    }
                }
            }
        }

        public CompressionTestTask(List<ByteBuf> buffs, CompressorFactory compressorFactory, int level) {
            this.buffs = buffs;
            this.compressorFactory = compressorFactory;
            this.level = level;
        }

        public List<ByteBuf> getBuffs() {
            return this.buffs;
        }

        public CompressorFactory getCompressorFactory() {
            return this.compressorFactory;
        }

        public int getLevel() {
            return this.level;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public long getBytes() {
            return this.bytes;
        }

        public long getOperations() {
            return this.operations;
        }

        public void setFinished(boolean finished) {
            this.finished = finished;
        }

        public void setBytes(long bytes) {
            this.bytes = bytes;
        }

        public void setOperations(long operations) {
            this.operations = operations;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompressionTestTask)) {
                return false;
            }
            CompressionTestTask other = (CompressionTestTask)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLevel() != other.getLevel()) {
                return false;
            }
            if (this.isFinished() != other.isFinished()) {
                return false;
            }
            if (this.getBytes() != other.getBytes()) {
                return false;
            }
            if (this.getOperations() != other.getOperations()) {
                return false;
            }
            List<ByteBuf> this$buffs = this.getBuffs();
            List<ByteBuf> other$buffs = other.getBuffs();
            if (this$buffs == null ? other$buffs != null : !((Object)this$buffs).equals(other$buffs)) {
                return false;
            }
            CompressorFactory this$compressorFactory = this.getCompressorFactory();
            CompressorFactory other$compressorFactory = other.getCompressorFactory();
            return !(this$compressorFactory == null ? other$compressorFactory != null : !this$compressorFactory.equals(other$compressorFactory));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CompressionTestTask;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLevel();
            result = result * 59 + (this.isFinished() ? 79 : 97);
            long $bytes = this.getBytes();
            result = result * 59 + (int)($bytes >>> 32 ^ $bytes);
            long $operations = this.getOperations();
            result = result * 59 + (int)($operations >>> 32 ^ $operations);
            List<ByteBuf> $buffs = this.getBuffs();
            result = result * 59 + ($buffs == null ? 43 : ((Object)$buffs).hashCode());
            CompressorFactory $compressorFactory = this.getCompressorFactory();
            result = result * 59 + ($compressorFactory == null ? 43 : $compressorFactory.hashCode());
            return result;
        }

        public String toString() {
            return "ConsoleTestCompressionCommand.CompressionTestTask(buffs=" + this.getBuffs() + ", compressorFactory=" + this.getCompressorFactory() + ", level=" + this.getLevel() + ", finished=" + this.isFinished() + ", bytes=" + this.getBytes() + ", operations=" + this.getOperations() + ")";
        }
    }
}

