/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.commands.proxy.console;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.CommandSender;
import net.shieldcommunity.nullcordx.api.config.messages.MessagesSettings;
import net.shieldcommunity.nullcordx.api.database.WhitelistedUserData;
import net.shieldcommunity.nullcordx.chat.modern.ReadyComponentMessage;
import net.shieldcommunity.nullcordx.commands.CommandNodeBungee;
import net.shieldcommunity.nullcordx.commands.proxy.console.ConsoleWhiteListAddCommand;
import net.shieldcommunity.nullcordx.commands.proxy.console.ConsoleWhiteListPageCommand;
import net.shieldcommunity.nullcordx.commands.proxy.console.ConsoleWhiteListRemoveCommand;

public class ConsoleWhiteListCommand
extends CommandNodeBungee {
    public ConsoleWhiteListCommand(CommandNodeBungee root) {
        super(root, "whitelist");
        this.addNode(new ConsoleWhiteListPageCommand(root));
        this.addNode(new ConsoleWhiteListAddCommand(root));
        this.addNode(new ConsoleWhiteListRemoveCommand(root));
    }

    @Override
    public List<ReadyComponentMessage> getDescription(CommandSender sender) {
        return Collections.singletonList(this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.CONSOLE_WHITELIST_DESCRIPTION);
    }

    @Override
    public void onExecute(CommandSender sender, String[] args) {
        if (args.length != 0) {
            this.sendCurrentHelp(sender);
            return;
        }
        ConsoleWhiteListCommand.sendWhiteListList(sender, 1, this.getMessagesSettings(sender));
    }

    public static void sendWhiteListList(CommandSender sender, int page, MessagesSettings messagesSettings) {
        TreeSet<WhitelistedUserData> whitelistedUserDataCollection = new TreeSet<WhitelistedUserData>(BungeeCord.getInstance().getNullCordX().getUserManager().getAllWhitelistedPlayers());
        ArrayList<String> players = new ArrayList<String>();
        for (WhitelistedUserData data : whitelistedUserDataCollection) {
            players.add(data.getName());
        }
        ConsoleWhiteListCommand.sendPageInfo(sender, players, page, 20, messagesSettings);
    }
}

