/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.commands.proxy.player;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.shieldcommunity.nullcordx.chat.modern.ReadyComponentMessage;
import net.shieldcommunity.nullcordx.commands.CommandNodeBungee;
import net.shieldcommunity.nullcordx.statistics.LiveStatsType;
import net.shieldcommunity.nullcordx.statistics.PlayerLiveStatsData;
import net.shieldcommunity.nullcordx.statistics.PlayerStatisticsUpdaterManager;

public class PlayerLiveStatsCommand
extends CommandNodeBungee {
    private final LiveStatsType liveStatsType;

    public PlayerLiveStatsCommand(CommandNodeBungee root, LiveStatsType liveStatsType) {
        super(root, liveStatsType.name().toLowerCase(Locale.ROOT), "nullcordx.player.livestats." + liveStatsType.name().toLowerCase(Locale.ROOT));
        this.liveStatsType = liveStatsType;
    }

    @Override
    public List<ReadyComponentMessage> getDescription(CommandSender sender) {
        return Collections.singletonList(this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.PLAYER_LIVE_STATS_DESCRIPTION.replace("type", this.liveStatsType.name().toLowerCase(Locale.ROOT)));
    }

    @Override
    public void onExecute(CommandSender sender, String[] args) {
        if (args.length != 0) {
            this.sendCurrentHelp(sender);
            return;
        }
        PlayerStatisticsUpdaterManager playerStatisticsUpdaterManager = BungeeCord.getInstance().getNullCordX().getPlayerStatisticsUpdaterManager();
        PlayerLiveStatsData tmp = playerStatisticsUpdaterManager.getPlayer(sender.getName());
        if (tmp == null) {
            tmp = playerStatisticsUpdaterManager.addPlayer((ProxiedPlayer)sender);
        }
        tmp.setType(this.liveStatsType);
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.LIVE_STATS_CHANGED.replace("type", this.liveStatsType.name().toLowerCase(Locale.ROOT)));
    }
}

