/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.config;

import java.net.InetAddress;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.shieldcommunity.nullcordx.libs.apache.commons.net.util.SubnetUtils;
import net.shieldcommunity.nullcordx.utils.InetAddressSet;
import net.shieldcommunity.nullcordx.utils.InetSocketUtil;

public class IpAddresses {
    private final List<String> originalList;

    public IpAddresses(List<String> originalList) {
        this.originalList = originalList;
    }

    public InetAddressSet calculateAddresses(Logger logger, String name) {
        logger.log(Level.INFO, "Loading " + name + "...");
        long start = System.currentTimeMillis();
        InetAddressSet inetAddressSet = new InetAddressSet();
        for (String address : this.originalList) {
            String[] split = address.split("/");
            if (split.length != 2) {
                InetAddress inetAddress = InetSocketUtil.getAddressSafe(address);
                if (inetAddress == null) {
                    logger.log(Level.WARNING, "Failed to parse ip address '" + address + "' for " + name + "!");
                    continue;
                }
                inetAddressSet.add(inetAddress);
                continue;
            }
            String sameAddress = split[0];
            if (!InetSocketUtil.isIPv4(sameAddress)) {
                logger.log(Level.WARNING, "Ip address '" + sameAddress + "' should be an IPv4 for " + name + "!");
                continue;
            }
            try {
                SubnetUtils subnetUtils = new SubnetUtils(address);
                for (String subnet : subnetUtils.getInfo().getAllAddresses()) {
                    InetAddress inetAddress = InetSocketUtil.getAddressSafe(subnet);
                    if (inetAddress == null) continue;
                    inetAddressSet.add(inetAddress);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to parse addresses for " + name, e);
            }
        }
        long end = System.currentTimeMillis();
        logger.log(Level.INFO, "Found " + inetAddressSet.size() + " addresses for " + name + " in " + (end - start) + "ms");
        return inetAddressSet;
    }

    public List<String> getOriginalList() {
        return this.originalList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IpAddresses)) {
            return false;
        }
        IpAddresses other = (IpAddresses)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$originalList = this.getOriginalList();
        List<String> other$originalList = other.getOriginalList();
        return !(this$originalList == null ? other$originalList != null : !((Object)this$originalList).equals(other$originalList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IpAddresses;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $originalList = this.getOriginalList();
        result = result * 59 + ($originalList == null ? 43 : ((Object)$originalList).hashCode());
        return result;
    }

    public String toString() {
        return "IpAddresses(originalList=" + this.getOriginalList() + ")";
    }
}

