/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.config.captcha;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.shieldcommunity.nullcordx.config.SafeYamlSerializable;
import net.shieldcommunity.nullcordx.config.serializers.ReadyComponentMessageSerializer;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.NameStyle;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.SerializerConfig;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.CollectionType;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.Comment;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.CommentValue;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.NewLine;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.Transient;

public class HandCaptchaSettings
extends SafeYamlSerializable {
    @Transient
    private static final SerializerConfig CONFIG = new SerializerConfig.Builder().setCommentValueIndent(1).setFieldNameStyle(NameStyle.MACRO_CASE).setNodeNameStyle(NameStyle.KEBAB_CASE).registerSerializer(new ReadyComponentMessageSerializer()).build();
    @Transient
    public static final HandCaptchaSettings IMP = new HandCaptchaSettings();
    public HAND_CAPTCHA HAND_CAPTCHA = new HAND_CAPTCHA();
    public long CONFIG_VERSION = 1L;

    public HandCaptchaSettings() {
        super(Paths.get("NullCordX/captcha/hand-captcha.yml", new String[0]), CONFIG);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HandCaptchaSettings)) {
            return false;
        }
        HandCaptchaSettings other = (HandCaptchaSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.CONFIG_VERSION != other.CONFIG_VERSION) {
            return false;
        }
        HAND_CAPTCHA this$HAND_CAPTCHA = this.HAND_CAPTCHA;
        HAND_CAPTCHA other$HAND_CAPTCHA = other.HAND_CAPTCHA;
        return !(this$HAND_CAPTCHA == null ? other$HAND_CAPTCHA != null : !((Object)this$HAND_CAPTCHA).equals(other$HAND_CAPTCHA));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HandCaptchaSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $CONFIG_VERSION = this.CONFIG_VERSION;
        result = result * 59 + (int)($CONFIG_VERSION >>> 32 ^ $CONFIG_VERSION);
        HAND_CAPTCHA $HAND_CAPTCHA = this.HAND_CAPTCHA;
        result = result * 59 + ($HAND_CAPTCHA == null ? 43 : ((Object)$HAND_CAPTCHA).hashCode());
        return result;
    }

    @Comment(value={@CommentValue(value="Configuration for hand captcha")})
    public static class HAND_CAPTCHA {
        @Comment(value={@CommentValue(value="How many hand captcha images to generate. A large number can take up a lot of RAM."), @CommentValue(value="If network_compression_threshold is -1 or the packet compression level is too low, the hand captcha can take up a lot of RAM."), @CommentValue(value="A large number of hand captcha is more difficult for an attacker to remember to solve on their own.")})
        public int IMAGES_COUNT = 1500;
        @NewLine
        @Comment(value={@CommentValue(value="Configuration for render layers groups."), @CommentValue, @CommentValue(value="What is it and how does it work?"), @CommentValue(value="Render layer groups are the sequence of drawing elements on an image."), @CommentValue(value="For example, to draw a background image and glyphs on it, you first need to draw the background and then the glyphs,"), @CommentValue(value="if you do otherwise, the background will redraw the glyphs and you will not see them."), @CommentValue, @CommentValue(value="Why are these groups?"), @CommentValue(value="Each group is drawn separately to then merge them into one."), @CommentValue(value="This approach will allow, for example, to make specific glyphs with a gradient without affecting the background, since it is in a different group."), @CommentValue, @CommentValue(value="Use this character to separate layer: '>'"), @CommentValue(value="To create a new group just make a new element. For example: - \"Code>Curve\" "), @CommentValue, @CommentValue(value="See render-layer-templates to see or customize the current layer templates."), @CommentValue(value="You can add as many layers as you want and in any order you want.")})
        @CollectionType(value=ArrayList.class)
        public List<String> RENDER_LAYER_GROUPS = Arrays.asList("Hand-image>Ripple>Mirror", "Code>Curve>Hand-gradient>Ripple");
        @NewLine
        @Comment(value={@CommentValue(value="Configuration for post renders layers."), @CommentValue, @CommentValue(value="Same as render-layers-group, except that all specified layers will be applied to the rendered image after all groups have been merged."), @CommentValue(value="Useful if you need to overlay ripple or dithering on the finished image and not on each group separately."), @CommentValue(value="Disabled if empty.")})
        public String POST_RENDER = "Dithering";

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HAND_CAPTCHA)) {
                return false;
            }
            HAND_CAPTCHA other = (HAND_CAPTCHA)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.IMAGES_COUNT != other.IMAGES_COUNT) {
                return false;
            }
            List<String> this$RENDER_LAYER_GROUPS = this.RENDER_LAYER_GROUPS;
            List<String> other$RENDER_LAYER_GROUPS = other.RENDER_LAYER_GROUPS;
            if (this$RENDER_LAYER_GROUPS == null ? other$RENDER_LAYER_GROUPS != null : !((Object)this$RENDER_LAYER_GROUPS).equals(other$RENDER_LAYER_GROUPS)) {
                return false;
            }
            String this$POST_RENDER = this.POST_RENDER;
            String other$POST_RENDER = other.POST_RENDER;
            return !(this$POST_RENDER == null ? other$POST_RENDER != null : !this$POST_RENDER.equals(other$POST_RENDER));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HAND_CAPTCHA;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.IMAGES_COUNT;
            List<String> $RENDER_LAYER_GROUPS = this.RENDER_LAYER_GROUPS;
            result = result * 59 + ($RENDER_LAYER_GROUPS == null ? 43 : ((Object)$RENDER_LAYER_GROUPS).hashCode());
            String $POST_RENDER = this.POST_RENDER;
            result = result * 59 + ($POST_RENDER == null ? 43 : $POST_RENDER.hashCode());
            return result;
        }
    }
}

