/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.dump;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.BungeeCord;
import net.shieldcommunity.nullcordx.api.config.messages.MessagesSettings;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.config.CaptchaSettings;
import net.shieldcommunity.nullcordx.config.ConfigSettings;
import net.shieldcommunity.nullcordx.config.MotdSettings;
import net.shieldcommunity.nullcordx.config.SQLSettings;
import net.shieldcommunity.nullcordx.config.bungee.BungeeCordSettings;
import net.shieldcommunity.nullcordx.config.bungee.WaterfallSettings;
import net.shieldcommunity.nullcordx.dump.MessagesConfig;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.language.object.YamlSerializable;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.language.writer.JsonWriter;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.core.type.TypeReference;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.ObjectMapper;
import net.shieldcommunity.nullcordx.utils.InetSocketUtil;

public class ConfigsInfo {
    private final Map<String, Object> bungeecordConfig = ConfigsInfo.hideValuesFromJson(ConfigsInfo.parseJsonMapFromConfig(BungeeCordSettings.IMP));
    private final Map<String, Object> waterfallConfig = ConfigsInfo.hideValuesFromJson(ConfigsInfo.parseJsonMapFromConfig(WaterfallSettings.IMP));
    private final Map<String, Object> nullcordxConfig = ConfigsInfo.hideValuesFromJson(ConfigsInfo.parseJsonMapFromConfig(ConfigSettings.IMP));
    private final Map<String, Object> antibotConfig = ConfigsInfo.hideValuesFromJson(ConfigsInfo.parseJsonMapFromConfig(AntibotSettings.IMP));
    private final Map<String, Object> captchaConfig = ConfigsInfo.hideValuesFromJson(ConfigsInfo.parseJsonMapFromConfig(CaptchaSettings.IMP));
    private final Map<String, Object> motdConfig = ConfigsInfo.hideValuesFromJson(ConfigsInfo.parseJsonMapFromConfig(MotdSettings.IMP));
    private final Map<String, Object> sqlConfig = ConfigsInfo.hideValuesFromJson(ConfigsInfo.parseJsonMapFromConfig(SQLSettings.IMP));
    private final List<MessagesConfig> messagesConfig;

    public ConfigsInfo() {
        ArrayList<MessagesConfig> messagesConfigs = new ArrayList<MessagesConfig>();
        for (MessagesSettings messagesSettings : BungeeCord.getInstance().getNullCordX().getLanguageManager().getAllMessagesSettings()) {
            messagesConfigs.add(new MessagesConfig(messagesSettings));
        }
        this.messagesConfig = messagesConfigs;
    }

    private static Map<String, Object> hideValuesFromJson(Map<String, Object> data) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            String modifiedJson = mapper.writeValueAsString(data);
            modifiedJson = ConfigsInfo.hideValue(modifiedJson, "your-license");
            modifiedJson = ConfigsInfo.hideValue(modifiedJson, "forwarding_secret");
            modifiedJson = ConfigsInfo.hideValue(modifiedJson, "license-key");
            modifiedJson = ConfigsInfo.hideValue(modifiedJson, "hostname");
            modifiedJson = ConfigsInfo.hideValue(modifiedJson, "database");
            modifiedJson = ConfigsInfo.hideValue(modifiedJson, "password");
            modifiedJson = ConfigsInfo.hideValue(modifiedJson, "address");
            modifiedJson = ConfigsInfo.hideValue(modifiedJson, "stats");
            modifiedJson = ConfigsInfo.hidePossibleAddresses(modifiedJson);
            return mapper.readValue(modifiedJson, new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String hideValue(String json, String key) {
        return json.replaceAll("((\"" + key + "\"):( ?)(\".*?\"))", "\"" + key + "\":\"HIDDEN\"");
    }

    private static String hidePossibleAddresses(String json) {
        json = json.replaceAll("([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}):?([0-9]{1,5})?", "HIDDEN");
        return json.replaceAll(InetSocketUtil.IP_V_6_PATTERN.pattern(), "HIDDEN");
    }

    public static Map<String, Object> parseJsonMapFromConfig(YamlSerializable yamlSerializable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JsonWriter writer = new JsonWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.UTF_8)), yamlSerializable.getConfig());
        writer.writeNode(yamlSerializable, null);
        writer.flush();
        String string = byteArrayOutputStream.toString(StandardCharsets.UTF_8);
        return (Map)new Gson().fromJson(string, new TypeToken<Map<String, Object>>(){}.getType());
    }

    public Map<String, Object> getBungeecordConfig() {
        return this.bungeecordConfig;
    }

    public Map<String, Object> getWaterfallConfig() {
        return this.waterfallConfig;
    }

    public Map<String, Object> getNullcordxConfig() {
        return this.nullcordxConfig;
    }

    public Map<String, Object> getAntibotConfig() {
        return this.antibotConfig;
    }

    public Map<String, Object> getCaptchaConfig() {
        return this.captchaConfig;
    }

    public Map<String, Object> getMotdConfig() {
        return this.motdConfig;
    }

    public Map<String, Object> getSqlConfig() {
        return this.sqlConfig;
    }

    public List<MessagesConfig> getMessagesConfig() {
        return this.messagesConfig;
    }
}

