/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.apache.commons.net.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.shieldcommunity.nullcordx.libs.apache.commons.net.io.FromNetASCIIInputStream;

public final class FromNetASCIIOutputStream
extends FilterOutputStream {
    private boolean lastWasCR = false;

    public FromNetASCIIOutputStream(OutputStream output) {
        super(output);
    }

    @Override
    public synchronized void close() throws IOException {
        if (FromNetASCIIInputStream._noConversionRequired) {
            super.close();
            return;
        }
        if (this.lastWasCR) {
            this.out.write(13);
        }
        super.close();
    }

    @Override
    public synchronized void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public synchronized void write(byte[] buffer, int offset, int length) throws IOException {
        if (FromNetASCIIInputStream._noConversionRequired) {
            this.out.write(buffer, offset, length);
            return;
        }
        while (length-- > 0) {
            this.writeInt(buffer[offset++]);
        }
    }

    @Override
    public synchronized void write(int ch) throws IOException {
        if (FromNetASCIIInputStream._noConversionRequired) {
            this.out.write(ch);
            return;
        }
        this.writeInt(ch);
    }

    private void writeInt(int ch) throws IOException {
        switch (ch) {
            case 13: {
                this.lastWasCR = true;
                break;
            }
            case 10: {
                if (this.lastWasCR) {
                    this.out.write(FromNetASCIIInputStream._lineSeparatorBytes);
                    this.lastWasCR = false;
                    break;
                }
                this.out.write(10);
                break;
            }
            default: {
                if (this.lastWasCR) {
                    this.out.write(13);
                    this.lastWasCR = false;
                }
                this.out.write(ch);
            }
        }
    }
}

