/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.elytrium.serializer.language.writer;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.lang.reflect.Field;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.SerializerConfig;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.Comment;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.YamlStringStyle;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.language.object.YamlSerializable;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.language.writer.AbstractWriter;

public class YamlWriter
extends AbstractWriter {
    private final YamlSerializable yamlSerializable;
    private boolean first = true;
    private boolean tempDisableNewLine;
    private String singleIndent = "  ";
    private String currentIndent = "";
    private boolean waitingForEntryValue;

    public YamlWriter(SerializerConfig config, BufferedWriter writer) {
        super(config, writer);
        this.yamlSerializable = null;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public YamlWriter(SerializerConfig config, BufferedWriter writer, YamlSerializable serializable) {
        super(config, writer);
        this.yamlSerializable = serializable;
    }

    public YamlWriter(BufferedWriter writer) {
        super(writer);
        this.yamlSerializable = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeCommentStart(@Nullable Field owner, Comment.At at) {
        YamlWriter yamlWriter = this;
        synchronized (yamlWriter) {
            if (at == Comment.At.SAME_LINE) {
                this.writeRaw(" #");
            } else {
                this.writeRaw(this.currentIndent);
                this.writeRaw('#');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeCommentValueIndent(@Nullable Field owner, Comment.At at, int indent) {
        YamlWriter yamlWriter = this;
        synchronized (yamlWriter) {
            for (int i = 0; i < indent; ++i) {
                this.writeRaw(' ');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeCommentEnd(@Nullable Field owner, Comment.At at) {
        YamlWriter yamlWriter = this;
        synchronized (yamlWriter) {
            if (at != Comment.At.SAME_LINE) {
                this.writeLine();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeNodeName(@Nullable Field owner, String value) {
        YamlWriter yamlWriter = this;
        synchronized (yamlWriter) {
            this.writeIndent();
            this.writeString0(owner, value, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeEmptyMap(@Nullable Field owner) {
        YamlWriter yamlWriter = this;
        synchronized (yamlWriter) {
            this.writeRaw("{}");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBeginMap(@Nullable Field owner) {
        YamlWriter yamlWriter = this;
        synchronized (yamlWriter) {
            this.writeBeginCommon();
        }
    }

    @Override
    public void writeMapPreCommentEntryJoin(@Nullable Field owner) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeMapPostCommentEntryJoin(@Nullable Field owner) {
        YamlWriter yamlWriter = this;
        synchronized (yamlWriter) {
            this.writeLine();
        }
    }

    @Override
    public void writeMapEntryEnd(@Nullable Field owner) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeEndMap(@Nullable Field owner) {
        YamlWriter yamlWriter = this;
        synchronized (yamlWriter) {
            this.removeIndent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeEmptyCollection(@Nullable Field owner) {
        YamlWriter yamlWriter = this;
        synchronized (yamlWriter) {
            this.writeRaw("[]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBeginCollection(@Nullable Field owner) {
        YamlWriter yamlWriter = this;
        synchronized (yamlWriter) {
            this.writeBeginCommon();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeCollectionEntry(@Nullable Field owner, Object entry) {
        YamlWriter yamlWriter = this;
        synchronized (yamlWriter) {
            this.writeIndent();
            this.writeRaw("- ");
            this.setTempDisableNewLine();
            this.writeNode(entry, null);
            this.unsetTempDisableNewLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeCollectionEntryJoin(@Nullable Field owner) {
        YamlWriter yamlWriter = this;
        synchronized (yamlWriter) {
            this.writeLine();
        }
    }

    @Override
    public void writeCollectionEntryEnd(@Nullable Field owner) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeEndCollection(@Nullable Field owner) {
        YamlWriter yamlWriter = this;
        synchronized (yamlWriter) {
            this.removeIndent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeString(@Nullable Field owner, String value) {
        YamlWriter yamlWriter = this;
        synchronized (yamlWriter) {
            this.writeString0(owner, value, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeCharacter(@Nullable Field owner, char value) {
        YamlWriter yamlWriter = this;
        synchronized (yamlWriter) {
            boolean shouldUseQuotes = YamlWriter.shouldUseQuotes(value, true, false);
            if (shouldUseQuotes) {
                this.writeRaw('\"');
            }
            this.writeCharacter0(value, true);
            if (shouldUseQuotes) {
                this.writeRaw('\"');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeLine() {
        YamlWriter yamlWriter = this;
        synchronized (yamlWriter) {
            super.writeRaw(this.config.getLineSeparator());
        }
    }

    private void writeString0(@Nullable Field owner, String value, boolean nodeName) {
        if (value.isEmpty()) {
            if (nodeName) {
                this.writeRaw("\"\":");
                this.waitingForEntryValue = true;
            } else {
                this.writeRaw("\"\"");
            }
        } else {
            StringStyle style = null;
            if (nodeName) {
                style = StringStyle.NOT_QUOTED;
            } else {
                StringStyle savedStyle;
                YamlStringStyle styleAnnotation = null;
                if (owner != null) {
                    styleAnnotation = owner.getAnnotation(YamlStringStyle.class);
                }
                if (this.yamlSerializable != null && (savedStyle = this.yamlSerializable.getStringStyle(owner)) != null) {
                    style = savedStyle;
                }
                if (styleAnnotation != null && (style == null || styleAnnotation.override())) {
                    style = styleAnnotation.value();
                }
                if (style == null) {
                    style = StringStyle.DOUBLE_QUOTED;
                }
            }
            style.write(this, value);
            if (nodeName) {
                this.writeRaw(':');
                this.waitingForEntryValue = true;
            }
        }
    }

    private void writeCharacters(char[] characters) {
        this.writeCharacters(characters, false, false, true, true, true);
    }

    private void writeCharacters(char[] characters, boolean firstNewLine, boolean singleQuotes2Double, boolean escapeNewLine, boolean doubleNewLine, boolean escapeSpecial) {
        this.addIndent();
        if (firstNewLine) {
            this.writeLineAndIndent();
        }
        char[] lineSeparatorChars = this.config.getLineSeparatorChars();
        int lineSeparatorCharsCaught = 0;
        char highSurrogate = '\u0000';
        for (char character : characters) {
            if (singleQuotes2Double && character == '\'') {
                this.writeRaw("''");
                continue;
            }
            if (!escapeNewLine) {
                if (character == '\n' || character == lineSeparatorChars[lineSeparatorCharsCaught]) {
                    if (character != '\n' && ++lineSeparatorCharsCaught != lineSeparatorChars.length) continue;
                    lineSeparatorCharsCaught = 0;
                    this.writeLineAndIndent();
                    if (!doubleNewLine) continue;
                    this.writeLineAndIndent();
                    continue;
                }
                for (int i = 0; i < lineSeparatorCharsCaught; ++i) {
                    this.writeCharacter0(lineSeparatorChars[i], escapeSpecial);
                }
                lineSeparatorCharsCaught = 0;
            }
            if (highSurrogate != '\u0000') {
                this.writeCharacter0(Character.toCodePoint(highSurrogate, character), escapeSpecial);
                highSurrogate = '\u0000';
                continue;
            }
            if (Character.isHighSurrogate(character)) {
                highSurrogate = character;
                continue;
            }
            this.writeCharacter0(character, escapeSpecial);
        }
        if (highSurrogate != '\u0000') {
            this.writeCharacter0(highSurrogate, escapeSpecial);
        }
        this.removeIndent();
    }

    private void writeCharacter0(int value, boolean escapeSpecial) {
        switch (value) {
            case 0: {
                this.writeRaw("\\0");
                break;
            }
            case 7: {
                this.writeRaw("\\a");
                break;
            }
            case 8: {
                this.writeRaw("\\b");
                break;
            }
            case 9: {
                this.writeRaw("\\t");
                break;
            }
            case 10: {
                this.writeRaw("\\n");
                break;
            }
            case 11: {
                this.writeRaw("\\v");
                break;
            }
            case 12: {
                this.writeRaw("\\f");
                break;
            }
            case 13: {
                this.writeRaw("\\r");
                break;
            }
            case 27: {
                this.writeRaw("\\e");
                break;
            }
            case 92: {
                this.writeRaw("\\\\");
                break;
            }
            case 133: {
                this.writeRaw("\\N");
                break;
            }
            case 160: {
                this.writeRaw("\\_");
                break;
            }
            case 8232: {
                this.writeRaw("\\L");
                break;
            }
            case 8233: {
                this.writeRaw("\\P");
                break;
            }
            case 34: {
                if (escapeSpecial) {
                    this.writeRaw("\\\"");
                    break;
                }
                this.writeRaw('\"');
                break;
            }
            default: {
                if (Character.isIdentifierIgnorable(value) && !this.config.isAllowUnicode()) {
                    if (value <= 255) {
                        this.writeRaw("\\x");
                        String result = "0" + Integer.toString(value, 16);
                        this.writeRaw(result.substring(result.length() - 2));
                        break;
                    }
                    if (Character.charCount(value) == 2) {
                        this.writeRaw("\\U");
                        String result = "000" + Long.toHexString(value);
                        this.writeRaw(result.substring(result.length() - 8));
                        break;
                    }
                    this.writeRaw("\\u");
                    String result = "000" + Integer.toString(value, 16);
                    this.writeRaw(result.substring(result.length() - 4));
                    break;
                }
                if (Character.isBmpCodePoint(value)) {
                    this.writeRaw((char)value);
                    break;
                }
                this.writeRaw(Character.highSurrogate(value));
                this.writeRaw(Character.lowSurrogate(value));
            }
        }
    }

    private void writeBeginCommon() {
        if (this.first) {
            this.first = false;
        } else {
            this.addIndent();
            if (!this.tempDisableNewLine) {
                this.writeLine();
            }
        }
        this.waitingForEntryValue = false;
    }

    private void addIndent() {
        this.currentIndent = this.currentIndent + this.singleIndent;
    }

    private void removeIndent() {
        if (this.currentIndent.length() >= this.singleIndent.length()) {
            this.currentIndent = this.currentIndent.substring(this.singleIndent.length());
        }
    }

    private void writeIndent() {
        if (this.tempDisableNewLine) {
            this.unsetTempDisableNewLine();
        } else {
            this.writeRaw(this.currentIndent);
        }
    }

    private void writeLineAndIndent() {
        this.writeLine();
        this.writeIndent();
    }

    private void setTempDisableNewLine() {
        this.tempDisableNewLine = true;
    }

    private void unsetTempDisableNewLine() {
        this.tempDisableNewLine = false;
    }

    @Override
    public void writeRaw(String value) {
        if (this.waitingForEntryValue) {
            this.waitingForEntryValue = false;
            super.writeRaw(' ');
        }
        super.writeRaw(value);
    }

    @Override
    public void writeRaw(char value) {
        if (this.waitingForEntryValue) {
            this.waitingForEntryValue = false;
            super.writeRaw(' ');
        }
        super.writeRaw(value);
    }

    public void setSingleIndent(String singleIndent) {
        this.singleIndent = singleIndent;
    }

    private static boolean shouldUseQuotes(char[] characters, boolean avoidSpecial, boolean ignoreSingleQuotes) {
        for (char character : characters) {
            if (!YamlWriter.shouldUseQuotes(character, avoidSpecial, ignoreSingleQuotes)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldUseQuotes(char value, boolean avoidSpecial, boolean ignoreSingleQuotes) {
        return avoidSpecial && (value == ' ' || value == '#' || value == '\"') || !ignoreSingleQuotes && value == '\'' || value == '\u0000' || value == '\u0007' || value == '\b' || value == '\t' || value == '\n' || value == '\u000b' || value == '\f' || value == '\r' || value == '\u001b' || value == '\\' || value == '\u0085' || value == '\u00a0' || value == '\u2028' || value == '\u2029';
    }

    public static enum StringStyle {
        NOT_QUOTED((writer, string) -> {
            char[] characters = string.toCharArray();
            boolean shouldUseQuotes = YamlWriter.shouldUseQuotes(characters, true, false);
            if (shouldUseQuotes) {
                writer.writeRaw('\"');
            }
            ((YamlWriter)writer).writeCharacters(characters);
            if (shouldUseQuotes) {
                writer.writeRaw('\"');
            }
        }),
        SINGLE_QUOTED((writer, string) -> {
            char[] characters = string.toCharArray();
            boolean shouldUseQuotes = YamlWriter.shouldUseQuotes(characters, false, true);
            writer.writeRaw(shouldUseQuotes ? (char)'\"' : (char)'\'');
            ((YamlWriter)writer).writeCharacters(characters, false, true, false, true, shouldUseQuotes);
            writer.writeRaw(shouldUseQuotes ? (char)'\"' : (char)'\'');
        }),
        DOUBLE_QUOTED((writer, string) -> {
            writer.writeRaw('\"');
            ((YamlWriter)writer).writeCharacters(string.toCharArray(), false, false, true, true, true);
            writer.writeRaw('\"');
        }),
        DOUBLE_QUOTED_MULTILINE((writer, string) -> {
            writer.writeRaw('\"');
            ((YamlWriter)writer).writeCharacters(string.toCharArray(), false, false, false, true, true);
            writer.writeRaw('\"');
        }),
        MULTILINE_FOLDED_AUTO_CLIPPED((writer, string) -> {
            if (!string.endsWith(writer.config.getLineSeparator())) {
                writer.writeRaw(">-");
            } else if (string.endsWith(writer.config.getDoubledLineSeparator())) {
                writer.writeRaw(">+");
            } else {
                writer.writeRaw('>');
            }
            ((YamlWriter)writer).writeCharacters(string.toCharArray(), true, false, false, true, false);
        }),
        MULTILINE_FOLDED_STRIPPED((writer, string) -> {
            if (string.endsWith(writer.config.getLineSeparator())) {
                throw new IllegalStateException("This string type can't contain new lines at the end");
            }
            writer.writeRaw(">-");
            ((YamlWriter)writer).writeCharacters(string.toCharArray(), true, false, false, true, false);
        }),
        MULTILINE_FOLDED_AUTO_KEPT((writer, string) -> {
            writer.writeRaw(string.endsWith(writer.config.getLineSeparator()) ? ">+" : ">-");
            ((YamlWriter)writer).writeCharacters(string.toCharArray(), true, false, false, true, false);
        }),
        MULTILINE_LITERAL_AUTO_CLIPPED((writer, string) -> {
            if (!string.endsWith(writer.config.getLineSeparator())) {
                writer.writeRaw("|-");
            } else if (string.endsWith(writer.config.getDoubledLineSeparator())) {
                writer.writeRaw("|+");
            } else {
                writer.writeRaw('|');
            }
            ((YamlWriter)writer).writeCharacters(string.toCharArray(), true, false, false, false, false);
        }),
        MULTILINE_LITERAL_STRIPPED((writer, string) -> {
            if (string.endsWith(writer.config.getLineSeparator())) {
                throw new IllegalStateException("This string type can't contain new lines at the end");
            }
            writer.writeRaw("|-");
            ((YamlWriter)writer).writeCharacters(string.toCharArray(), true, false, false, false, false);
        }),
        MULTILINE_LITERAL_AUTO_KEPT((writer, string) -> {
            writer.writeRaw(string.endsWith(writer.config.getLineSeparator()) ? "|+ " : "|- ");
            ((YamlWriter)writer).writeCharacters(string.toCharArray(), true, false, false, false, false);
        });

        private final BiConsumer<YamlWriter, String> writeFunction;

        private StringStyle(BiConsumer<YamlWriter, String> writeFunction) {
            this.writeFunction = writeFunction;
        }

        public void write(YamlWriter writer, String string) {
            this.writeFunction.accept(writer, string);
        }
    }
}

